/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.utils.DebugLevel;

public class InternalPBKeyCandidate
implements ICandidate {
    private InternalCandidateAddress m_address;

    public InternalPBKeyCandidate(InternalCandidateAddress address) {
        int segmentSide;
        this.m_address = address;
        Segment segment = this.m_address.getSegment();
        int leftRanges = segment.getRangeCount(0);
        int n = segmentSide = leftRanges > 0 ? 0 : 1;
        if (segment.getRangeCount(segmentSide) > 0) {
            this.m_address.setSegmentSide(segmentSide);
            this.m_address.setMatchedRangeNumber(0);
            Range rng = segment.getRangeAt(0, segmentSide);
            if (rng == null) {
                return;
            }
            rng.setMatchedRangeNumber(rng.getParsedFrom());
        }
    }

    @Override
    public boolean isCloseMatch() {
        return true;
    }

    @Override
    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) throws MapMarkerInternalException {
        this.m_address.setAddressNumber(this.m_address.getSegment().getRangeAt(0, 0).getLowNumber());
        CandidateAddress candidate = new CandidateAddress(this.m_address);
        candidate.setCloseMatch();
        candidate.setConfiguredDictionaryNumber(this.m_address.getDictionaryPriority() + 1);
        candidate.setFormattedStreetAddress(this.m_address.getFormattedStreetAddress());
        candidate.setFormattedLocationAddress(this.m_address.getFormattedLocationAddress());
        this.m_address.setGeocodedPoint(candidate, DebugLevel.getDebugLevel(1), constraints, this.m_address.loadResourceBundleForLocale(constraints.getClientLocale()));
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", "S8A");
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.m_address.getVendorCode());
        candidate.setSourceStreetID(this.m_address.getStreetOffset());
        if (constraints.getMaxRanges() != 0) {
            this.addRanges(candidate, constraints);
        }
        return candidate;
    }

    public InternalCandidateAddress getAddress() {
        return this.m_address;
    }

    protected void addRanges(CandidateAddress candidate, IConstraints constraints) {
        Range rng = this.m_address.getSegment().getRangeAt(this.m_address.getMatchedRangeNumber(), this.m_address.getSegmentSide());
        if (rng != null) {
            candidate.addCandidateRange(rng.toCandidateRange(this.m_address.getParsedAddressNumber(), this.m_address.getSegmentSide()));
            candidate.setNumberOfReturnableRanges(1);
        }
    }
}

