/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.geometry.DirectPosition;

public class InternalPostalCandidate
implements ICandidate,
Comparable {
    private String m_postalCode1 = null;
    private String m_postalCode2 = null;
    private String m_genericField1 = null;
    private String m_country = null;
    private String m_areaName1 = null;
    private String m_areaName2 = null;
    private String m_areaName3 = null;
    private String m_areaName4 = null;
    private String m_coordSysInfo = null;
    private DirectPosition m_point = new DirectPosition();
    private int m_matchLevel = 0;
    private double m_postalCode1Score = 0.0;
    private double m_postalCode2Score = 0.0;
    private double m_combinedScore = 0.0;
    private boolean m_closeMatchFlag = true;
    private boolean m_fromUserDictionary;
    private boolean m_dictionaryBonus;
    private int m_configDictionaryNumber;
    private int m_userDictionaryPriority;
    private String m_vendorCode;

    public String getPostCode1() {
        return this.m_postalCode1;
    }

    public void setPostCode1(String postalCode1) {
        this.m_postalCode1 = postalCode1;
    }

    public String getPostCode2() {
        return this.m_postalCode2;
    }

    public void setPostCode2(String postalCode2) {
        this.m_postalCode2 = postalCode2;
    }

    public String getGenericField1() {
        return this.m_genericField1;
    }

    public void setGenericField1(String genericField1) {
        this.m_genericField1 = genericField1;
    }

    public String getCountry() {
        return this.m_country;
    }

    public void setCountry(String country) {
        this.m_country = country;
    }

    public String getAreaName1() {
        return this.m_areaName1;
    }

    public void setAreaName1(String areaName1) {
        this.m_areaName1 = areaName1;
    }

    public String getAreaName2() {
        return this.m_areaName2;
    }

    public void setAreaName2(String areaName2) {
        this.m_areaName2 = areaName2;
    }

    public String getAreaName3() {
        return this.m_areaName3;
    }

    public void setAreaName3(String areaName3) {
        this.m_areaName3 = areaName3;
    }

    public String getAreaName4() {
        return this.m_areaName4;
    }

    public void setAreaName4(String areaName4) {
        this.m_areaName4 = areaName4;
    }

    public String getCoordSysInfo() {
        return this.m_coordSysInfo;
    }

    public void setCoordSysInfo(String coordSysInfo) {
        this.m_coordSysInfo = coordSysInfo;
    }

    public int getMatchLevel() {
        return this.m_matchLevel;
    }

    public void setMatchLevel(int matchLevel) {
        this.m_matchLevel = matchLevel >= 0 && matchLevel <= 5 ? matchLevel : 0;
    }

    public DirectPosition getPoint() {
        return this.m_point;
    }

    public void setPoint(DirectPosition point) {
        this.m_point = point;
    }

    public void setPostCode1Score(double score) {
        this.m_postalCode1Score = score;
    }

    public double getPostCode1Score() {
        return this.m_postalCode1Score;
    }

    public void setPostCode2Score(double score) {
        this.m_postalCode2Score = score;
    }

    public double getPostCode2Score() {
        return this.m_postalCode2Score;
    }

    public void setCombinedScore(double score) {
        this.m_combinedScore = score;
    }

    public double getCombinedScore() {
        return this.m_combinedScore;
    }

    public void scoreCandidate(Address input) {
        this.scorePostCode1(input);
        this.scorePostCode2(input);
    }

    public void scorePostCode1(Address input) {
        if (this.getPostCode1().equals(input.getPostCode1())) {
            this.setPostCode1Score(1.0);
        }
    }

    public void scorePostCode2(Address input) {
        if (input.getPostCode2() == null && this.getPostCode2() == null) {
            this.setPostCode2Score(1.0);
            return;
        }
        if (input.getPostCode2() == null || this.getPostCode2() == null) {
            this.setPostCode2Score(0.0);
            return;
        }
        if (this.getPostCode2().equals(input.getPostCode2())) {
            this.setPostCode2Score(1.0);
        } else if (input.getPostCode2().length() == 0) {
            this.setPostCode2Score(0.5);
        }
    }

    @Override
    public boolean isCloseMatch() {
        return this.m_closeMatchFlag;
    }

    public void setCloseMatchOff() {
        this.m_closeMatchFlag = false;
    }

    public boolean fromUserDictionary() {
        return this.m_fromUserDictionary;
    }

    public void setFromUserDictionary() {
        this.m_fromUserDictionary = true;
    }

    public boolean equals(Object obj) {
        InternalPostalCandidate that = (InternalPostalCandidate)obj;
        return this.getPostCode1Score() == that.getPostCode1Score() && this.getPostCode2Score() == that.getPostCode2Score() && this.hasDictionaryBonus() == that.hasDictionaryBonus();
    }

    public int compareTo(Object obj2) {
        InternalPostalCandidate candidate2 = (InternalPostalCandidate)obj2;
        if (this.equals(candidate2)) {
            return 0;
        }
        if (this.isCloseMatch() && !candidate2.isCloseMatch()) {
            return 1;
        }
        if (!this.isCloseMatch() && candidate2.isCloseMatch()) {
            return -1;
        }
        if (this.isCloseMatch() && candidate2.isCloseMatch() && this.hasDictionaryBonus() != candidate2.hasDictionaryBonus()) {
            if (this.hasDictionaryBonus()) {
                return 1;
            }
            return -1;
        }
        if (this.getPostCode1Score() < candidate2.getPostCode1Score()) {
            return -1;
        }
        if (this.getPostCode1Score() > candidate2.getPostCode1Score()) {
            return 1;
        }
        if (this.getPostCode1Score() == candidate2.getPostCode1Score()) {
            if (this.getPostCode2Score() < candidate2.getPostCode2Score()) {
                return -1;
            }
            if (this.getPostCode2Score() > candidate2.getPostCode2Score()) {
                return 1;
            }
            if (this.hasDictionaryBonus() != candidate2.hasDictionaryBonus()) {
                if (this.hasDictionaryBonus()) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    @Override
    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress candidate = new CandidateAddress();
        candidate.setCountry(this.getCountry());
        candidate.setAreaName1(this.getAreaName1());
        candidate.setAreaName2(this.getAreaName2());
        candidate.setAreaName3(this.getAreaName3());
        candidate.setAreaName4(this.getAreaName4());
        candidate.setPostCode1(this.getPostCode1());
        candidate.setPostCode2(this.getPostCode2());
        candidate.setGenericField1(this.getGenericField1());
        candidate.setLocation(CoordConvertor.transformPointFromWGS84(constraints.getClientCoordinateSystemObject(), this.getPoint()));
        candidate.setLocationPrecision(this.getMatchLevel());
        String csys = this.getCoordSysInfo();
        if (csys == null && constraints.getClientCoordinateSystemObject() != null) {
            csys = MidevConversionUtils.getSRSname(constraints.getClientCoordinateSystemObject());
        }
        candidate.setCoordSysString(csys);
        if (this.getPostCode1Score() == 1.0) {
            candidate.setPostalCode1Matched();
        }
        if (this.getPostCode2Score() == 1.0) {
            candidate.setPostalCode2Matched();
        }
        if (parsed.getAreaName1() != null && parsed.getAreaName1().equals(this.getAreaName1())) {
            candidate.setAreaName1Matched();
        }
        if (parsed.getAreaName2() != null && parsed.getAreaName2().equals(this.getAreaName2())) {
            candidate.setAreaName2Matched();
        }
        if (parsed.getAreaName3() != null && parsed.getAreaName3().equals(this.getAreaName3())) {
            candidate.setAreaName3Matched();
        }
        if (parsed.getAreaName4() != null && parsed.getAreaName4().equals(this.getAreaName4())) {
            candidate.setAreaName4Matched();
        }
        if (parsed.getCountry() != null && parsed.getCountry().equals(this.getCountry())) {
            candidate.setCountryMatched();
        }
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return candidate;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("InternalPostalCandidateAddress: \n");
        buffer.append("\tPostalCode1: ");
        buffer.append(this.getPostCode1());
        buffer.append("\n");
        buffer.append("\tPostalCode2: ");
        buffer.append(this.getPostCode2());
        buffer.append("\n");
        buffer.append("\tGenericField1: ");
        buffer.append(this.getGenericField1());
        buffer.append("\n");
        buffer.append("\tAreaName1: ");
        buffer.append(this.getAreaName1());
        buffer.append("\n");
        buffer.append("\tAreaName2: ");
        buffer.append(this.getAreaName2());
        buffer.append("\n");
        buffer.append("\tAreaName3: ");
        buffer.append(this.getAreaName3());
        buffer.append("\n");
        buffer.append("\tAreaName4: ");
        buffer.append(this.getAreaName4());
        buffer.append("\n");
        buffer.append("\tCountry: ");
        buffer.append(this.getCountry());
        buffer.append("\n");
        buffer.append("\tPoint: ");
        buffer.append(this.getPoint().toString());
        buffer.append("\n");
        buffer.append("\tMatch Level: ");
        buffer.append(this.getMatchLevel());
        buffer.append("\n");
        buffer.append("\tCoord Sys Info: ");
        buffer.append(this.getCoordSysInfo());
        buffer.append("\n");
        buffer.append("\tScores:\n");
        buffer.append("\t\tPostalCode1 Score: ");
        buffer.append(this.getPostCode1Score());
        buffer.append("\n");
        buffer.append("\t\tPostalCode2 Score: ");
        buffer.append(this.getPostCode2Score());
        buffer.append("\n");
        buffer.append("\t\tCombined Score: ");
        buffer.append(this.getCombinedScore());
        buffer.append("\n");
        buffer.append("\t\tIs CloseMatch? ");
        buffer.append(this.isCloseMatch());
        buffer.append("\n");
        buffer.append("\tFromUserDictionary? ");
        buffer.append(this.fromUserDictionary());
        buffer.append("\n");
        buffer.append("\tHasBonus? ");
        buffer.append(this.hasDictionaryBonus());
        buffer.append("\n");
        return buffer.toString();
    }

    public String buildPrecisionCode(CandidateAddress cand) {
        int precision = cand.getLocationPrecision();
        if (precision == 3) {
            return "Z1";
        }
        if (precision == 4) {
            return "Z2";
        }
        if (precision == 5) {
            return "Z3";
        }
        return "";
    }

    public void setDictionaryBonus() {
        this.m_dictionaryBonus = true;
    }

    public boolean hasDictionaryBonus() {
        return this.m_dictionaryBonus;
    }

    public void setDictionaryPriority(int dictNumber) {
        this.m_configDictionaryNumber = dictNumber;
    }

    public int getDictionaryPriority() {
        return this.m_configDictionaryNumber;
    }

    public void setUserDictionaryPriority(int priority) {
        this.m_userDictionaryPriority = priority;
    }

    public int getUserDictionaryPriority() {
        return this.m_userDictionaryPriority;
    }

    public void setVendorCode(String vendorCode) {
        this.m_vendorCode = vendorCode;
    }

    public String getVendorCode() {
        return this.m_vendorCode;
    }
}

