/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.IStandardizeCandidate;

public class InternalStandardizedAddress
extends AddressImpl
implements IStandardizeCandidate {
    private Address m_inputAddress;

    public InternalStandardizedAddress() {
    }

    public InternalStandardizedAddress(Address address) {
        super(address);
        if (address instanceof InternalStandardizedAddress) {
            InternalStandardizedAddress internalStandardizedAddress = (InternalStandardizedAddress)address;
            this.m_inputAddress = internalStandardizedAddress.m_inputAddress;
        }
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("InternalStandardizedAddress strings:\n");
        str.append(super.toString());
        return str.toString();
    }

    @Override
    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress candidate = new CandidateAddress(this);
        candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        return candidate;
    }

    public String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getAreaName3();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getAreaName1()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostCode1()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostCode2()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public String getFormattedStreetAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getAddressNumber();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPreAddress()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPreThoroughfareType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getMainAddress()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostThoroughfareType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostAddress()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getUnitValue()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getUnitType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    @Override
    public boolean isCloseMatch() {
        return true;
    }

    @Override
    public void setInputAddress(Address addr) {
        this.m_inputAddress = addr;
    }

    @Override
    public Address getInputAddress() {
        return this.m_inputAddress;
    }
}

