/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.DictionarySearchOrder;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.user.GeocodeConstraints;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeConstraints;
import com.mapinfo.mapmarker.utils.ISO639;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;

public class MMJCommonXMLReader {
    private LinearUnit makeLinearUnit(String code) throws MMGeneralGeocoderException {
        LinearUnit unit = MidevConversionUtils.getLinearUnitFromAbbreviation(code);
        if (unit != null) {
            return unit;
        }
        throw new MMGeneralGeocoderException(2310);
    }

    public static CoordSys buildCoordSysFromXML(Element element) {
        Element idElement = element.getChild("Identifier");
        String code = idElement.getChild("code").getText();
        String codespace = idElement.getChild("codeSpace").getText();
        Object csys = null;
        if (!StringUtilities.isEmpty(code) && !StringUtilities.isEmpty(codespace)) {
            return CoordSysFactory.getDefaultCoordSysFactory().getCoordSys(codespace, code);
        }
        return null;
    }

    protected Address readUniversalAddressXML(Element addressElement) {
        AddressImpl address = new AddressImpl();
        if (addressElement != null) {
            Element tmpElement = addressElement.getChild("AdditionalFields");
            if (tmpElement != null) {
                this.readAdditionalFieldsXML(tmpElement, address.getAdditionalFields());
            }
            if ((tmpElement = addressElement.getChild("AddressNumber")) != null) {
                address.setAddressNumber(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("AreaName1")) != null) {
                address.setAreaName1(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("AreaName2")) != null) {
                address.setAreaName2(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("AreaName3")) != null) {
                address.setAreaName3(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("AreaName4")) != null) {
                address.setAreaName4(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("Country")) != null) {
                address.setCountry(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("GenericField1")) != null) {
                address.setGenericField1(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("GenericField2")) != null) {
                address.setGenericField2(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("GenericField3")) != null) {
                address.setGenericField3(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("GenericField4")) != null) {
                address.setGenericField4(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("MainAddress")) != null) {
                address.setMainAddress(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("placeName")) != null) {
                address.setPlaceName(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("postAddress")) != null) {
                address.setPostAddress(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("postCode1")) != null) {
                address.setPostCode1(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("postCode2")) != null) {
                address.setPostCode2(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("postDirectional")) != null) {
                address.setPostDirectional(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("postThoroughfareType")) != null) {
                address.setPostThoroughfareType(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("preAddress")) != null) {
                address.setPreAddress(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("preDirectional")) != null) {
                address.setPreDirectional(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("preThoroughfareType")) != null) {
                address.setPreThoroughfareType(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("unitType")) != null) {
                address.setUnitType(tmpElement.getText());
            }
            if ((tmpElement = addressElement.getChild("unitValue")) != null) {
                address.setUnitValue(tmpElement.getText());
            }
        }
        return address;
    }

    protected void readAdditionalFieldsXML(Element tmpElement, Map addFlds) {
        for (Element kvpElement : tmpElement.getChildren("KeyValuePair")) {
            String key = kvpElement.getChild("Key").getText();
            String value = kvpElement.getChild("Value").getText();
            addFlds.put(key, value);
        }
    }

    protected IGeocodeConstraints readGeocodeConstraintsXML(Element elConstraints, IGeocodeConstraints constraints) {
        GeocodeConstraints result = new GeocodeConstraints(constraints);
        if (elConstraints != null) {
            Element elAdditionalConstraints;
            Element elBaseConstraints = elConstraints.getChild("BaseConstraints");
            if (elBaseConstraints != null) {
                Element tmpElement;
                String tmpAttr = elBaseConstraints.getAttributeValue("fallbackToPostalCentroid");
                if (tmpAttr != null) {
                    result.setFallbackToPostal(tmpAttr.equalsIgnoreCase("true"));
                }
                if ((tmpAttr = elBaseConstraints.getAttributeValue("fallbackToGeographicCentroid")) != null) {
                    result.setFallbackToGeographic(tmpAttr.equalsIgnoreCase("true"));
                }
                if ((tmpAttr = elBaseConstraints.getAttributeValue("closeMatchesOnly")) != null) {
                    result.setReturnCloseCandidatesOnly(tmpAttr.equalsIgnoreCase("true"));
                }
                if ((tmpAttr = elBaseConstraints.getAttributeValue("requestType")) != null) {
                    result.setGeocodeType(Integer.parseInt(tmpAttr));
                }
                if ((tmpAttr = elBaseConstraints.getAttributeValue("clientLocale")) != null) {
                    result.setClientLocale(tmpAttr);
                }
                if ((tmpAttr = elBaseConstraints.getAttributeValue("dictionaryUsage")) != null) {
                    try {
                        if ("AD_ONLY".equalsIgnoreCase(tmpAttr)) {
                            result.setDictionaryUsage(DictionaryUsagePreference.AD_ONLY);
                        } else if ("UD_ONLY".equalsIgnoreCase(tmpAttr)) {
                            result.setDictionaryUsage(DictionaryUsagePreference.UD_ONLY);
                        } else if ("AD_AND_UD".equalsIgnoreCase(tmpAttr)) {
                            result.setDictionaryUsage(DictionaryUsagePreference.AD_AND_UD);
                        } else if ("PREFER_UD".equalsIgnoreCase(tmpAttr)) {
                            result.setDictionaryUsage(DictionaryUsagePreference.PREFER_UD);
                        } else if ("PREFER_AD".equalsIgnoreCase(tmpAttr)) {
                            result.setDictionaryUsage(DictionaryUsagePreference.PREFER_AD);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((tmpAttr = elBaseConstraints.getAttributeValue("addrPntInterp")) != null) {
                    result.setUseAddressPointInterpolation("true".equalsIgnoreCase(tmpAttr));
                }
                if ((tmpAttr = elBaseConstraints.getAttributeValue("ParsedInputReturn")) != null) {
                    result.setReturnParsedInputAddress("true".equalsIgnoreCase(tmpAttr));
                }
                if ((tmpElement = elBaseConstraints.getChild("maxCandidates")) != null && tmpElement.getText().length() != 0) {
                    result.setMaxCandidates(Integer.parseInt(tmpElement.getText()));
                }
                if ((tmpElement = elBaseConstraints.getChild("maxRanges")) != null && tmpElement.getText().length() != 0) {
                    result.setMaxRanges(Integer.parseInt(tmpElement.getText()));
                }
                if ((tmpElement = elBaseConstraints.getChild("maxRangeUnits")) != null && tmpElement.getText().length() != 0) {
                    result.setMaxRangeUnits(Integer.parseInt(tmpElement.getText()));
                }
                if ((tmpElement = elBaseConstraints.getChild("offsetFromCorner")) != null && tmpElement.getText().length() != 0) {
                    result.setCornerOffset(Double.parseDouble(tmpElement.getText()));
                    tmpAttr = tmpElement.getAttributeValue("unitsOfMeasure");
                    if (tmpAttr != null && tmpAttr.length() != 0) {
                        result.setCornerOffsetUnits(tmpAttr);
                    }
                }
                if ((tmpElement = elBaseConstraints.getChild("offsetFromStreet")) != null && tmpElement.getText().length() != 0) {
                    result.setStreetOffset(Double.parseDouble(tmpElement.getText()));
                    tmpAttr = tmpElement.getAttributeValue("unitsOfMeasure");
                    if (tmpAttr != null && tmpAttr.length() != 0) {
                        result.setStreetOffsetUnits(tmpAttr);
                    }
                }
                if ((tmpElement = elBaseConstraints.getChild("CoordinateReferenceSystem")) != null) {
                    try {
                        CoordSys csys = MMJCommonXMLReader.buildCoordSysFromXML(tmpElement);
                        result.setClientCoordinateSystem(csys);
                    }
                    catch (Exception csys) {
                        // empty catch block
                    }
                }
                if ((tmpElement = elBaseConstraints.getChild("DictionarySearchOrderResponse")) != null) {
                    try {
                        IDictionarySearchOrder order = this.readDictionarySearchOrderResponse(tmpElement);
                        result.setDictionarySearchOrder(order);
                    }
                    catch (Exception order) {
                        // empty catch block
                    }
                }
            }
            if ((elAdditionalConstraints = elConstraints.getChild("AdditionalConstraints")) != null) {
                for (Element elKeyValuePair : elAdditionalConstraints.getChildren("KeyValuePair")) {
                    Element elKey = elKeyValuePair.getChild("Key");
                    Element elValue = elKeyValuePair.getChild("Value");
                    if (elKey == null || elKey.getText().length() == 0 || elValue == null || elValue.getText().length() == 0) continue;
                    result.setCustomString(elKey.getText(), elValue.getText());
                }
            }
        }
        return result;
    }

    protected IDictionarySearchOrder readDictionarySearchOrderResponse(Element dictResponseElement) {
        DictionarySearchOrder order = null;
        int count = 0;
        Element responseCodeElement = dictResponseElement.getChild("DictionarySearchOrderListCount");
        if (responseCodeElement != null && responseCodeElement.getText().length() != 0) {
            count = Integer.parseInt(responseCodeElement.getText());
        }
        if (count > 0) {
            order = new DictionarySearchOrder(count);
            for (Element orderElement : dictResponseElement.getChildren("DictionarySearchOrderList")) {
                int cfgOrder = 0;
                int userOrder = 0;
                boolean bEnabled = true;
                boolean bUserDict = false;
                String desc = null;
                if (orderElement == null) continue;
                String tmpAttr = orderElement.getAttributeValue("CfgOrder");
                if (tmpAttr != null && tmpAttr.length() != 0) {
                    cfgOrder = Integer.parseInt(tmpAttr);
                }
                if ((tmpAttr = orderElement.getAttributeValue("AllowSearch")) != null && tmpAttr.length() != 0) {
                    bEnabled = Boolean.valueOf(tmpAttr);
                }
                if ((tmpAttr = orderElement.getAttributeValue("Description")) != null && tmpAttr.length() != 0) {
                    desc = tmpAttr;
                }
                if ((tmpAttr = orderElement.getAttributeValue("UserPriority")) != null && tmpAttr.length() != 0) {
                    userOrder = Integer.parseInt(tmpAttr);
                }
                if ((tmpAttr = orderElement.getAttributeValue("IsUserDictionary")) != null && tmpAttr.length() != 0) {
                    bUserDict = Boolean.valueOf(tmpAttr);
                }
                order.addDictionary(cfgOrder, bEnabled, desc, userOrder, bUserDict);
            }
        }
        return order;
    }

    protected final PointWithSRS parsePoint(Element point) throws MMGeneralGeocoderException {
        return new PointWithSRS(this.parseCoords(point.getChild("coord")), point.getAttributeValue("srsName"));
    }

    protected final DirectPosition parseCoords(Element coords) throws MMGeneralGeocoderException {
        if (coords == null) {
            throw new MMGeneralGeocoderException(2310);
        }
        String xValue = coords.getChildText("X");
        String yValue = coords.getChildText("Y");
        if (xValue == null || yValue == null) {
            throw new MMGeneralGeocoderException(2310);
        }
        try {
            return new DirectPosition(Double.parseDouble(xValue), Double.parseDouble(yValue));
        }
        catch (NumberFormatException NFEx) {
            throw new MMGeneralGeocoderException(2310);
        }
    }

    protected final IReverseGeocodeConstraints readReverseGeocodeConstraints(Element constraintsElement) throws MMGeneralGeocoderException {
        Element tmpElement;
        Element streetOffsetElm;
        Element cornerOffsetElm;
        Element maxRangeUnitsElement;
        Element DSOElement;
        if (constraintsElement == null) {
            return null;
        }
        ReverseGeocodeConstraints constraints = new ReverseGeocodeConstraints();
        String localeAttrValue = constraintsElement.getAttributeValue("locale");
        if (localeAttrValue != null) {
            constraints.setClientLocale(ISO639.getLocale(localeAttrValue));
            String sortLocaleAttrValue = constraintsElement.getAttributeValue("sortLocale");
            if (sortLocaleAttrValue != null) {
                constraints.setSortCandidatesUsingLocale(Boolean.valueOf(sortLocaleAttrValue));
            }
        }
        if ((DSOElement = constraintsElement.getChild("DictionarySearchOrderResponse")) != null) {
            constraints.setDictionarySearchOrder(this.readDictionarySearchOrderResponse(DSOElement));
        }
        if ((maxRangeUnitsElement = constraintsElement.getChild("maxRangeUnits")) != null) {
            try {
                try {
                    constraints.setMaxRangeUnits(Integer.parseInt(maxRangeUnitsElement.getText()));
                }
                catch (IllegalArgumentException IAEx) {
                    throw new MMGeneralGeocoderException(2310);
                }
            }
            catch (NumberFormatException NFEx) {
                throw new MMGeneralGeocoderException(2310);
            }
        }
        if ((cornerOffsetElm = constraintsElement.getChild("offsetFromCorner")) != null) {
            constraints.setCornerOffset(this.readOffset(cornerOffsetElm));
        }
        if ((streetOffsetElm = constraintsElement.getChild("offsetFromStreet")) != null) {
            constraints.setStreetOffset(this.readOffset(streetOffsetElm));
        }
        if ((tmpElement = constraintsElement.getChild("AdditionalFields")) != null) {
            HashMap temp = new HashMap();
            this.readAdditionalFieldsXML(tmpElement, temp);
            for (Map.Entry e : temp.entrySet()) {
                constraints.setCustomString((String)e.getKey(), (String)e.getValue());
            }
        }
        return constraints;
    }

    private Length readOffset(Element offsetElement) throws MMGeneralGeocoderException {
        try {
            String tmpAttr = offsetElement.getAttributeValue("unitsOfMeasure").trim();
            LinearUnit unit = MidevConversionUtils.getLinearUnit(tmpAttr);
            if (unit.equals((Object)LinearUnit.METER) && !tmpAttr.equalsIgnoreCase("m")) {
                throw new MMGeneralGeocoderException(2310);
            }
            String value = offsetElement.getText().trim();
            if (value.length() == 0) {
                throw new MMGeneralGeocoderException(2310);
            }
            return new Length(Double.parseDouble(value), unit);
        }
        catch (IllegalArgumentException IAEx) {
            throw new MMGeneralGeocoderException(2310);
        }
    }

    protected Length readDistance(Element element) throws MMGeneralGeocoderException {
        try {
            double value = Double.parseDouble(element.getText());
            LinearUnit unit = this.makeLinearUnit(element.getAttributeValue("unitsOfMeasure"));
            if (unit != null) {
                return new Length(value, unit);
            }
            throw new MMGeneralGeocoderException(2310);
        }
        catch (NumberFormatException NFEx) {
            throw new MMGeneralGeocoderException(2310);
        }
    }

    protected static final class PointWithSRS {
        private DirectPosition m_point;
        private String m_SRS;

        private PointWithSRS(DirectPosition point, String SRS) {
            this.m_point = point;
            this.m_SRS = SRS;
        }

        public DirectPosition getPoint() {
            return this.m_point;
        }

        public String getSRS() {
            return this.m_SRS;
        }
    }
}

