/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.DictionaryUsagePreference;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.user.GeocodeConstraints;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.jdom.Element;

public class MMJCommonXMLWriter {
    private final NumberFormat m_nf = NumberFormat.getInstance(Locale.US);
    protected IGeocodeConstraints m_defaultConstraints = new GeocodeConstraints();

    public MMJCommonXMLWriter() {
        this.m_nf.setMaximumFractionDigits(6);
        this.m_nf.setParseIntegerOnly(false);
        this.m_nf.setGroupingUsed(false);
    }

    protected void writeUniversalAddressXML(Element parent, Address address) throws IOException {
        String tmp;
        Element addressElement = new Element("Address");
        HashMap addFlds = address.getAdditionalFields();
        if (addFlds != null && !addFlds.isEmpty()) {
            this.writeAdditionalFieldsXML(addressElement, addFlds);
        }
        if (this.checkValid(tmp = address.getAddressNumber())) {
            this.addChild(addressElement, "AddressNumber", tmp);
        }
        if (this.checkValid(tmp = address.getAreaName1())) {
            this.addChild(addressElement, "AreaName1", tmp);
        }
        if (this.checkValid(tmp = address.getAreaName2())) {
            this.addChild(addressElement, "AreaName2", tmp);
        }
        if (this.checkValid(tmp = address.getAreaName3())) {
            this.addChild(addressElement, "AreaName3", tmp);
        }
        if (this.checkValid(tmp = address.getAreaName4())) {
            this.addChild(addressElement, "AreaName4", tmp);
        }
        if (this.checkValid(tmp = address.getCountry())) {
            this.addChild(addressElement, "Country", tmp);
        }
        if (this.checkValid(tmp = address.getGenericField1())) {
            this.addChild(addressElement, "GenericField1", tmp);
        }
        if (this.checkValid(tmp = address.getGenericField2())) {
            this.addChild(addressElement, "GenericField2", tmp);
        }
        if (this.checkValid(tmp = address.getGenericField3())) {
            this.addChild(addressElement, "GenericField3", tmp);
        }
        if (this.checkValid(tmp = address.getGenericField4())) {
            this.addChild(addressElement, "GenericField4", tmp);
        }
        if (this.checkValid(tmp = address.getMainAddress())) {
            this.addChild(addressElement, "MainAddress", tmp);
        } else if (addFlds != null && this.checkValid(tmp = (String)addFlds.get("INTERSECTION_OUTPUT"))) {
            this.addChild(addressElement, "MainAddress", tmp);
        }
        tmp = address.getPlaceName();
        if (this.checkValid(tmp)) {
            this.addChild(addressElement, "placeName", tmp);
        }
        if (this.checkValid(tmp = address.getPostAddress())) {
            this.addChild(addressElement, "postAddress", tmp);
        }
        if (this.checkValid(tmp = address.getPostCode1())) {
            this.addChild(addressElement, "postCode1", tmp);
        }
        if (this.checkValid(tmp = address.getPostCode2())) {
            this.addChild(addressElement, "postCode2", tmp);
        }
        if (this.checkValid(tmp = address.getPostDirectional())) {
            this.addChild(addressElement, "postDirectional", tmp);
        }
        if (this.checkValid(tmp = address.getPostThoroughfareType())) {
            this.addChild(addressElement, "postThoroughfareType", tmp);
        }
        if (this.checkValid(tmp = address.getPreAddress())) {
            this.addChild(addressElement, "preAddress", tmp);
        }
        if (this.checkValid(tmp = address.getPreDirectional())) {
            this.addChild(addressElement, "preDirectional", tmp);
        }
        if (this.checkValid(tmp = address.getPreThoroughfareType())) {
            this.addChild(addressElement, "preThoroughfareType", tmp);
        }
        if (this.checkValid(tmp = address.getUnitType())) {
            this.addChild(addressElement, "unitType", tmp);
        }
        if (this.checkValid(tmp = address.getUnitValue())) {
            this.addChild(addressElement, "unitValue", tmp);
        }
        parent.addContent(addressElement);
    }

    protected void addChild(Element parent, String name, int value) {
        this.addChild(parent, name, String.valueOf(value));
    }

    protected void addChild(Element parent, String name, boolean value) {
        this.addChild(parent, name, String.valueOf(value));
    }

    protected void addChild(Element parent, String name, String value) {
        Element element = new Element(name);
        element.setText(value);
        parent.addContent(element);
    }

    protected void writeAdditionalFieldsXML(Element parent, Map map) throws IOException {
        Element addFldsElement = new Element("AdditionalFields");
        for (String key : map.keySet()) {
            String val = (String)map.get(key);
            if (!this.checkValid(key) || !this.checkValid(val)) continue;
            Element pair = new Element("KeyValuePair");
            Element keyEl = new Element("Key");
            Element valueEl = new Element("Value");
            keyEl.setText(key);
            valueEl.setText(val);
            pair.addContent(keyEl);
            pair.addContent(valueEl);
            addFldsElement.addContent(pair);
        }
        parent.addContent(addFldsElement);
    }

    protected void writeGeocodeConstraintsXML(Element parent, IGeocodeConstraints constraints, IGeocodeConstraints defaultConstraints, boolean alwaysWrite) throws IOException {
        IDictionarySearchOrder order;
        CoordSys crs;
        Element offsetEl;
        Locale locale;
        Element constraintsElement = new Element("GeocodeConstraints");
        if (defaultConstraints == null) {
            defaultConstraints = this.m_defaultConstraints;
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        boolean tmpBool = constraints.isFallbackToPostal();
        if (alwaysWrite || defaultConstraints.isFallbackToPostal() != tmpBool) {
            attr.put("fallbackToPostalCentroid", String.valueOf(tmpBool));
        }
        tmpBool = constraints.isFallbackToGeographic();
        if (alwaysWrite || defaultConstraints.isFallbackToGeographic() != tmpBool) {
            attr.put("fallbackToGeographicCentroid", String.valueOf(tmpBool));
        }
        tmpBool = constraints.isReturnCloseCandidatesOnly();
        if (alwaysWrite || defaultConstraints.isReturnCloseCandidatesOnly() != tmpBool) {
            attr.put("closeMatchesOnly", String.valueOf(tmpBool));
        }
        int type = constraints.getGeocodeType();
        if (alwaysWrite || type != defaultConstraints.getGeocodeType()) {
            attr.put("requestType", String.valueOf(type));
        }
        if ((locale = constraints.getClientLocale()) != null && (alwaysWrite || !locale.equals(defaultConstraints.getClientLocale()))) {
            attr.put("clientLocale", locale.toString());
        }
        DictionaryUsagePreference dictUsagePref = constraints.getDictionaryUsage();
        if (alwaysWrite || defaultConstraints.getDictionaryUsage() != dictUsagePref) {
            attr.put("dictionaryUsage", dictUsagePref.toString());
        }
        boolean addrPointPref = constraints.getUseAddressPointInterpolation();
        if (alwaysWrite || defaultConstraints.getUseAddressPointInterpolation() != addrPointPref) {
            attr.put("addrPntInterp", String.valueOf(addrPointPref));
        }
        boolean retParsedInputAddr = constraints.isReturnParsedInputAddress();
        if (alwaysWrite || defaultConstraints.isReturnParsedInputAddress() != retParsedInputAddr) {
            attr.put("ParsedInputReturn", String.valueOf(retParsedInputAddr));
        }
        Element base = new Element("BaseConstraints");
        for (String key : attr.keySet()) {
            String val = (String)attr.get(key);
            this.setAttribute(base, key, val);
        }
        int max = constraints.getMaxCandidates();
        if (alwaysWrite || max != defaultConstraints.getMaxCandidates()) {
            this.addChild(base, "maxCandidates", max);
        }
        max = constraints.getMaxRanges();
        if (alwaysWrite || max != defaultConstraints.getMaxRanges()) {
            this.addChild(base, "maxRanges", max);
        }
        max = constraints.getMaxRangeUnits();
        if (alwaysWrite || max != defaultConstraints.getMaxRangeUnits()) {
            this.addChild(base, "maxRangeUnits", max);
        }
        double offset = constraints.getCornerOffset();
        String units = constraints.getCornerOffsetUnits();
        if (alwaysWrite || offset != defaultConstraints.getCornerOffset() || units != null && !units.equalsIgnoreCase(defaultConstraints.getCornerOffsetUnits())) {
            offsetEl = new Element("offsetFromCorner");
            this.setAttribute(offsetEl, "unitsOfMeasure", units);
            offsetEl.setText(String.valueOf(offset));
            base.addContent(offsetEl);
        }
        offset = constraints.getStreetOffset();
        units = constraints.getStreetOffsetUnits();
        if (alwaysWrite || offset != defaultConstraints.getStreetOffset() || units != null && !units.equalsIgnoreCase(defaultConstraints.getStreetOffsetUnits())) {
            offsetEl = new Element("offsetFromStreet");
            this.setAttribute(offsetEl, "unitsOfMeasure", units);
            offsetEl.setText(String.valueOf(offset));
            base.addContent(offsetEl);
        }
        if ((crs = constraints.getClientCoordinateSystemObject()) != null && (alwaysWrite || !crs.equals(defaultConstraints.getClientCoordinateSystemObject()))) {
            this.writeCoordSys(base, crs);
        }
        if ((order = constraints.getDictionarySearchOrder()) != null && (alwaysWrite || !order.equals(defaultConstraints.getDictionarySearchOrder()))) {
            this.writeDictionarySearchOrder(base, order);
        }
        constraintsElement.addContent(base);
        boolean bOpenedAdditionalConstraints = false;
        Element addConstraintsElement = new Element("AdditionalConstraints");
        if (alwaysWrite) {
            bOpenedAdditionalConstraints = true;
            this.writeBooleanValue(addConstraintsElement, "MustMatchAddrNum", constraints.isMustMatchAddressNumber());
            this.writeBooleanValue(addConstraintsElement, "MustMatchArea1", constraints.isMustMatchArea1());
            this.writeBooleanValue(addConstraintsElement, "MustMatchArea2", constraints.isMustMatchArea2());
            this.writeBooleanValue(addConstraintsElement, "MustMatchArea3", constraints.isMustMatchArea3());
            this.writeBooleanValue(addConstraintsElement, "MustMatchArea4", constraints.isMustMatchArea4());
            this.writeBooleanValue(addConstraintsElement, "MustMatchMainAddr", constraints.isMustMatchMainAddress());
            this.writeBooleanValue(addConstraintsElement, "MustMatchPostalCode", constraints.isMustMatchPostalCode());
            this.writeBooleanValue(addConstraintsElement, "MustMatchInput", constraints.isMustMatchInput());
            this.writeBooleanValue(addConstraintsElement, "MustMatchCountry", constraints.isMustMatchCountry());
        } else {
            if (defaultConstraints.isMustMatchAddressNumber() != constraints.isMustMatchAddressNumber()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchAddrNum", constraints.isMustMatchAddressNumber());
            }
            if (defaultConstraints.isMustMatchArea1() != constraints.isMustMatchArea1()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchArea1", constraints.isMustMatchArea1());
            }
            if (defaultConstraints.isMustMatchArea2() != constraints.isMustMatchArea2()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchArea2", constraints.isMustMatchArea2());
            }
            if (defaultConstraints.isMustMatchArea3() != constraints.isMustMatchArea3()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchArea3", constraints.isMustMatchArea3());
            }
            if (defaultConstraints.isMustMatchArea4() != constraints.isMustMatchArea4()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchArea4", constraints.isMustMatchArea4());
            }
            if (defaultConstraints.isMustMatchMainAddress() != constraints.isMustMatchMainAddress()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchMainAddr", constraints.isMustMatchMainAddress());
            }
            if (defaultConstraints.isMustMatchPostalCode() != constraints.isMustMatchPostalCode()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchPostalCode", constraints.isMustMatchPostalCode());
            }
            if (defaultConstraints.isMustMatchInput() != constraints.isMustMatchInput()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchInput", constraints.isMustMatchInput());
            }
            if (defaultConstraints.isMustMatchCountry() != constraints.isMustMatchCountry()) {
                bOpenedAdditionalConstraints = true;
                this.writeBooleanValue(addConstraintsElement, "MustMatchCountry", constraints.isMustMatchCountry());
            }
        }
        Iterator i = constraints.getCustomValues().keySet().iterator();
        if (i.hasNext()) {
            while (i.hasNext()) {
                String obj;
                String key = (String)i.next();
                if (key == null || key.length() == 0 || (obj = this.getCustomConstraint(key, constraints, defaultConstraints, alwaysWrite)) == null || !(obj instanceof String)) continue;
                bOpenedAdditionalConstraints = true;
                Element pair = new Element("KeyValuePair");
                this.addChild(pair, "Key", key);
                this.addChild(pair, "Value", obj);
                addConstraintsElement.addContent(pair);
            }
        }
        if (bOpenedAdditionalConstraints) {
            constraintsElement.addContent(addConstraintsElement);
        }
        parent.addContent(constraintsElement);
    }

    private void writeBooleanValue(Element parent, String key, boolean value) throws IOException {
        Element pair = new Element("KeyValuePair");
        this.addChild(pair, "Key", key);
        this.addChild(pair, "Value", String.valueOf(value));
        parent.addContent(pair);
    }

    protected final void writeCoordSys(Element parent, CoordSys crs) throws IOException {
        String name = CoordSysUtilities.getSRSName((CoordSys)crs);
        Element csys = new Element("CoordinateReferenceSystem");
        Element id = new Element("Identifier");
        this.addChild(id, "code", name.substring(name.indexOf(":") + 1));
        this.addChild(id, "codeSpace", name.substring(0, name.indexOf(":")));
        csys.addContent(id);
        parent.addContent(csys);
    }

    private String getCustomConstraint(String key, IGeocodeConstraints gc, IGeocodeConstraints defaultConstraints, boolean alwaysWrite) {
        String test;
        String result = gc.getCustomString(key);
        if (result != null && !alwaysWrite && (test = defaultConstraints.getCustomString(key)) != null && test.equalsIgnoreCase(result)) {
            return null;
        }
        return result;
    }

    protected void writeDictionarySearchOrder(Element parent, IDictionarySearchOrder order) throws IOException {
        HashMap<String, String> attr = null;
        Element response = new Element("DictionarySearchOrderResponse");
        int count = order.getDictionaryCount();
        this.addChild(response, "DictionarySearchOrderListCount", count);
        for (int i = 1; i <= count; ++i) {
            String def = order.getDictionaryDescription(i);
            attr = new HashMap<String, String>();
            attr.put("CfgOrder", String.valueOf(i));
            attr.put("AllowSearch", String.valueOf(order.isDictionaryAvailableForSearch(i)));
            if (!this.checkValid(def)) {
                def = "";
            }
            attr.put("Description", def);
            attr.put("UserPriority", String.valueOf(order.getSearchOrderForDictionary(i)));
            attr.put("IsUserDictionary", String.valueOf(order.isUserDictionary(i)));
            Element list = new Element("DictionarySearchOrderList");
            for (String key : attr.keySet()) {
                this.setAttribute(list, key, (String)attr.get(key));
            }
            response.addContent(list);
        }
        parent.addContent(response);
    }

    private boolean checkValid(String str) {
        if (str != null && str.length() != 0) {
            return str.indexOf(0) < 0;
        }
        return false;
    }

    protected final void writePoint(Element parent, String elementName, DirectPosition p, String cs) throws IOException {
        if (p == null) {
            return;
        }
        Element element = new Element(elementName);
        this.setAttribute(element, "srsName", cs);
        this.writeCoord(element, p);
        parent.addContent(element);
    }

    protected final void writeCoord(Element parent, DirectPosition p) throws IOException {
        Element coord = new Element("coord");
        this.addChild(coord, "X", this.m_nf.format(p.getX()));
        this.addChild(coord, "Y", this.m_nf.format(p.getY()));
        parent.addContent(coord);
    }

    protected final void write(Element parent, IReverseGeocodeConstraints constraints) throws IOException {
        Element offsetEl;
        Length offset;
        if (constraints == null) {
            return;
        }
        Element constraintsEl = new Element("constraints");
        if (constraints.getClientLocale() != null) {
            this.setAttribute(constraintsEl, "locale", constraints.getClientLocale().toString());
        }
        if (constraints.getSortCandidatesUsingLocale()) {
            this.setAttribute(constraintsEl, "sortLocale", String.valueOf(constraints.getSortCandidatesUsingLocale()));
        }
        if (constraints.getDictionarySearchOrder() != null) {
            this.writeDictionarySearchOrder(constraintsEl, constraints.getDictionarySearchOrder());
        }
        if (constraints.getMaxRangeUnits() != 0) {
            this.addChild(constraintsEl, "maxRangeUnits", constraints.getMaxRangeUnits());
        }
        if (constraints.getCornerOffsetAsLength() != null) {
            offset = constraints.getCornerOffsetAsLength();
            offsetEl = new Element("offsetFromCorner");
            this.setAttribute(offsetEl, "unitsOfMeasure", MidevConversionUtils.getCommonAbbreviation(offset.getUnit()));
            offsetEl.setText(String.valueOf(offset.getValue()));
            constraintsEl.addContent(offsetEl);
        }
        if (constraints.getStreetOffsetAsLength() != null) {
            offset = constraints.getStreetOffsetAsLength();
            offsetEl = new Element("offsetFromStreet");
            this.setAttribute(offsetEl, "unitsOfMeasure", MidevConversionUtils.getCommonAbbreviation(offset.getUnit()));
            offsetEl.setText(String.valueOf(offset.getValue()));
            constraintsEl.addContent(offsetEl);
        }
        if (!constraints.getCustomValues().isEmpty()) {
            this.writeAdditionalFieldsXML(constraintsEl, constraints.getCustomValues());
        }
        parent.addContent(constraintsEl);
    }

    protected void write(Element parent, String element, Length d) throws IOException {
        Element child = new Element(element);
        this.setAttribute(child, "unitsOfMeasure", MidevConversionUtils.getCommonAbbreviation(d.getUnit()));
        child.setText(String.valueOf(d.getValue()));
        parent.addContent(child);
    }

    protected void setAttribute(Element element, String key, String value) {
        if (value != null) {
            element.setAttribute(key, value);
        }
    }
}

