/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ParsedInputAddressUtils {
    public static final String INPUT_MAINADDRESS = "input_mainaddress";
    public static final String HIGHEST_SCORING_LANGUAGE = "highest_scoring_language";
    private static Set<String> OneWordSpecialIntersection_Specifiers = new HashSet<String>();
    private static Set<String> TwoWordSpecialIntersection_Specifiers = new HashSet<String>();

    public static String upperCase(String instr) {
        if (instr == null) {
            return "";
        }
        char[] chararray = instr.toCharArray();
        for (int i = 0; i < chararray.length; ++i) {
            char curchar;
            chararray[i] = curchar = Character.toUpperCase(chararray[i]);
        }
        String newstr = new String(chararray);
        return newstr;
    }

    public static String properCase(String instr) {
        if (instr == null) {
            return "";
        }
        char[] chararray = instr.toCharArray();
        for (int i = 0; i < chararray.length; ++i) {
            char curchar = i == 0 ? Character.toUpperCase(chararray[i]) : Character.toLowerCase(chararray[i]);
            chararray[i] = curchar;
        }
        String newstr = new String(chararray);
        return newstr;
    }

    public static String makeFormattedInputStreet(Address pia, boolean houseNumberBefore, boolean mainAndTypeTogether) {
        return ParsedInputAddressUtils.makeFormattedInputStreet(pia, houseNumberBefore, mainAndTypeTogether, false);
    }

    public static String makeFormattedInputStreet(Address pia, boolean houseNumberBefore, boolean mainAndTypeTogether, boolean unitsAtFront) {
        StringWithTokens newToks;
        StringWithTokens toks;
        boolean hasPostType = false;
        boolean hasPostDir = false;
        String unitValHNcomboStr = null;
        String inMain = (String)pia.getAdditionalFields().get(INPUT_MAINADDRESS);
        if (inMain != null && houseNumberBefore && pia.getUnitValue() != null && pia.getAddressNumber() != null && (toks = new StringWithTokens(inMain)).size() > 1 && toks.getFirstToken().contains("/") && (newToks = new StringWithTokens(toks.getFirstToken(), "/")).size() == 2 && newToks.getFirstToken().equalsIgnoreCase(pia.getUnitValue()) && newToks.getToken(1).equalsIgnoreCase(pia.getAddressNumber())) {
            unitValHNcomboStr = toks.getFirstToken().toString();
        }
        StringBuilder formattedInputStreet = new StringBuilder();
        if (unitValHNcomboStr == null && unitsAtFront && !StringUtilities.isEmpty(pia.getUnitType())) {
            formattedInputStreet.append(pia.getUnitType().trim());
            formattedInputStreet.append(' ');
        }
        if (unitValHNcomboStr == null && unitsAtFront && !StringUtilities.isEmpty(pia.getUnitValue())) {
            formattedInputStreet.append(pia.getUnitValue().trim());
            formattedInputStreet.append(' ');
        }
        if (unitValHNcomboStr != null) {
            formattedInputStreet.append(unitValHNcomboStr.trim());
            formattedInputStreet.append(' ');
        } else if (houseNumberBefore && !StringUtilities.isEmpty(pia.getAddressNumber())) {
            formattedInputStreet.append(pia.getAddressNumber().trim());
            formattedInputStreet.append(' ');
        }
        if (!StringUtilities.isEmpty(pia.getPreDirectional())) {
            formattedInputStreet.append(pia.getPreDirectional().trim());
            formattedInputStreet.append(' ');
        }
        if (!StringUtilities.isEmpty(pia.getPreThoroughfareType())) {
            formattedInputStreet.append(pia.getPreThoroughfareType().trim());
            formattedInputStreet.append(' ');
        }
        if (!StringUtilities.isEmpty(pia.getPreAddress())) {
            formattedInputStreet.append(pia.getPreAddress().trim());
            formattedInputStreet.append(' ');
        }
        if (!StringUtilities.isEmpty(pia.getMainAddress())) {
            formattedInputStreet.append(pia.getMainAddress().trim());
            if (!mainAndTypeTogether) {
                formattedInputStreet.append(' ');
            }
        }
        if (!StringUtilities.isEmpty(pia.getPostThoroughfareType())) {
            hasPostType = true;
            formattedInputStreet.append(pia.getPostThoroughfareType().trim());
            formattedInputStreet.append(' ');
        }
        if (!StringUtilities.isEmpty(pia.getPostDirectional())) {
            if (mainAndTypeTogether && !hasPostType) {
                formattedInputStreet.append(' ');
            }
            formattedInputStreet.append(pia.getPostDirectional().trim());
            formattedInputStreet.append(' ');
        }
        if (!houseNumberBefore && !StringUtilities.isEmpty(pia.getAddressNumber())) {
            if (mainAndTypeTogether && !hasPostType && !hasPostDir) {
                formattedInputStreet.append(' ');
            }
            formattedInputStreet.append(pia.getAddressNumber().trim());
            formattedInputStreet.append(' ');
        }
        if (unitValHNcomboStr == null && !unitsAtFront && !StringUtilities.isEmpty(pia.getUnitType())) {
            formattedInputStreet.append(pia.getUnitType().trim());
            formattedInputStreet.append(' ');
        }
        if (unitValHNcomboStr == null && !unitsAtFront && !StringUtilities.isEmpty(pia.getUnitValue())) {
            formattedInputStreet.append(pia.getUnitValue().trim());
            formattedInputStreet.append(' ');
        }
        return formattedInputStreet.toString().trim();
    }

    public static String getSpecialIntersectionSpecifier(String inMain) {
        if (inMain == null) {
            return null;
        }
        Iterator<String> itr = TwoWordSpecialIntersection_Specifiers.iterator();
        String specifier2 = null;
        while (itr.hasNext()) {
            specifier2 = itr.next();
            if (!inMain.contains(specifier2)) continue;
            return specifier2;
        }
        for (String specifier2 : OneWordSpecialIntersection_Specifiers) {
            if (!inMain.contains(specifier2)) continue;
            return specifier2;
        }
        return null;
    }

    static {
        TwoWordSpecialIntersection_Specifiers.add("CNR OF ");
        TwoWordSpecialIntersection_Specifiers.add("CORNER OF ");
        TwoWordSpecialIntersection_Specifiers.add("CRN OF ");
        TwoWordSpecialIntersection_Specifiers.add("CRN. OF ");
        TwoWordSpecialIntersection_Specifiers.add("CNR. OF ");
        OneWordSpecialIntersection_Specifiers.add("CNR. ");
        OneWordSpecialIntersection_Specifiers.add("CRN ");
        OneWordSpecialIntersection_Specifiers.add("CORNER ");
        OneWordSpecialIntersection_Specifiers.add("CRN. ");
        OneWordSpecialIntersection_Specifiers = Collections.unmodifiableSet(OneWordSpecialIntersection_Specifiers);
        TwoWordSpecialIntersection_Specifiers = Collections.unmodifiableSet(TwoWordSpecialIntersection_Specifiers);
    }
}

