/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.utils.StringUtilities;

public class ParsedNumber
implements Comparable {
    private String m_addressPrefix;
    private String m_prefixSeparator;
    private long m_addressNumber;
    private boolean m_bAddressNumberExists;
    private int m_addressNumberLeadingZeros;
    private String m_numberSeparator;
    private String m_addressSuffix;
    private String m_suffixSeparator;
    private long m_suffixNumber;
    private boolean m_bSuffixNumberExists;
    private int m_suffixNumberLeadingZeros;
    private String m_trailerSeparator;
    private String m_addressTrailer;
    private int m_oddEvenBoth;
    private int m_numFields;
    private boolean m_bPureNumeric;
    private boolean m_bHyphenatedNumber;
    private boolean m_bFractionalTrailer;
    private boolean m_bEmpty;
    private boolean m_ignoreLeadingZeros = false;

    public ParsedNumber(String addressNumberString) {
        int digit;
        int i;
        if (addressNumberString == null) {
            this.m_bEmpty = true;
            return;
        }
        char[] chars = addressNumberString.trim().toCharArray();
        if (chars.length == 0) {
            this.m_bEmpty = true;
            return;
        }
        int start = 0;
        int end = chars.length;
        int prefixStart = -1;
        int prefixSepStart = -1;
        int numberStart = -1;
        int numberSepStart = -1;
        int suffixStart = -1;
        int suffixSepStart = -1;
        int sufNumStart = -1;
        int trailerSepStart = -1;
        int trailerStart = -1;
        int prefixLen = 0;
        int prefixSepLen = 0;
        int numberLen = 0;
        int numberSepLen = 0;
        int suffixLen = 0;
        int suffixSepLen = 0;
        int sufNumLen = 0;
        int trailerSepLen = 0;
        int trailerLen = 0;
        this.m_bPureNumeric = true;
        for (i = 0; i < end && Character.isLetter(chars[i]); ++i) {
        }
        if (i > start) {
            prefixStart = start;
            prefixLen = i - start;
            this.m_bPureNumeric = false;
            ++this.m_numFields;
        }
        start = i;
        while (i < end && !Character.isLetterOrDigit(chars[i])) {
            ++i;
        }
        if (i > start) {
            prefixSepStart = start;
            prefixSepLen = i - start;
            this.m_bPureNumeric = false;
        }
        while (i < end && chars[i] == '0') {
            ++i;
            ++this.m_addressNumberLeadingZeros;
        }
        start = i;
        while (i < end && Character.isDigit(chars[i])) {
            ++i;
        }
        if (i > start && i < end - 1 && chars[i] == '/' && Character.isDigit(chars[i + 1])) {
            trailerStart = start;
            trailerLen = end - start;
            this.m_bPureNumeric = false;
            this.m_bFractionalTrailer = true;
            i = end;
            ++this.m_numFields;
        } else if (i > start) {
            numberStart = start;
            numberLen = i - start;
        } else if (this.m_addressNumberLeadingZeros != 0) {
            --this.m_addressNumberLeadingZeros;
            numberStart = i - 1;
            numberLen = 1;
        }
        if (numberLen != 0) {
            ++this.m_numFields;
            start = i;
            while (i < end && !Character.isLetterOrDigit(chars[i])) {
                ++i;
            }
            if (i > start) {
                numberSepStart = start;
                numberSepLen = i - start;
                this.m_bPureNumeric = false;
            }
        }
        start = i;
        while (i < end && Character.isLetter(chars[i])) {
            ++i;
        }
        if (i > start) {
            suffixStart = start;
            suffixLen = i - start;
            this.m_bPureNumeric = false;
            ++this.m_numFields;
            start = i;
            while (i < end && !Character.isLetterOrDigit(chars[i])) {
                ++i;
            }
            if (i > start) {
                suffixSepStart = start;
                suffixSepLen = i - start;
            }
        }
        while (i < end && chars[i] == '0') {
            ++i;
            ++this.m_suffixNumberLeadingZeros;
        }
        start = i;
        while (i < end && Character.isDigit(chars[i])) {
            ++i;
        }
        if (i > start && i < end - 1 && chars[i] == '/' && Character.isDigit(chars[i + 1])) {
            this.m_bPureNumeric = false;
            this.m_bFractionalTrailer = true;
            trailerStart = start;
            trailerLen = end - start;
            i = end;
            ++this.m_numFields;
        } else if (i > start) {
            sufNumStart = start;
            sufNumLen = i - start;
        } else if (this.m_suffixNumberLeadingZeros != 0) {
            --this.m_suffixNumberLeadingZeros;
            sufNumStart = i - 1;
            sufNumLen = 1;
        }
        if (sufNumLen != 0) {
            ++this.m_numFields;
            start = i;
            while (i < end && !Character.isLetterOrDigit(chars[i])) {
                ++i;
            }
            if (i > start) {
                trailerSepStart = start;
                trailerSepLen = i - start;
                this.m_bPureNumeric = false;
            }
        }
        start = i;
        if (i != end) {
            trailerStart = start;
            trailerLen = end - start;
            this.m_bPureNumeric = false;
            while (i < end && Character.isDigit(chars[i])) {
                ++i;
            }
            if (i > start && i < end - 1 && chars[i] == '/' && Character.isDigit(chars[i + 1])) {
                this.m_bFractionalTrailer = true;
                i = end;
            }
            ++this.m_numFields;
        }
        if (prefixLen != 0) {
            this.m_addressPrefix = new String(chars, prefixStart, prefixLen);
        }
        if (prefixSepLen != 0) {
            this.setPrefixSeparator(this.findSeparator(prefixSepStart, prefixSepLen, chars));
            ++this.m_numFields;
        }
        if (numberLen != 0) {
            this.m_addressNumber = 0L;
            int numberEnd = numberStart + numberLen;
            for (i = numberStart; i < numberEnd; ++i) {
                digit = chars[i] - 48;
                this.m_addressNumber += (long)digit;
                if (i >= numberEnd - 1) continue;
                this.m_addressNumber *= 10L;
            }
            this.m_bAddressNumberExists = true;
        }
        if (numberSepLen != 0) {
            this.setNumberSeparator(this.findSeparator(numberSepStart, numberSepLen, chars));
            ++this.m_numFields;
        }
        if (suffixLen != 0) {
            this.m_addressSuffix = new String(chars, suffixStart, suffixLen);
        }
        if (suffixSepLen != 0) {
            this.setSuffixSeparator(this.findSeparator(suffixSepStart, suffixSepLen, chars));
            ++this.m_numFields;
        }
        if (sufNumLen != 0) {
            this.m_suffixNumber = 0L;
            int sufNumEnd = sufNumStart + sufNumLen;
            for (i = sufNumStart; i < sufNumEnd; ++i) {
                digit = chars[i] - 48;
                this.m_suffixNumber += (long)digit;
                if (i >= sufNumEnd - 1) continue;
                this.m_suffixNumber *= 10L;
            }
            this.m_bSuffixNumberExists = true;
        }
        if (trailerSepLen != 0) {
            this.setTrailerSeparator(this.findSeparator(trailerSepStart, trailerSepLen, chars));
            ++this.m_numFields;
        }
        if (trailerLen != 0) {
            this.m_addressTrailer = new String(chars, trailerStart, trailerLen);
        }
        this.m_oddEvenBoth = this.m_bSuffixNumberExists ? ((this.m_suffixNumber & 1L) == 1L ? 1 : 2) : (this.m_bAddressNumberExists ? ((this.m_addressNumber & 1L) == 1L ? 1 : 2) : 0);
        this.setHyphenatedNumber();
    }

    public ParsedNumber(ParsedNumber copy) {
        this.m_bEmpty = copy.isEmpty();
        if (!this.m_bEmpty) {
            this.m_bPureNumeric = copy.isPureNumeric();
            if (!this.m_bPureNumeric) {
                this.m_addressPrefix = copy.m_addressPrefix;
                this.m_prefixSeparator = copy.m_prefixSeparator;
                this.m_numberSeparator = copy.m_numberSeparator;
                this.m_addressSuffix = copy.m_addressSuffix;
                this.m_suffixSeparator = copy.m_suffixSeparator;
                this.m_addressTrailer = copy.m_addressTrailer;
                this.m_trailerSeparator = copy.m_trailerSeparator;
                this.m_bHyphenatedNumber = copy.isHyphenatedNumber();
                this.m_bFractionalTrailer = copy.isFractionalTrailer();
            }
            if (copy.getAddressNumberExists()) {
                this.m_addressNumber = copy.getAddressNumber();
                this.m_bAddressNumberExists = true;
                this.m_addressNumberLeadingZeros = copy.addressNumberLeadingZeros();
            }
            if (copy.getSuffixNumberExists()) {
                this.m_suffixNumber = copy.getSuffixNumber();
                this.m_bSuffixNumberExists = true;
                this.m_suffixNumberLeadingZeros = copy.suffixNumberLeadingZeros();
            }
            this.m_oddEvenBoth = copy.isRangeOddEvenBoth();
            this.m_numFields = copy.getNumFields();
        }
    }

    public ParsedNumber(long number) {
        this.m_addressNumber = number;
        this.m_bAddressNumberExists = true;
        this.m_oddEvenBoth = (this.m_addressNumber & 1L) == 1L ? 1 : 2;
        this.m_numFields = 1;
        this.m_bPureNumeric = true;
    }

    public boolean isPureNumeric() {
        return this.m_bPureNumeric;
    }

    public boolean isEmpty() {
        return this.m_bEmpty;
    }

    public int isRangeOddEvenBoth() {
        return this.m_oddEvenBoth;
    }

    public String getAddressPrefix() {
        if (this.m_addressPrefix == null) {
            return "";
        }
        return this.m_addressPrefix;
    }

    public boolean hasAddressPrefix() {
        return this.m_addressPrefix == null ? false : this.m_addressPrefix.length() != 0;
    }

    public void setAddressPrefix(String prefix) {
        if (prefix == null) {
            this.m_addressPrefix = null;
        } else {
            this.m_addressPrefix = prefix;
            this.m_bPureNumeric = false;
        }
    }

    public String getPrefixSeparator() {
        if (this.m_prefixSeparator == null) {
            return "";
        }
        return this.m_prefixSeparator;
    }

    public boolean hasPrefixSeparator() {
        return this.m_prefixSeparator == null ? false : this.m_prefixSeparator.length() != 0;
    }

    public void setPrefixSeparator(String separator) {
        if (separator == null || separator.length() == 0) {
            this.m_prefixSeparator = null;
        } else if ("--".equals(separator)) {
            this.m_prefixSeparator = "-";
            this.m_bPureNumeric = false;
        } else {
            this.m_prefixSeparator = separator;
            this.m_bPureNumeric = false;
        }
    }

    public long getAddressNumber() {
        return this.m_addressNumber;
    }

    public void setAddressNumber(long number) {
        this.m_addressNumber = number;
    }

    public boolean getAddressNumberExists() {
        return this.m_bAddressNumberExists;
    }

    public void setAddressNumberExists(boolean flag) {
        this.m_bAddressNumberExists = flag;
    }

    public String getNumberSeparator() {
        if (this.m_numberSeparator == null) {
            return "";
        }
        return this.m_numberSeparator;
    }

    public boolean hasNumberSeparator() {
        return this.m_numberSeparator == null ? false : this.m_numberSeparator.length() != 0;
    }

    public void setNumberSeparator(String separator) {
        if (separator == null || separator.length() == 0) {
            this.m_numberSeparator = null;
            this.m_bHyphenatedNumber = false;
        } else if ("--".equals(separator)) {
            this.m_numberSeparator = "-";
            this.m_bPureNumeric = false;
        } else {
            this.m_numberSeparator = separator;
            this.m_bPureNumeric = false;
        }
    }

    public String getAddressSuffix() {
        if (this.m_addressSuffix == null) {
            return "";
        }
        return this.m_addressSuffix;
    }

    public boolean hasAddressSuffix() {
        return this.m_addressSuffix == null ? false : this.m_addressSuffix.length() != 0;
    }

    public void setAddressSuffix(String suffix) {
        if (suffix == null) {
            this.m_addressSuffix = null;
        } else {
            this.m_addressSuffix = suffix;
            this.m_bPureNumeric = false;
        }
    }

    public String getSuffixSeparator() {
        if (this.m_suffixSeparator == null) {
            return "";
        }
        return this.m_suffixSeparator;
    }

    public boolean hasSuffixSeparator() {
        return this.m_suffixSeparator == null ? false : this.m_suffixSeparator.length() != 0;
    }

    public void setSuffixSeparator(String separator) {
        if (separator == null || separator.length() == 0) {
            this.m_suffixSeparator = null;
        } else if ("--".equals(separator)) {
            this.m_suffixSeparator = "-";
            this.m_bPureNumeric = false;
        } else {
            this.m_suffixSeparator = separator;
            this.m_bPureNumeric = false;
        }
    }

    public long getSuffixNumber() {
        return this.m_suffixNumber;
    }

    public void setSuffixNumber(long number) {
        this.m_suffixNumber = number;
        this.m_bPureNumeric = false;
    }

    public boolean getSuffixNumberExists() {
        return this.m_bSuffixNumberExists;
    }

    public void setSuffixNumberExists(boolean flag) {
        this.m_bSuffixNumberExists = flag;
    }

    public String getTrailerSeparator() {
        if (this.m_trailerSeparator == null) {
            return "";
        }
        return this.m_trailerSeparator;
    }

    public boolean hasTrailerSeparator() {
        return this.m_trailerSeparator == null ? false : this.m_trailerSeparator.length() != 0;
    }

    public void setTrailerSeparator(String separator) {
        if (separator == null || separator.length() == 0) {
            this.m_trailerSeparator = null;
        } else if ("--".equals(separator)) {
            this.m_trailerSeparator = "-";
            this.m_bPureNumeric = false;
        } else {
            this.m_trailerSeparator = separator;
            this.m_bPureNumeric = false;
        }
    }

    public String getAddressTrailer() {
        if (this.m_addressTrailer == null) {
            return "";
        }
        return this.m_addressTrailer;
    }

    public boolean hasAddressTrailer() {
        return this.m_addressTrailer == null ? false : this.m_addressTrailer.length() != 0;
    }

    public void setAddressTrailer(String trailer) {
        if (trailer == null) {
            this.m_addressTrailer = null;
        } else {
            this.m_addressTrailer = trailer;
            this.m_bPureNumeric = false;
        }
    }

    public int getNumFields() {
        return this.m_numFields;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.m_addressPrefix != null && this.m_addressPrefix.length() != 0) {
            buffer.append("prefix='" + this.m_addressPrefix + "'\n");
        }
        if (this.m_prefixSeparator != null && this.m_prefixSeparator.length() != 0) {
            buffer.append("prefix separator='" + this.m_prefixSeparator + "'\n");
        }
        if (this.m_bAddressNumberExists) {
            buffer.append("number=" + this.m_addressNumber + "\n");
        }
        if (this.m_numberSeparator != null && this.m_numberSeparator.length() != 0) {
            buffer.append("separator='" + this.m_numberSeparator + "'\n");
        }
        if (this.m_addressSuffix != null && this.m_addressSuffix.length() != 0) {
            buffer.append("suffix='" + this.m_addressSuffix + "'\n");
        }
        if (this.m_suffixSeparator != null && this.m_suffixSeparator.length() != 0) {
            buffer.append("suffix separator='" + this.m_suffixSeparator + "'\n");
        }
        if (this.m_bSuffixNumberExists) {
            buffer.append("suffix number=" + this.m_suffixNumber + "\n");
        }
        if (this.m_addressTrailer != null && this.m_addressTrailer.length() != 0) {
            buffer.append("trailer='" + this.m_addressTrailer + "'\n");
        }
        buffer.append("odd/even/both=" + this.m_oddEvenBoth + "\n");
        return buffer.toString();
    }

    public String getCombinedAddressNumber() {
        String str;
        if (this.m_bPureNumeric) {
            if (this.m_addressNumberLeadingZeros > 0) {
                String str2 = String.valueOf(this.m_addressNumber);
                return StringUtilities.intToLeadingZeroString(str2.length() + this.m_addressNumberLeadingZeros, (int)this.m_addressNumber);
            }
            return String.valueOf(this.m_addressNumber);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.m_addressPrefix != null && this.m_addressPrefix.length() != 0) {
            buffer.append(this.m_addressPrefix);
        }
        if (this.m_prefixSeparator != null && this.m_prefixSeparator.length() != 0) {
            buffer.append(this.m_prefixSeparator);
        }
        if (this.getAddressNumberExists()) {
            if (this.m_addressNumberLeadingZeros > 0) {
                str = String.valueOf(this.m_addressNumber);
                buffer.append(StringUtilities.intToLeadingZeroString(str.length() + this.m_addressNumberLeadingZeros, (int)this.m_addressNumber));
            } else {
                buffer.append(this.m_addressNumber);
            }
        }
        if (this.m_numberSeparator != null && this.m_numberSeparator.length() != 0) {
            buffer.append(this.m_numberSeparator);
        }
        if (this.m_addressSuffix != null && this.m_addressSuffix.length() != 0) {
            buffer.append(this.m_addressSuffix);
        }
        if (this.m_suffixSeparator != null && this.m_suffixSeparator.length() != 0) {
            buffer.append(this.m_suffixSeparator);
        }
        if (this.getSuffixNumberExists()) {
            if (this.m_suffixNumberLeadingZeros > 0) {
                str = String.valueOf(this.m_suffixNumber);
                buffer.append(StringUtilities.intToLeadingZeroString(str.length() + this.m_suffixNumberLeadingZeros, (int)this.m_suffixNumber));
            } else {
                buffer.append(this.m_suffixNumber);
            }
        }
        if (this.m_trailerSeparator != null && this.m_trailerSeparator.length() != 0) {
            buffer.append(this.m_trailerSeparator);
        }
        if (this.m_addressTrailer != null && this.m_addressTrailer.length() != 0) {
            buffer.append(this.m_addressTrailer);
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    public long computeDifference(ParsedNumber number, int divisionFactor) {
        if (this.equals(number)) {
            return 0L;
        }
        if (number.isEmpty()) {
            return Long.MAX_VALUE;
        }
        boolean prefixMatched = true;
        boolean numberMatched = true;
        boolean suffixMatched = true;
        boolean suffixNumberMatched = true;
        boolean trailerMatched = true;
        boolean ignorePrefix = false;
        boolean ignoreNumber = false;
        boolean ignoreSuffix = false;
        boolean ignoreSuffixNumber = false;
        boolean ignoreTrailer = false;
        if (number.getAddressPrefix().length() != 0) {
            if (this.getAddressPrefix() == null || this.getAddressPrefix().length() == 0) {
                ignorePrefix = true;
            }
            prefixMatched = this.getAddressPrefix().equals(number.getAddressPrefix());
        }
        if (number.getAddressNumberExists()) {
            if (!this.getAddressNumberExists()) {
                ignoreNumber = true;
            }
            boolean bl = numberMatched = this.getAddressNumber() == number.getAddressNumber();
        }
        if (number.getAddressSuffix().length() != 0) {
            if (this.getAddressSuffix() == null || this.getAddressSuffix().length() == 0) {
                ignoreSuffix = true;
            }
            suffixMatched = this.getAddressSuffix().equals(number.getAddressSuffix());
        }
        if (number.getSuffixNumberExists()) {
            if (!this.getSuffixNumberExists()) {
                ignoreSuffixNumber = true;
            }
            boolean bl = suffixNumberMatched = this.getSuffixNumber() == number.getSuffixNumber();
        }
        if (number.getAddressTrailer().length() != 0) {
            if (this.getAddressTrailer() == null || this.getAddressTrailer().length() == 0) {
                ignoreTrailer = true;
            }
            trailerMatched = this.getAddressTrailer().equals(number.getAddressTrailer());
        }
        int fieldsDiff = 0;
        if (!prefixMatched && !ignorePrefix) {
            ++fieldsDiff;
        }
        if (!numberMatched && !ignoreNumber) {
            ++fieldsDiff;
        }
        if (!suffixMatched && !ignoreSuffix) {
            ++fieldsDiff;
        }
        if (!suffixNumberMatched && !ignoreSuffixNumber) {
            ++fieldsDiff;
        }
        if (!trailerMatched && !ignoreTrailer) {
            ++fieldsDiff;
        }
        long offset = Long.MAX_VALUE;
        if (fieldsDiff == 0) {
            return 0L;
        }
        if (fieldsDiff > 1) {
            return offset;
        }
        if (!prefixMatched) {
            offset = this.getAddressPrefix().compareTo(number.getAddressPrefix());
        } else if (!numberMatched) {
            offset = (this.getAddressNumber() - number.getAddressNumber()) / (long)divisionFactor;
        } else if (!suffixMatched) {
            offset = this.getAddressSuffix().compareTo(number.getAddressSuffix());
        } else if (!suffixNumberMatched) {
            offset = (this.getSuffixNumber() - number.getSuffixNumber()) / (long)divisionFactor;
        } else if (!trailerMatched) {
            offset = this.getAddressTrailer().compareTo(number.getAddressTrailer());
        }
        if (offset < 0L) {
            offset *= -1L;
        }
        return offset;
    }

    public int compareTo(Object obj2) {
        long num1 = 0L;
        long num2 = 0L;
        String str1 = null;
        String str2 = null;
        ParsedNumber number2 = (ParsedNumber)obj2;
        str1 = this.getAddressPrefix();
        str2 = number2.getAddressPrefix();
        if (str1 != null) {
            if (str2 == null) {
                return 1;
            }
            if (!str1.equals(str2)) {
                return str1.compareTo(str2);
            }
        } else if (str2 != null) {
            return -1;
        }
        if (this.getAddressNumberExists()) {
            if (!number2.getAddressNumberExists()) {
                return 1;
            }
            num1 = this.getAddressNumber();
            if (num1 != (num2 = number2.getAddressNumber())) {
                if (num1 < num2) {
                    return -1;
                }
                return 1;
            }
        } else if (number2.getAddressNumberExists()) {
            return -1;
        }
        str1 = this.getAddressSuffix();
        str2 = number2.getAddressSuffix();
        if (str1 != null) {
            if (str2 == null) {
                return 1;
            }
            if (!str1.equals(str2)) {
                return str1.compareTo(str2);
            }
        } else if (str2 != null) {
            return -1;
        }
        if (this.getSuffixNumberExists()) {
            if (!number2.getSuffixNumberExists()) {
                return 1;
            }
            num1 = this.getSuffixNumber();
            if (num1 != (num2 = number2.getSuffixNumber())) {
                if (num1 < num2) {
                    return -1;
                }
                return 1;
            }
        } else if (number2.getSuffixNumberExists()) {
            return -1;
        }
        str1 = this.getAddressTrailer();
        str2 = number2.getAddressTrailer();
        if (str1 != null) {
            if (str2 == null) {
                return 1;
            }
            if (!str1.equals(str2)) {
                return str1.compareTo(str2);
            }
        } else if (str2 != null) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 17;
        result = this.m_addressPrefix != null ? this.m_addressPrefix.hashCode() : 0;
        result = 29 * result + (this.m_prefixSeparator != null ? this.m_prefixSeparator.hashCode() : 0);
        result = 29 * result + (int)(this.m_addressNumber ^ this.m_addressNumber >>> 32);
        result = 29 * result + (this.m_bAddressNumberExists ? 1 : 0);
        result = 29 * result + (this.m_numberSeparator != null ? this.m_numberSeparator.hashCode() : 0);
        result = 29 * result + (this.m_addressSuffix != null ? this.m_addressSuffix.hashCode() : 0);
        result = 29 * result + (this.m_suffixSeparator != null ? this.m_suffixSeparator.hashCode() : 0);
        result = 29 * result + (int)(this.m_suffixNumber ^ this.m_suffixNumber >>> 32);
        result = 29 * result + (this.m_bSuffixNumberExists ? 1 : 0);
        result = 29 * result + (this.m_trailerSeparator != null ? this.m_trailerSeparator.hashCode() : 0);
        result = 29 * result + (this.m_addressTrailer != null ? this.m_addressTrailer.hashCode() : 0);
        result = 29 * result + this.m_oddEvenBoth;
        result = 29 * result + this.m_numFields;
        result = 29 * result + (this.m_bPureNumeric ? 1 : 0);
        result = 29 * result + (this.m_bHyphenatedNumber ? 1 : 0);
        result = 29 * result + (this.m_bFractionalTrailer ? 1 : 0);
        result = 29 * result + (this.m_bEmpty ? 1 : 0);
        return result;
    }

    public boolean equals(Object that) {
        boolean compareLeadingZeros;
        if (!(that instanceof ParsedNumber)) {
            return false;
        }
        ParsedNumber number1 = this;
        ParsedNumber number2 = (ParsedNumber)that;
        if (number1.isPureNumeric() != number2.isPureNumeric()) {
            return false;
        }
        if (number1.getAddressNumberExists() != number2.getAddressNumberExists()) {
            return false;
        }
        if (number1.getAddressNumberExists() && number1.getAddressNumber() != number2.getAddressNumber()) {
            return false;
        }
        boolean bl = compareLeadingZeros = !number1.isIgnoreLeadingZeros() && !number2.isIgnoreLeadingZeros();
        if (compareLeadingZeros && number1.addressNumberLeadingZeros() != number2.addressNumberLeadingZeros()) {
            return false;
        }
        if (number1.isPureNumeric()) {
            return true;
        }
        if (number1.getSuffixNumberExists() != number2.getSuffixNumberExists()) {
            return false;
        }
        if (number1.getSuffixNumberExists() && number1.getSuffixNumber() != number2.getSuffixNumber()) {
            return false;
        }
        if (compareLeadingZeros && number1.suffixNumberLeadingZeros() != number2.suffixNumberLeadingZeros()) {
            return false;
        }
        String str1 = number1.getAddressPrefix();
        String str2 = number2.getAddressPrefix();
        if (str1 != null ? !str1.equals(str2) : str2 != null) {
            return false;
        }
        str1 = number1.getAddressSuffix();
        str2 = number2.getAddressSuffix();
        if (str1 != null ? !str1.equals(str2) : str2 != null) {
            return false;
        }
        str1 = number1.getAddressTrailer();
        str2 = number2.getAddressTrailer();
        if (str1 != null ? !str1.equals(str2) : str2 != null) {
            return false;
        }
        str1 = number1.getPrefixSeparator();
        str2 = number2.getPrefixSeparator();
        if (str1 != null ? !str1.equals(str2) : str2 != null) {
            return false;
        }
        str1 = number1.getSuffixSeparator();
        str2 = number2.getSuffixSeparator();
        if (str1 != null ? !str1.equals(str2) : str2 != null) {
            return false;
        }
        str1 = number1.getTrailerSeparator();
        str2 = number2.getTrailerSeparator();
        if (str1 != null ? !str1.equals(str2) : str2 != null) {
            return false;
        }
        str1 = number1.getNumberSeparator();
        str2 = number2.getNumberSeparator();
        return !(str1 != null ? !str1.equals(str2) : str2 != null);
    }

    public int addressNumberLeadingZeros() {
        return this.m_addressNumberLeadingZeros;
    }

    public void setAddressNumberLeadingZeros(int num) {
        this.m_addressNumberLeadingZeros = num;
    }

    public boolean isIgnoreLeadingZeros() {
        return this.m_ignoreLeadingZeros;
    }

    public void setIgnoreLeadingZeros(boolean ignoreLeadingZeros) {
        this.m_ignoreLeadingZeros = ignoreLeadingZeros;
    }

    public int suffixNumberLeadingZeros() {
        return this.m_suffixNumberLeadingZeros;
    }

    public boolean isHyphenatedNumber() {
        return this.m_bHyphenatedNumber;
    }

    public void setHyphenatedNumber() {
        this.m_bHyphenatedNumber = this.m_numberSeparator != null && (this.m_numberSeparator.equals("-") || this.m_numberSeparator.equals("--")) && this.getSuffixNumberExists() && this.getAddressNumberExists();
    }

    public void setPureNumeric() {
        this.m_bPureNumeric = this.m_numFields == 1 && (this.getNumberSeparator() == null || this.getNumberSeparator().equals("")) && this.getAddressNumberExists();
    }

    public void setNumFields(int num) {
        this.m_numFields = num;
    }

    private String findSeparator(int sepStart, int sepLen, char[] chars) {
        if (sepLen == 0) {
            return "";
        }
        char[] seps = new char[sepLen];
        int sepCount = 0;
        int sepEnd = sepStart + sepLen;
        for (int i = sepStart; i < sepEnd; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            seps[sepCount] = chars[i];
            ++sepCount;
        }
        if (sepCount == 0) {
            return " ";
        }
        if (sepCount == sepLen) {
            return new String(seps);
        }
        return new String(seps, 0, sepCount);
    }

    public static long computeUnhyphenatedNumber(ParsedNumber inputNumber, ParsedNumber lowNumber, ParsedNumber highNumber) {
        long number = inputNumber.getAddressNumber();
        int numDigits = 0;
        int inputNumDigits = 0;
        int highNumDigits = 0;
        int lowNumDigits = 0;
        if (!inputNumber.isHyphenatedNumber()) {
            if (inputNumber.getAddressNumberExists()) {
                return inputNumber.getAddressNumber();
            }
            if (inputNumber.getSuffixNumberExists()) {
                return inputNumber.getSuffixNumber();
            }
            return 0L;
        }
        if (highNumber.getSuffixNumberExists() && highNumber.isHyphenatedNumber()) {
            highNumDigits = highNumber.getSuffixNumberAsString().length();
        }
        if (lowNumber.getSuffixNumberExists() && lowNumber.isHyphenatedNumber()) {
            lowNumDigits = lowNumber.getSuffixNumberAsString().length();
        }
        if (inputNumber.getSuffixNumberExists() && inputNumber.isHyphenatedNumber()) {
            inputNumDigits = inputNumber.getSuffixNumberAsString().length();
        }
        numDigits = Math.max(lowNumDigits, highNumDigits);
        numDigits = Math.max(numDigits, inputNumDigits);
        for (int index = 0; index < numDigits; ++index) {
            number *= 10L;
        }
        return number += inputNumber.getSuffixNumber();
    }

    public static void computeHyphenatedNumber(ParsedNumber outputNumber, ParsedNumber inputNumber, ParsedNumber lowNumber, ParsedNumber highNumber) {
        if (!inputNumber.isPureNumeric()) {
            return;
        }
        ParsedNumber similarNumber = null;
        String lowSuffixString = String.valueOf(lowNumber.getSuffixNumber());
        String highSuffixString = String.valueOf(highNumber.getSuffixNumber());
        String lowPrefixString = String.valueOf(lowNumber.getAddressNumber());
        String highPrefixString = String.valueOf(highNumber.getAddressNumber());
        String inputString = String.valueOf(inputNumber.getAddressNumber());
        similarNumber = lowSuffixString.length() < highSuffixString.length() ? highNumber : (lowSuffixString.length() > highSuffixString.length() ? lowNumber : (lowPrefixString.length() > highPrefixString.length() ? lowNumber : highNumber));
        int trailingDigits = 0;
        trailingDigits = similarNumber == highNumber ? highSuffixString.length() : lowSuffixString.length();
        int leadingDigits = 0;
        leadingDigits = similarNumber == highNumber ? highPrefixString.length() : lowPrefixString.length();
        while (inputString.length() > leadingDigits + trailingDigits) {
            ++leadingDigits;
        }
        int numDigits = inputString.length() - leadingDigits;
        int divisor = 1;
        for (int i = 0; i < numDigits; ++i) {
            divisor *= 10;
        }
        long number = inputNumber.getAddressNumber() / (long)divisor;
        outputNumber.setAddressNumber(number);
        outputNumber.setAddressNumberExists(true);
        number = inputNumber.getAddressNumber() % (long)divisor;
        outputNumber.setSuffixNumber(number);
        outputNumber.setSuffixNumberExists(true);
        outputNumber.setNumberSeparator(similarNumber.getNumberSeparator());
        outputNumber.setNumFields(3);
        outputNumber.setHyphenatedNumber();
    }

    public boolean hasSeparator() {
        return this.getPrefixSeparator() != null && this.getPrefixSeparator().length() != 0 || this.getSuffixSeparator() != null && this.getSuffixSeparator().length() != 0 || this.getNumberSeparator() != null && this.getNumberSeparator().length() != 0 || this.getTrailerSeparator() != null && this.getTrailerSeparator().length() != 0;
    }

    public String getSuffixNumberAsString() {
        String str = String.valueOf(this.getSuffixNumber());
        if (this.m_suffixNumberLeadingZeros == 0) {
            return str;
        }
        return StringUtilities.intToLeadingZeroString(str.length() + this.m_suffixNumberLeadingZeros, (int)this.m_suffixNumber);
    }

    public boolean isFractionalTrailer() {
        return this.m_bFractionalTrailer;
    }

    public void setFractionalTrailer(boolean bFractionalTrailer) {
        this.m_bFractionalTrailer = bFractionalTrailer;
    }
}

