/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.common.ParsedNumber;

public class ParsedRangeScore {
    private boolean m_bValid = true;
    private boolean m_bCheckedInRange;
    private ParsedNumber m_scoringNumber;
    private String m_varyStringLow;
    private String m_varyStringHigh;
    private String m_varyString;
    private long m_varyNumLow;
    private long m_varyNumHigh;
    private long m_varyNum;
    private boolean m_bStringVaries;
    private boolean m_bNumVaries;
    private boolean m_bHasTrailingFraction;
    private boolean m_bAddsSuffix;
    private boolean m_bAddsTrailer;
    private boolean m_bIsHyphenated;
    private boolean m_bUseUnhyphenatedValue;
    private long m_unhyphenatedValue;
    private String m_addedString;
    private boolean m_bSourcePointRange;
    private boolean m_bCheckSwappedPrefix;
    private int m_numberFieldsMatched;
    private boolean m_bPrefixMatched;
    private boolean m_bNumberMatched;
    private boolean m_bSuffixMatched;
    private boolean m_bSuffixNumberMatched;
    private boolean m_bTrailerMatched;
    private boolean m_bSourceRangeHasMismatchedFractionalTrailers;
    private String m_lowTrailer;
    private String m_highTrailer;
    private String m_absentStringForInputNumber;
    private boolean m_bIsPrefixAbsentFromInputNumber;
    private boolean m_bIsSuffixAbsentFromInputNumber;

    public ParsedRangeScore(ParsedRangeScore copy) {
        this.m_bAddsSuffix = copy.m_bAddsSuffix;
        this.m_bAddsTrailer = copy.m_bAddsTrailer;
        if (this.m_bAddsSuffix || this.m_bAddsTrailer) {
            this.m_addedString = copy.m_addedString;
        }
        this.m_bCheckedInRange = copy.m_bCheckedInRange;
        this.m_bCheckSwappedPrefix = copy.m_bCheckSwappedPrefix;
        this.m_bHasTrailingFraction = copy.m_bHasTrailingFraction;
        this.m_bIsHyphenated = copy.m_bIsHyphenated;
        this.m_bNumberMatched = copy.m_bNumberMatched;
        this.m_bNumVaries = copy.m_bNumVaries;
        this.m_bPrefixMatched = copy.m_bPrefixMatched;
        this.m_bSourcePointRange = copy.m_bSourcePointRange;
        this.m_bSourceRangeHasMismatchedFractionalTrailers = copy.m_bSourceRangeHasMismatchedFractionalTrailers;
        this.m_bStringVaries = copy.m_bStringVaries;
        this.m_bSuffixMatched = copy.m_bSuffixMatched;
        this.m_bSuffixNumberMatched = copy.m_bSuffixNumberMatched;
        this.m_bTrailerMatched = copy.m_bTrailerMatched;
        this.m_bUseUnhyphenatedValue = copy.m_bUseUnhyphenatedValue;
        this.m_bValid = copy.m_bValid;
        this.m_highTrailer = copy.m_highTrailer;
        this.m_lowTrailer = copy.m_lowTrailer;
        this.m_numberFieldsMatched = copy.m_numberFieldsMatched;
        this.m_absentStringForInputNumber = copy.m_absentStringForInputNumber;
        this.m_bIsPrefixAbsentFromInputNumber = copy.m_bIsPrefixAbsentFromInputNumber;
        this.m_bIsSuffixAbsentFromInputNumber = copy.m_bIsSuffixAbsentFromInputNumber;
        if (copy.m_scoringNumber != null) {
            this.m_scoringNumber = new ParsedNumber(copy.m_scoringNumber);
        }
        this.m_unhyphenatedValue = copy.m_unhyphenatedValue;
        if (this.m_bNumVaries) {
            this.m_varyNum = copy.m_varyNum;
            this.m_varyNumHigh = copy.m_varyNumHigh;
            this.m_varyNumLow = copy.m_varyNumLow;
        } else if (this.m_bStringVaries) {
            this.m_varyString = copy.m_varyString;
            this.m_varyStringHigh = copy.m_varyStringHigh;
            this.m_varyStringLow = copy.m_varyStringLow;
        }
    }

    public ParsedRangeScore(ParsedNumber number) {
        this.m_scoringNumber = new ParsedNumber(number);
    }

    public boolean isValid() {
        return this.m_bValid;
    }

    public void setValid(boolean bValid) {
        this.m_bValid = bValid;
    }

    public String getVaryStringLow() {
        return this.m_varyStringLow;
    }

    public void setVaryStringLow(String varyStringLow) {
        this.m_varyStringLow = varyStringLow;
    }

    public String getVaryStringHigh() {
        return this.m_varyStringHigh;
    }

    public void setVaryStringHigh(String varyStringHigh) {
        this.m_varyStringHigh = varyStringHigh;
    }

    public String getVaryString() {
        return this.m_varyString;
    }

    public void setVaryString(String varyString) {
        this.m_varyString = varyString;
    }

    public long getVaryNumLow() {
        return this.m_varyNumLow;
    }

    public void setVaryNumLow(long varyNumLow) {
        this.m_varyNumLow = varyNumLow;
    }

    public long getVaryNumHigh() {
        return this.m_varyNumHigh;
    }

    public void setVaryNumHigh(long varyNumHigh) {
        this.m_varyNumHigh = varyNumHigh;
    }

    public long getVaryNum() {
        return this.m_varyNum;
    }

    public void setVaryNum(long varyNum) {
        this.m_varyNum = varyNum;
    }

    public boolean isStringVaries() {
        return this.m_bStringVaries;
    }

    public void setStringVaries(boolean bStringVaries) {
        this.m_bStringVaries = bStringVaries;
    }

    public boolean isNumVaries() {
        return this.m_bNumVaries;
    }

    public void setNumVaries(boolean bNumVaries) {
        this.m_bNumVaries = bNumVaries;
    }

    public boolean isHasTrailingFraction() {
        return this.m_bHasTrailingFraction;
    }

    public void setHasTrailingFraction(boolean bHasTrailingFraction) {
        this.m_bHasTrailingFraction = bHasTrailingFraction;
    }

    public boolean isAddsSuffix() {
        return this.m_bAddsSuffix;
    }

    public void setAddsSuffix(boolean bAddsSuffix) {
        this.m_bAddsSuffix = bAddsSuffix;
    }

    public boolean isAddsTrailer() {
        return this.m_bAddsTrailer;
    }

    public void setAddsTrailer(boolean bAddsTrailer) {
        this.m_bAddsTrailer = bAddsTrailer;
    }

    public boolean isHyphenated() {
        return this.m_bIsHyphenated;
    }

    public void setHyphenated(boolean bIsHyphenated) {
        this.m_bIsHyphenated = bIsHyphenated;
    }

    public long getUnhyphenatedValue() {
        return this.m_unhyphenatedValue;
    }

    public void setUnhyphenatedValue(long unhyphenatedValue) {
        this.m_unhyphenatedValue = unhyphenatedValue;
    }

    public String getAddedString() {
        return this.m_addedString;
    }

    public void setAddedString(String addedString) {
        this.m_addedString = addedString;
    }

    public void checkValid() {
        if (!this.m_bValid) {
            return;
        }
        if (this.m_bAddsSuffix) {
            if (this.m_bAddsTrailer) {
                this.m_bValid = false;
                return;
            }
            if (this.m_addedString == null || this.m_addedString.length() != 1) {
                this.m_bValid = false;
            }
        }
        if (this.m_bAddsTrailer) {
            if (this.m_bAddsSuffix) {
                this.m_bValid = false;
                return;
            }
            if (this.m_addedString == null || !this.m_bHasTrailingFraction && this.m_addedString.length() != 1) {
                this.m_bValid = false;
            }
        }
    }

    public boolean isInRange() {
        if (!this.m_bValid) {
            return false;
        }
        if (this.m_bUseUnhyphenatedValue) {
            if (this.m_varyNumLow <= this.m_unhyphenatedValue && this.m_unhyphenatedValue <= this.m_varyNumHigh) {
                this.m_bCheckedInRange = true;
                return true;
            }
            return false;
        }
        if (this.m_bStringVaries) {
            if (this.m_varyString.equalsIgnoreCase(this.m_varyStringLow)) {
                this.m_bCheckedInRange = true;
                return true;
            }
            if (this.m_varyString.equalsIgnoreCase(this.m_varyStringHigh)) {
                if (this.m_bAddsSuffix) {
                    return false;
                }
                if (this.m_bAddsTrailer && !this.m_bHasTrailingFraction) {
                    return false;
                }
                return this.isTrailingFractionAcceptable();
            }
            if (this.m_varyStringLow.compareTo(this.m_varyString) <= 0 && this.m_varyStringHigh.compareTo(this.m_varyString) >= 0) {
                if (this.m_bCheckSwappedPrefix && this.m_varyString.length() > this.m_varyStringLow.length()) {
                    return false;
                }
                this.m_bCheckedInRange = true;
                return true;
            }
            return false;
        }
        if (this.m_bNumVaries) {
            if (this.m_varyNum == this.m_varyNumHigh) {
                if (this.m_bSourceRangeHasMismatchedFractionalTrailers ? this.getHighTrailer().length() == 0 && this.m_scoringNumber.getAddressTrailer().length() != 0 : this.m_bAddsTrailer && !this.m_bHasTrailingFraction) {
                    return false;
                }
                return this.isTrailingFractionAcceptable();
            }
            if (this.m_varyNumLow == this.m_varyNum && this.m_bSourceRangeHasMismatchedFractionalTrailers && this.getLowTrailer().length() != 0 && this.m_scoringNumber.getAddressTrailer().length() == 0) {
                return false;
            }
            if (this.m_varyNumLow <= this.m_varyNum && this.m_varyNum <= this.m_varyNumHigh) {
                this.m_bCheckedInRange = true;
                return true;
            }
            return false;
        }
        return this.isTrailingFractionAcceptable();
    }

    private boolean isTrailingFractionAcceptable() {
        if (!this.m_bHasTrailingFraction) {
            this.m_bCheckedInRange = true;
            return true;
        }
        if (!this.m_bAddsTrailer) {
            this.m_bCheckedInRange = true;
            return true;
        }
        if (this.m_bAddsTrailer && this.m_bSourcePointRange) {
            this.m_bCheckedInRange = true;
            return true;
        }
        return false;
    }

    public boolean isSourcePointRange() {
        return this.m_bSourcePointRange;
    }

    public void setSourcePointRange(boolean bSourcePointRange) {
        this.m_bSourcePointRange = bSourcePointRange;
    }

    public boolean isUseUnhyphenatedValue() {
        return this.m_bUseUnhyphenatedValue;
    }

    public void setUseUnhyphenatedValue(boolean bUseUnhyphenatedValue) {
        this.m_bUseUnhyphenatedValue = bUseUnhyphenatedValue;
    }

    public boolean isCheckSwappedPrefix() {
        return this.m_bCheckSwappedPrefix;
    }

    public void setCheckSwappedPrefix(boolean checkSwappedPrefix) {
        this.m_bCheckSwappedPrefix = checkSwappedPrefix;
    }

    public int getNumberFieldsMatched() {
        if (this.m_bCheckedInRange) {
            if (this.m_bUseUnhyphenatedValue && this.m_numberFieldsMatched == 0) {
                return 3;
            }
            if (this.isNumVaries() || this.isStringVaries()) {
                return this.m_numberFieldsMatched + 1;
            }
        }
        return this.m_numberFieldsMatched;
    }

    public void setNumberFieldsMatched(int m_numberFieldsMatched) {
        this.m_numberFieldsMatched = m_numberFieldsMatched;
    }

    public ParsedNumber getScoringNumber() {
        return this.m_scoringNumber;
    }

    public void setScoringNumber(ParsedNumber m_scoringNumber) {
        this.m_scoringNumber = m_scoringNumber;
    }

    public boolean isPrefixMatched() {
        return this.m_bPrefixMatched;
    }

    public void setPrefixMatched(boolean bPrefixMatched) {
        this.m_bPrefixMatched = bPrefixMatched;
    }

    public boolean isNumberMatched() {
        return this.m_bNumberMatched;
    }

    public void setNumberMatched(boolean bNumberMatched) {
        this.m_bNumberMatched = bNumberMatched;
    }

    public boolean isSuffixMatched() {
        return this.m_bSuffixMatched;
    }

    public void setSuffixMatched(boolean bSuffixMatched) {
        this.m_bSuffixMatched = bSuffixMatched;
    }

    public boolean isSuffixNumberMatched() {
        return this.m_bSuffixNumberMatched;
    }

    public void setSuffixNumberMatched(boolean bSuffixNumberMatched) {
        this.m_bSuffixNumberMatched = bSuffixNumberMatched;
    }

    public boolean isTrailerMatched() {
        return this.m_bTrailerMatched;
    }

    public void setTrailerMatched(boolean bTrailerMatched) {
        this.m_bTrailerMatched = bTrailerMatched;
    }

    public boolean isSourceRangeHasMismatchedFractionalTrailers() {
        return this.m_bSourceRangeHasMismatchedFractionalTrailers;
    }

    public void setSourceRangeHasMismatchedFractionalTrailers(boolean bSourceRangeHasMismatchedFractionalTrailers) {
        this.m_bSourceRangeHasMismatchedFractionalTrailers = bSourceRangeHasMismatchedFractionalTrailers;
    }

    public String getLowTrailer() {
        return this.m_lowTrailer;
    }

    public void setLowTrailer(String lowTrailer) {
        this.m_lowTrailer = lowTrailer;
    }

    public String getHighTrailer() {
        return this.m_highTrailer;
    }

    public void setHighTrailer(String highTrailer) {
        this.m_highTrailer = highTrailer;
    }

    public String getAbsentStringForInputNumber() {
        return this.m_absentStringForInputNumber;
    }

    public void setAbsentStringForInputNumber(String absentString) {
        this.m_absentStringForInputNumber = absentString;
    }

    public boolean isPrefixAbsentFromInputNumber() {
        return this.m_bIsPrefixAbsentFromInputNumber;
    }

    public void setPrefixAbsentFromInputNumber(boolean bAbsent) {
        this.m_bIsPrefixAbsentFromInputNumber = bAbsent;
    }

    public boolean isSuffixAbsentFromInputNumber() {
        return this.m_bIsSuffixAbsentFromInputNumber;
    }

    public void setSuffixAbsentFromInputNumber(boolean bAbsent) {
        this.m_bIsSuffixAbsentFromInputNumber = bAbsent;
    }
}

