/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.ParsedRange;
import com.mapinfo.mapmarker.common.ParsedRangeScore;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Range {
    private int m_rangeDirection;
    private int m_oddEven;
    private ParsedNumber m_parsedFrom;
    private ParsedNumber m_parsedTo;
    private ParsedRange m_parsedRange;
    private ParsedRangeScore m_parsedRangeScore;
    private int m_divisionFactor;
    private List m_rangeUnits;
    private long m_offset;
    private int m_matchingRangeUnit;
    private int m_closestRangeUnit;
    private String m_placeName;
    private IIntermediateDataRecord[] m_IntermediateRecordArray;
    public static final int RANGE_DIRECTION_ASCENDING = 0;
    public static final int RANGE_DIRECTION_DESCENDING = 1;
    public static final int RANGE_DIRECTION_UNKNOWN = 2;
    public static final int ODDEVEN_ODD = 1;
    public static final int ODDEVEN_EVEN = 2;
    public static final int ODDEVEN_BOTH = 0;
    public static final int ODDEVEN_IRREGULAR = 5;
    private ParsedNumber m_matchedAddressNumber = null;
    private boolean m_lowHighSet;
    private int m_rangeNumber;
    private static List<String> FRACTIONS = Arrays.asList("1/4", "1/2", "3/4");
    private Map<String, String> m_additionalFields;

    public Range() {
        this.m_rangeDirection = 2;
        this.m_divisionFactor = 1;
        this.m_matchingRangeUnit = -1;
        this.m_closestRangeUnit = -1;
    }

    public Range(String from, String to) {
        this();
        if (to != null) {
            this.setTo(to);
            this.m_parsedTo = new ParsedNumber(to);
        }
        if (from != null) {
            this.setFrom(from);
            this.m_parsedFrom = new ParsedNumber(from);
        }
        this.computeAddressDirection();
        this.computeLowHighNumber();
    }

    public Range(Range range) {
        this.copy(range);
    }

    public long computeAddressesInRange() {
        if (this.getParsedTo() == null || this.getParsedFrom() == null) {
            return 0L;
        }
        if (this.m_rangeDirection == 2) {
            this.computeAddressDirection();
        }
        if (!this.m_lowHighSet) {
            this.computeLowHighNumber();
        }
        if (this.m_IntermediateRecordArray != null && this.m_IntermediateRecordArray.length > 0) {
            return this.m_IntermediateRecordArray.length;
        }
        if (this.getParsedRange().isPointRange()) {
            return 1L;
        }
        int varyingField = this.getParsedRange().getVaryingField();
        if (varyingField == 1) {
            return this.getParsedRange().getVaryingStringHigh().compareTo(this.getParsedRange().getVaryingStringLow()) / this.m_divisionFactor + 1;
        }
        if (varyingField == 2) {
            return (this.getParsedRange().getVaryingNumHigh() - this.getParsedRange().getVaryingNumLow()) / (long)this.m_divisionFactor + 1L;
        }
        if (varyingField == 3) {
            return this.getParsedRange().getVaryingStringHigh().compareTo(this.getParsedRange().getVaryingStringLow()) / this.m_divisionFactor + 1;
        }
        if (varyingField == 4) {
            return (this.getParsedRange().getVaryingNumHigh() - this.getParsedRange().getVaryingNumLow()) / (long)this.m_divisionFactor + 1L;
        }
        if (varyingField == 5) {
            return this.getParsedRange().getVaryingStringHigh().compareTo(this.getParsedRange().getVaryingStringLow()) / this.m_divisionFactor + 1;
        }
        return 1L;
    }

    public List<ParsedNumber> computeAddressNumbers() {
        if (this.isIrregularRange()) {
            return this.computeIrregularAddressNumbers();
        }
        if (this.getParsedTo() == null || this.getParsedFrom() == null) {
            return Collections.emptyList();
        }
        if (this.m_rangeDirection == 2) {
            this.computeAddressDirection();
        }
        if (!this.m_lowHighSet) {
            this.computeLowHighNumber();
        }
        switch (this.getParsedRange().getVaryingField()) {
            case 2: {
                return this.buildAddressNumbersVaryingByNumber();
            }
            case 1: {
                return this.buildAddressNumbersVaryingByPrefix();
            }
            case 3: {
                return this.buildAddressNumbersVaryingBySuffix();
            }
            case 4: {
                return this.buildAddressNumbersVaryingBySuffixNumber();
            }
            case 5: {
                return this.buildAddressNumbersVaryingByTrailer();
            }
        }
        return Collections.singletonList(new ParsedNumber(this.getLowNumber()));
    }

    private List<ParsedNumber> computeIrregularAddressNumbers() {
        ArrayList<ParsedNumber> result = new ArrayList<ParsedNumber>(this.m_IntermediateRecordArray.length);
        for (IIntermediateDataRecord record : this.m_IntermediateRecordArray) {
            result.add(new ParsedNumber(record.getHnr()));
        }
        return result;
    }

    private boolean isIrregularRange() {
        return this.m_IntermediateRecordArray != null && this.m_IntermediateRecordArray.length > 0;
    }

    private List<ParsedNumber> buildAddressNumbersVaryingByTrailer() {
        List<String> trailers;
        ParsedNumber low = this.getLowNumber();
        ParsedNumber high = this.getHighNumber();
        String lowTrl = low.getAddressTrailer();
        String highTrl = high.getAddressTrailer();
        if (StringUtilities.isNumeric(lowTrl) && StringUtilities.isNumeric(highTrl)) {
            List<Long> nums = this.buildNumberVariance(Long.parseLong(lowTrl), Long.parseLong(highTrl));
            trailers = new ArrayList<String>(nums.size());
            for (Long num : nums) {
                trailers.add(String.valueOf(num));
            }
        } else {
            trailers = lowTrl.indexOf(47) > 0 && highTrl.indexOf(47) > 0 ? this.buildFractionalVariance(lowTrl, highTrl) : this.buildStringVariance(lowTrl, highTrl);
        }
        ArrayList<ParsedNumber> result = new ArrayList<ParsedNumber>();
        for (String trailer : trailers) {
            ParsedNumber addrNum = new ParsedNumber(low);
            addrNum.setAddressTrailer(trailer);
            result.add(addrNum);
        }
        return result;
    }

    private List<String> buildFractionalVariance(String lowTrl, String highTrl) {
        int lowIndex = FRACTIONS.indexOf(lowTrl);
        int highIndex = FRACTIONS.indexOf(highTrl);
        ArrayList<String> result = new ArrayList<String>();
        if (lowIndex >= 0 && highIndex >= 0 && lowIndex <= highIndex) {
            for (int i = lowIndex; i <= highIndex; ++i) {
                result.add(FRACTIONS.get(i));
            }
        } else {
            result.add(lowTrl);
            result.add(highTrl);
        }
        return result;
    }

    private List<ParsedNumber> buildAddressNumbersVaryingBySuffix() {
        ParsedNumber low = this.getLowNumber();
        ParsedNumber high = this.getHighNumber();
        List<String> suffixes = this.buildStringVariance(low.getAddressSuffix(), high.getAddressSuffix());
        ArrayList<ParsedNumber> result = new ArrayList<ParsedNumber>();
        for (String suffix : suffixes) {
            ParsedNumber addrNum = new ParsedNumber(low);
            addrNum.setAddressSuffix(suffix);
            result.add(addrNum);
        }
        return result;
    }

    private List<ParsedNumber> buildAddressNumbersVaryingByPrefix() {
        ParsedNumber low = this.getLowNumber();
        ParsedNumber high = this.getHighNumber();
        List<String> prefixes = this.buildStringVariance(low.getAddressPrefix(), high.getAddressPrefix());
        ArrayList<ParsedNumber> result = new ArrayList<ParsedNumber>();
        for (String prefix : prefixes) {
            ParsedNumber addrNum = new ParsedNumber(low);
            addrNum.setAddressPrefix(prefix);
            result.add(addrNum);
        }
        return result;
    }

    private List<String> buildStringVariance(String low, String high) {
        int hiLen;
        ArrayList<String> result = new ArrayList<String>();
        int varyingIdx = 0;
        int lowLen = low.length();
        int len = lowLen <= (hiLen = high.length()) ? lowLen : hiLen;
        for (int i = 0; i < len; ++i) {
            if (low.charAt(i) == high.charAt(i)) continue;
            varyingIdx = i;
        }
        StringBuilder sb = new StringBuilder(low);
        while (sb.charAt(varyingIdx) != high.charAt(varyingIdx)) {
            result.add(sb.toString());
            sb.setCharAt(varyingIdx, (char)(sb.charAt(varyingIdx) + '\u0001'));
        }
        result.add(sb.toString());
        return result;
    }

    private List<ParsedNumber> buildAddressNumbersVaryingByNumber() {
        ParsedNumber low = this.getLowNumber();
        ParsedNumber high = this.getHighNumber();
        List<Long> nums = this.buildNumberVariance(low.getAddressNumber(), high.getAddressNumber());
        ArrayList<ParsedNumber> result = new ArrayList<ParsedNumber>();
        for (Long num : nums) {
            ParsedNumber addrNum = new ParsedNumber(low);
            addrNum.setAddressNumber(num);
            result.add(addrNum);
        }
        return result;
    }

    private List<ParsedNumber> buildAddressNumbersVaryingBySuffixNumber() {
        ParsedNumber low = this.getLowNumber();
        ParsedNumber high = this.getHighNumber();
        List<Long> nums = this.buildNumberVariance(low.getSuffixNumber(), high.getSuffixNumber());
        ArrayList<ParsedNumber> result = new ArrayList<ParsedNumber>();
        for (Long num : nums) {
            ParsedNumber addrNum = new ParsedNumber(low);
            addrNum.setSuffixNumber(num);
            result.add(addrNum);
        }
        return result;
    }

    private List<Long> buildNumberVariance(long low, long high) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long num = low; num <= high; num += (long)this.m_divisionFactor) {
            result.add(new Long(num));
        }
        return result;
    }

    public long computeOffsetInRange(ParsedNumber inputNumber) {
        int varyingField;
        if (inputNumber == null) {
            return -1L;
        }
        if (this.getParsedTo() == null || this.getParsedFrom() == null) {
            return -1L;
        }
        if (this.m_rangeDirection == 2) {
            this.computeAddressDirection();
        }
        if (!this.m_lowHighSet) {
            this.computeLowHighNumber();
        }
        if (this.getParsedRange().isPointRange()) {
            return 0L;
        }
        if (this.m_IntermediateRecordArray != null && this.m_IntermediateRecordArray.length > 0) {
            String input = inputNumber.getCombinedAddressNumber();
            for (int i = 0; i < this.m_IntermediateRecordArray.length; ++i) {
                if (!input.equals(this.m_IntermediateRecordArray[i].getHnr())) continue;
                return i;
            }
        }
        if ((varyingField = this.getParsedRange().getVaryingField()) == 1) {
            String inputString = inputNumber.getAddressPrefix();
            if (this.m_rangeDirection == 1) {
                return Math.abs(inputString.compareTo(this.getParsedRange().getVaryingStringHigh()) / this.m_divisionFactor);
            }
            return Math.abs(this.getParsedRange().getVaryingStringLow().compareTo(inputString) / this.m_divisionFactor);
        }
        if (varyingField == 2) {
            if (this.m_rangeDirection == 1) {
                return Math.abs(this.getParsedRange().getVaryingNumHigh() - inputNumber.getAddressNumber()) / (long)this.m_divisionFactor;
            }
            return Math.abs(inputNumber.getAddressNumber() - this.getParsedRange().getVaryingNumLow()) / (long)this.m_divisionFactor;
        }
        if (varyingField == 3) {
            String inputString = inputNumber.getAddressSuffix();
            if (this.m_rangeDirection == 1) {
                return Math.abs(inputString.compareTo(this.getParsedRange().getVaryingStringHigh()) / this.m_divisionFactor);
            }
            return Math.abs(this.getParsedRange().getVaryingStringLow().compareTo(inputString) / this.m_divisionFactor);
        }
        if (varyingField == 4) {
            if (this.m_rangeDirection == 1) {
                return Math.abs(this.getParsedRange().getVaryingNumHigh() - inputNumber.getSuffixNumber()) / (long)this.m_divisionFactor;
            }
            return Math.abs(inputNumber.getSuffixNumber() - this.getParsedRange().getVaryingNumLow()) / (long)this.m_divisionFactor;
        }
        if (varyingField == 5) {
            String inputString = inputNumber.getAddressTrailer();
            if (this.m_rangeDirection == 1) {
                return Math.abs(inputString.compareTo(this.getParsedRange().getVaryingStringHigh()) / this.m_divisionFactor);
            }
            return Math.abs(this.getParsedRange().getVaryingStringLow().compareTo(inputString) / this.m_divisionFactor);
        }
        return 0L;
    }

    public int isNumberInRange(ParsedNumber inputNumber) {
        if (inputNumber == null || inputNumber.isEmpty()) {
            return 0;
        }
        if (this.getParsedTo() == null || this.getParsedFrom() == null) {
            return 0;
        }
        if (this.m_rangeDirection == 2) {
            this.computeAddressDirection();
        }
        if (!this.m_lowHighSet) {
            this.computeLowHighNumber();
        }
        ParsedRangeScore score = null;
        ParsedNumber matchedIntermediateParsedNumber = null;
        if (this.m_IntermediateRecordArray != null && this.m_IntermediateRecordArray.length != 0) {
            ParsedRangeScore bestScore = null;
            for (int i = 0; i < this.m_IntermediateRecordArray.length; ++i) {
                boolean perfectMatch;
                ParsedNumber intermediateParseNumber = new ParsedNumber(this.m_IntermediateRecordArray[i].getHnr());
                ParsedRange intermediateRange = this.makeParsedRange(intermediateParseNumber);
                ParsedRangeScore intermediateScore = intermediateRange.scorePointRangeQueryNumber(inputNumber);
                boolean bl = perfectMatch = intermediateScore.getNumberFieldsMatched() == inputNumber.getNumFields() && inputNumber.getNumFields() == intermediateParseNumber.getNumFields();
                if (bestScore != null && !perfectMatch && !this.isBetterScore(bestScore, intermediateScore)) continue;
                bestScore = intermediateScore;
                if (bestScore.isNumberMatched()) {
                    matchedIntermediateParsedNumber = intermediateParseNumber;
                }
                if (perfectMatch) break;
            }
            score = bestScore;
        } else {
            if (inputNumber.equals(this.getLowNumber()) || inputNumber.equals(this.getHighNumber())) {
                this.m_matchedAddressNumber = inputNumber;
                score = this.getParsedRange().scoreQueryNumber(inputNumber);
                score.setScoringNumber(this.m_matchedAddressNumber);
                this.setParsedRangeScore(score);
                return inputNumber.getNumFields();
            }
            score = this.getParsedRange().scoreQueryNumber(inputNumber);
        }
        if (inputNumber == null || inputNumber.isEmpty()) {
            return 0;
        }
        this.m_matchedAddressNumber = new ParsedNumber(inputNumber);
        if (matchedIntermediateParsedNumber == null) {
            if (!score.isInRange()) {
                this.setParsedRangeScore(score);
                return 0;
            }
            if (score.isCheckSwappedPrefix()) {
                if (this.m_matchedAddressNumber.getAddressPrefix() != null) {
                    this.m_matchedAddressNumber.setAddressSuffix(this.m_matchedAddressNumber.getAddressPrefix());
                    this.m_matchedAddressNumber.setAddressPrefix(null);
                } else {
                    this.m_matchedAddressNumber.setAddressPrefix(this.m_matchedAddressNumber.getAddressSuffix());
                    this.m_matchedAddressNumber.setAddressSuffix(null);
                }
            }
            if (!score.isCheckSwappedPrefix() && !score.isPrefixMatched()) {
                this.m_matchedAddressNumber.setAddressPrefix(null);
            }
            if (!score.isCheckSwappedPrefix() & !score.isSuffixMatched()) {
                this.m_matchedAddressNumber.setAddressSuffix(null);
            }
            if (!score.isTrailerMatched()) {
                if (score.isHasTrailingFraction() && score.getVaryNumHigh() > score.getVaryNum()) {
                    this.m_matchedAddressNumber.setTrailerSeparator(" ");
                } else {
                    this.m_matchedAddressNumber.setAddressTrailer(null);
                }
            }
            if (!inputNumber.isHyphenatedNumber() && score.isNumberMatched() && this.m_parsedRange.isHyphenated()) {
                ParsedNumber.computeHyphenatedNumber(this.m_matchedAddressNumber, inputNumber, this.m_parsedRange.getLowEndpoint(), this.m_parsedRange.getHighEndpoint());
            } else if (score.isNumberMatched() && inputNumber.isHyphenatedNumber() && score.isSuffixNumberMatched() && !this.m_parsedRange.isHyphenated()) {
                this.m_matchedAddressNumber = new ParsedNumber(ParsedNumber.computeUnhyphenatedNumber(inputNumber, this.m_parsedRange.getLowEndpoint(), this.m_parsedRange.getHighEndpoint()));
            } else {
                if (!score.isNumberMatched()) {
                    this.m_matchedAddressNumber.setAddressNumberExists(false);
                }
                if (!score.isSuffixNumberMatched()) {
                    this.m_matchedAddressNumber.setSuffixNumberExists(false);
                }
                if (score.isSuffixNumberMatched() && score.isNumberMatched()) {
                    this.m_matchedAddressNumber.setNumberSeparator(this.m_parsedRange.getHighEndpoint().getNumberSeparator());
                } else if (!inputNumber.getSuffixSeparator().equals("") && this.m_parsedRange.getHighEndpoint().getSuffixSeparator().equals("")) {
                    this.m_matchedAddressNumber.setSuffixSeparator("");
                } else if (inputNumber.getSuffixSeparator().equals("") && !this.m_parsedRange.getHighEndpoint().getSuffixSeparator().equals("")) {
                    this.m_matchedAddressNumber.setSuffixSeparator(this.m_parsedRange.getHighEndpoint().getSuffixSeparator());
                } else if (!inputNumber.getNumberSeparator().equals("") && this.m_parsedRange.getHighEndpoint().getNumberSeparator().equals("")) {
                    this.m_matchedAddressNumber.setNumberSeparator("");
                } else if (inputNumber.getNumberSeparator().equals("") && !this.m_parsedRange.getHighEndpoint().getNumberSeparator().equals("")) {
                    this.m_matchedAddressNumber.setNumberSeparator(this.m_parsedRange.getHighEndpoint().getNumberSeparator());
                } else if (inputNumber.getPrefixSeparator().equals("") && !this.m_parsedRange.getHighEndpoint().getPrefixSeparator().equals("")) {
                    this.m_matchedAddressNumber.setPrefixSeparator(this.m_parsedRange.getHighEndpoint().getPrefixSeparator());
                } else if (!inputNumber.getPrefixSeparator().equals("") && this.m_parsedRange.getHighEndpoint().getPrefixSeparator().equals("")) {
                    this.m_matchedAddressNumber.setPrefixSeparator("");
                }
            }
            this.m_matchedAddressNumber.setHyphenatedNumber();
            this.m_matchedAddressNumber.setPureNumeric();
        } else {
            this.m_matchedAddressNumber = matchedIntermediateParsedNumber;
        }
        score.setScoringNumber(this.m_matchedAddressNumber);
        this.setParsedRangeScore(score);
        return score.getNumberFieldsMatched();
    }

    protected ParsedRange makeParsedRange(ParsedNumber number) {
        return new ParsedRange(number);
    }

    protected boolean isBetterScore(ParsedRangeScore oldScore, ParsedRangeScore newScore) {
        if (newScore.isNumberMatched() && !oldScore.isNumberMatched()) {
            return true;
        }
        if ((!oldScore.isNumberMatched() || newScore.isNumberMatched()) && newScore.getNumberFieldsMatched() > oldScore.getNumberFieldsMatched()) {
            return true;
        }
        return oldScore.isNumberMatched() && newScore.isNumberMatched() && oldScore.getNumberFieldsMatched() == newScore.getNumberFieldsMatched() && newScore.isAddsSuffix();
    }

    public ParsedNumber getSequenceNumberForIrregularHouseNumber(ParsedNumber inputNumber) {
        String seqNum = null;
        for (int i = 0; i < this.m_IntermediateRecordArray.length && (seqNum = this.m_IntermediateRecordArray[i].getSequenceNumberOfAddress(String.valueOf(inputNumber.getAddressNumber()))) == null; ++i) {
        }
        ParsedNumber interMediateParseNumber = new ParsedNumber(seqNum);
        return interMediateParseNumber;
    }

    public ParsedNumber getClosestAddressNumber(ParsedNumber inputNumber) {
        long toOffset;
        ParsedNumber closest;
        ParsedNumber parsedTo;
        if (inputNumber == null) {
            return new ParsedNumber((String)null);
        }
        ParsedNumber parsedFrom = this.getParsedFrom();
        if (parsedFrom.equals(parsedTo = this.getParsedTo())) {
            this.m_divisionFactor = 1;
        }
        if ((closest = this.getClosestIntermediateAddressNumber(inputNumber)) != null) {
            return closest;
        }
        long fromOffset = parsedFrom.computeDifference(inputNumber, this.m_divisionFactor);
        if (fromOffset > (toOffset = parsedTo.computeDifference(inputNumber, this.m_divisionFactor))) {
            return new ParsedNumber(parsedTo);
        }
        return new ParsedNumber(parsedFrom);
    }

    protected ParsedNumber getClosestIntermediateAddressNumber(ParsedNumber inputNumber) {
        ParsedNumber closest = null;
        if (this.getIntermediateRecordArray() != null && this.getIntermediateRecordArray().length > 0) {
            int step;
            int start;
            long closestOffest;
            ParsedNumber parsedFrom = this.getParsedFrom();
            ParsedNumber parsedTo = this.getParsedTo();
            long fromOffset = parsedFrom.computeDifference(inputNumber, this.m_divisionFactor);
            long toOffset = parsedTo.computeDifference(inputNumber, this.m_divisionFactor);
            int numRecords = this.m_IntermediateRecordArray.length;
            if (fromOffset > toOffset) {
                closest = parsedTo;
                closestOffest = toOffset;
                start = numRecords - 2;
                step = -1;
            } else {
                closest = parsedFrom;
                closestOffest = fromOffset;
                start = 1;
                step = 1;
            }
            if (this.getOddEven() == 5) {
                return closest;
            }
            int closestDirection = this.computeAddressDirection(closest, inputNumber);
            for (int i = start; i >= 1 && i < numRecords - 1; i += step) {
                ParsedNumber num = new ParsedNumber(this.m_IntermediateRecordArray[i].getHnr());
                long offset = num.computeDifference(inputNumber, this.m_divisionFactor);
                if (offset < closestOffest) {
                    closest = num;
                    closestOffest = offset;
                    if (this.computeAddressDirection(num, inputNumber) == closestDirection) continue;
                    break;
                }
                if (offset != closestOffest || this.computeAddressDirection(num, inputNumber) != closestDirection) break;
                closest = num;
                closestOffest = offset;
            }
        }
        return closest;
    }

    public long computeOffsetFromRange(ParsedNumber inputNumber) {
        long fromOffset;
        long toOffset;
        ParsedNumber parsedFrom = this.getParsedFrom();
        ParsedNumber parsedTo = this.getParsedTo();
        if (parsedFrom == null || parsedTo == null) {
            this.m_offset = Long.MAX_VALUE;
            return this.m_offset;
        }
        if (this.m_divisionFactor != 1 && parsedFrom.equals(parsedTo)) {
            this.m_divisionFactor = 1;
        }
        this.m_offset = (toOffset = parsedFrom.computeDifference(inputNumber, this.m_divisionFactor)) < (fromOffset = parsedTo.computeDifference(inputNumber, this.m_divisionFactor)) ? toOffset : fromOffset;
        return this.getRangeOffset();
    }

    protected void computeAddressDirection() {
        this.m_rangeDirection = this.computeAddressDirection(this.getParsedFrom(), this.getParsedTo());
    }

    private int computeAddressDirection(ParsedNumber parsedFrom, ParsedNumber parsedTo) {
        if (parsedTo == null || parsedFrom == null) {
            return 2;
        }
        if (parsedTo.equals(parsedFrom)) {
            return 0;
        }
        String toString = parsedTo.getAddressPrefix();
        String fromString = parsedFrom.getAddressPrefix();
        if (toString != null && fromString != null && !toString.equals(fromString)) {
            if (fromString.compareTo(toString) < 0) {
                return 0;
            }
            return 1;
        }
        long toNumber = parsedTo.getAddressNumber();
        long fromNumber = parsedFrom.getAddressNumber();
        if (parsedTo.getAddressNumberExists() && parsedFrom.getAddressNumberExists() && toNumber != fromNumber) {
            if (toNumber > fromNumber) {
                return 0;
            }
            return 1;
        }
        toString = parsedTo.getAddressSuffix();
        fromString = parsedFrom.getAddressSuffix();
        if (toString != null && fromString != null && !toString.equals(fromString)) {
            if (fromString.compareTo(toString) < 0) {
                return 0;
            }
            return 1;
        }
        toNumber = parsedTo.getSuffixNumber();
        fromNumber = parsedFrom.getSuffixNumber();
        if (parsedTo.getSuffixNumberExists() && parsedFrom.getSuffixNumberExists() && toNumber != fromNumber) {
            if (toNumber > fromNumber) {
                return 0;
            }
            return 1;
        }
        toString = parsedTo.getAddressTrailer();
        fromString = parsedFrom.getAddressTrailer();
        if (toString != null && fromString != null && !toString.equals(fromString)) {
            if (fromString.compareTo(toString) < 0) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    protected void computeLowHighNumber() {
        this.m_lowHighSet = true;
        if (this.getParsedTo() == null || this.getParsedFrom() == null) {
            return;
        }
        if (this.m_IntermediateRecordArray != null && this.m_IntermediateRecordArray.length != 0) {
            this.setParsedRange(new ParsedRange(new ParsedNumber(this.m_IntermediateRecordArray[0].getSeqNum()), new ParsedNumber(this.m_IntermediateRecordArray[this.m_IntermediateRecordArray.length - 1].getSeqNum())));
        } else if (this.m_rangeDirection == 1) {
            this.setParsedRange(new ParsedRange(this.getParsedTo(), this.getParsedFrom()));
        } else {
            this.setParsedRange(new ParsedRange(this.getParsedFrom(), this.getParsedTo()));
        }
    }

    public void copy(Range range) {
        if (range != null) {
            this.setFrom(range.getParsedFrom());
            this.setTo(range.getParsedTo());
            this.setRangeDirection(range.getRangeDirection());
            this.setOddEven(range.getOddEven());
            this.m_parsedRange = range.getParsedRange();
            this.setParsedRangeScore(range.getParsedRangeScore());
            this.m_matchedAddressNumber = range.getMatchedRangeNumber();
            this.computeAddressDirection();
            this.computeLowHighNumber();
            this.m_offset = range.m_offset;
            this.m_matchingRangeUnit = range.m_matchingRangeUnit;
            this.m_closestRangeUnit = range.m_closestRangeUnit;
            this.m_placeName = range.m_placeName;
            this.m_IntermediateRecordArray = range.m_IntermediateRecordArray;
            if (range.m_rangeUnits == null) {
                this.m_rangeUnits = null;
            } else {
                int units = this.getRangeUnitCount();
                for (int i = 0; i < units; ++i) {
                    this.addRangeUnit(new RangeUnit(range.getRangeUnitAt(i)));
                }
            }
        }
    }

    public void findMatchingRangeUnit(ParsedNumber unitNumber, String unitType) {
        int numRangeUnits = this.getRangeUnitCount();
        if (numRangeUnits <= 0) {
            return;
        }
        if (unitNumber == null) {
            return;
        }
        RangeUnit bestUnit = null;
        for (int i = 0; i < numRangeUnits; ++i) {
            RangeUnit unit = this.getRangeUnitAt(i);
            if (!unit.isUnitInRange(unitNumber, this.m_parsedRangeScore)) continue;
            if (unitType != null && unit.getUnitType().equals(unitType)) {
                unit.setTypeMatched();
            }
            if (bestUnit == null) {
                this.m_matchingRangeUnit = i;
                bestUnit = unit;
                continue;
            }
            if (bestUnit.getParsedRangeScore().isAddsSuffix() && !unit.getParsedRangeScore().isAddsSuffix()) {
                bestUnit = unit;
                this.m_matchingRangeUnit = i;
                continue;
            }
            if (bestUnit.getParsedRangeScore().isAddsSuffix() != unit.getParsedRangeScore().isAddsSuffix()) continue;
            if (bestUnit.getNumberOfUnits() > unit.getNumberOfUnits()) {
                bestUnit = unit;
                this.m_matchingRangeUnit = i;
                continue;
            }
            if (bestUnit.getTypeMatched() || !unit.getTypeMatched()) continue;
            bestUnit = unit;
            this.m_matchingRangeUnit = i;
        }
    }

    public void findClosestRangeUnit(ScoringAddress parsedInput) {
        ParsedNumber unitNumber = parsedInput.getParsedUnitValue();
        if (unitNumber == null || unitNumber.isEmpty()) {
            return;
        }
        int numRangeUnits = this.getRangeUnitCount();
        if (numRangeUnits == 0) {
            return;
        }
        long offset = Long.MAX_VALUE;
        for (int i = 0; i < numRangeUnits; ++i) {
            RangeUnit unit = this.getRangeUnitAt(i);
            long unitOffset = unit.computeOffsetFromRangeUnit(unitNumber, parsedInput, this.getParsedRangeScore());
            if (unitOffset != 0L) continue;
            this.m_closestRangeUnit = i;
        }
    }

    public void setTo(String to) {
        this.m_parsedTo = new ParsedNumber(to);
    }

    public void setTo(ParsedNumber parsedTo) {
        this.m_parsedTo = parsedTo;
    }

    public ParsedNumber getParsedTo() {
        return this.m_parsedTo;
    }

    public void setFrom(String from) {
        this.m_parsedFrom = new ParsedNumber(from);
    }

    public void setFrom(ParsedNumber parsedFrom) {
        this.m_parsedFrom = parsedFrom;
    }

    public ParsedNumber getParsedFrom() {
        return this.m_parsedFrom;
    }

    public void setPlaceName(String placeName) {
        this.m_placeName = placeName;
    }

    public void setIntermediateRecordArray(IIntermediateDataRecord[] recordArray) {
        this.m_IntermediateRecordArray = recordArray;
        Arrays.sort(this.m_IntermediateRecordArray);
    }

    public IIntermediateDataRecord[] getIntermediateRecordArray() {
        return this.m_IntermediateRecordArray;
    }

    public String getPlaceName() {
        return this.m_placeName;
    }

    public void setRangeDirection(int direction) {
        this.m_rangeDirection = direction;
    }

    public int getRangeDirection() {
        return this.m_rangeDirection;
    }

    public void setOddEven(int oddEven) {
        this.m_oddEven = oddEven;
        this.m_divisionFactor = oddEven == 1 || oddEven == 2 ? 2 : 1;
    }

    public int getOddEven() {
        return this.m_oddEven;
    }

    public int getNumberFieldsMatched() {
        if (this.m_parsedRange != null && this.m_parsedRange.getQueryScore() != null) {
            return this.m_parsedRange.getQueryScore().getNumberFieldsMatched();
        }
        return 0;
    }

    public ParsedNumber getMatchedRangeNumber() {
        if (this.m_matchedAddressNumber == null) {
            this.m_matchedAddressNumber = new ParsedNumber("");
        } else if (this.getLowNumber() != null && this.getLowNumber().equals(this.getHighNumber()) && !this.m_matchedAddressNumber.equals(this.getLowNumber()) && this.m_matchedAddressNumber.getAddressNumber() == this.getLowNumber().getAddressNumber()) {
            return this.getLowNumber();
        }
        return this.m_matchedAddressNumber;
    }

    public void setMatchedRangeNumber(ParsedNumber number) {
        this.m_matchedAddressNumber = number;
    }

    public void setRangeOffset(long offset) {
        this.m_offset = offset;
    }

    public long getRangeOffset() {
        return this.m_offset;
    }

    public void addRangeUnit(RangeUnit unit) {
        if (this.m_rangeUnits == null) {
            this.m_rangeUnits = new ArrayList();
        }
        this.m_rangeUnits.add(unit);
    }

    public int getRangeUnitCount() {
        if (this.m_rangeUnits == null) {
            return 0;
        }
        return this.m_rangeUnits.size();
    }

    public RangeUnit getRangeUnitAt(int index) {
        if (this.m_rangeUnits != null) {
            return (RangeUnit)this.m_rangeUnits.get(index);
        }
        return null;
    }

    public List getRangeUnits() {
        return this.m_rangeUnits;
    }

    public int getMatchingRangeUnit() {
        return this.m_matchingRangeUnit;
    }

    public void setMatchingRangeUnit(int unit) {
        this.m_matchingRangeUnit = unit;
    }

    public int getClosestRangeUnit() {
        return this.m_closestRangeUnit;
    }

    public void setClosestRangeUnit(int value) {
        this.m_closestRangeUnit = value;
    }

    public boolean hasMatchingRangeUnit() {
        return this.m_matchingRangeUnit >= 0;
    }

    public boolean hasClosestRangeUnit() {
        return this.m_closestRangeUnit >= 0;
    }

    public String getUnitValue(ParsedNumber inputUnitId) {
        if (this.hasMatchingRangeUnit()) {
            return inputUnitId.getCombinedAddressNumber();
        }
        if (this.hasClosestRangeUnit()) {
            RangeUnit unit = this.getRangeUnitAt(this.getClosestRangeUnit());
            if (inputUnitId.compareTo(new ParsedNumber(unit.getLowUnit())) < 0) {
                return unit.getLowUnit();
            }
            return unit.getHighUnit();
        }
        return null;
    }

    public String getUnitType() {
        if (this.hasMatchingRangeUnit()) {
            RangeUnit unit = this.getRangeUnitAt(this.getMatchingRangeUnit());
            if (unit != null) {
                return unit.getUnitType();
            }
            return null;
        }
        if (this.hasClosestRangeUnit()) {
            RangeUnit unit = this.getRangeUnitAt(this.getClosestRangeUnit());
            return unit.getUnitType();
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Range:\n");
        buffer.append("\tFrom=" + this.getParsedFrom().getCombinedAddressNumber() + ", To=" + this.getParsedTo().getCombinedAddressNumber() + "\n");
        buffer.append("\tPlaceName: " + this.getPlaceName() + "\n");
        buffer.append("\tRangeDirection=" + this.m_rangeDirection + "\n");
        buffer.append("\tAddresses in range=" + this.computeAddressesInRange() + "\n");
        if (this.getParsedRangeScore() != null) {
            buffer.append("\tNumberFields matched=" + this.getParsedRangeScore().getNumberFieldsMatched() + "\n");
            buffer.append("\t\tprefix string matched=" + this.getParsedRangeScore().isPrefixMatched() + "\n");
            buffer.append("\t\tnumber matched=" + this.getParsedRangeScore().isNumberMatched() + "\n");
            buffer.append("\t\tsuffix string matched=" + this.getParsedRangeScore().isSuffixMatched() + "\n");
            buffer.append("\t\tsuffix number matched=" + this.getParsedRangeScore().isSuffixNumberMatched() + "\n");
            buffer.append("\t\ttrailer string matched=" + this.getParsedRangeScore().isTrailerMatched() + "\n");
        }
        if (this.m_matchedAddressNumber != null) {
            buffer.append("\tMatchedNumber=" + this.m_matchedAddressNumber.getCombinedAddressNumber() + "\n");
        }
        buffer.append("\tintermediates? " + (this.m_IntermediateRecordArray != null) + "\n");
        if (this.m_IntermediateRecordArray != null) {
            for (IIntermediateDataRecord record : this.m_IntermediateRecordArray) {
                buffer.append("\t\t" + record.getHnr() + "\n");
            }
        }
        if (this.m_matchingRangeUnit != -1) {
            buffer.append("\tMatched Unit Number: " + this.m_matchingRangeUnit);
        }
        if (this.m_closestRangeUnit != -1) {
            buffer.append("\tClosest Unit Number: " + this.m_closestRangeUnit);
        }
        int count = this.getRangeUnitCount();
        for (int i = 0; i < count; ++i) {
            RangeUnit unit = this.getRangeUnitAt(i);
            buffer.append(unit.toString());
        }
        return buffer.toString();
    }

    public CandidateRange toCandidateRange(ParsedNumber inputHouseNumber, int side) {
        return this.toCandidateRange(inputHouseNumber, side, null, null);
    }

    public CandidateRange toCandidateRange(ParsedNumber inputHouseNumber, int side, ParsedNumber inputUnitNumber) {
        return this.toCandidateRange(inputHouseNumber, side, inputUnitNumber, null);
    }

    public CandidateRange toCandidateRange(ParsedNumber inputHouseNumber, int side, ParsedNumber inputUnitNumber, IConstraints constraints) {
        int rangeUnitCount;
        CandidateRange candRange = new CandidateRange();
        if (!this.m_lowHighSet) {
            this.computeLowHighNumber();
        }
        candRange.setLowAddress(this.getLowNumber().getCombinedAddressNumber());
        candRange.setHighAddress(this.getHighNumber().getCombinedAddressNumber());
        candRange.setOddEvenIndicator(this.getOddEven());
        candRange.setLeftRightIndicator(side);
        candRange.setPlaceName(this.getPlaceName());
        if (this.isNumberInRange(inputHouseNumber) > 0) {
            candRange.setOffset(0L);
        } else if (inputHouseNumber == null || inputHouseNumber.isEmpty()) {
            candRange.setOffset(Long.MIN_VALUE + this.m_parsedRange.getLowEndpoint().getAddressNumber());
        } else {
            candRange.setOffset(this.computeOffsetFromRange(inputHouseNumber));
        }
        candRange.setNumberOfAddresses(this.computeAddressesInRange());
        int maxRangeUnits = rangeUnitCount = this.getRangeUnitCount();
        if (constraints != null) {
            maxRangeUnits = constraints.getMaxRangeUnits();
        }
        candRange.setNumberOfReturnableRangeUnits(maxRangeUnits);
        if (maxRangeUnits != 0) {
            for (int i = 0; i < rangeUnitCount; ++i) {
                candRange.addRangeUnit(this.getRangeUnitAt(i).toCandidateRangeUnit(inputUnitNumber));
            }
        }
        candRange.getAdditionalFields().putAll(this.getAdditionalFields());
        return candRange;
    }

    protected ParsedNumber getLowNumber() {
        if (!this.m_lowHighSet) {
            this.computeLowHighNumber();
        }
        if (this.m_parsedRange == null) {
            return null;
        }
        if (this.getIntermediateRecordArray() != null) {
            ParsedNumber lownumber = this.m_parsedRange.getLowEndpoint();
            return new ParsedNumber(this.m_IntermediateRecordArray[0].getHouseNumberforSequence((short)lownumber.getAddressNumber()));
        }
        return this.m_parsedRange.getLowEndpoint();
    }

    protected ParsedNumber getHighNumber() {
        if (!this.m_lowHighSet) {
            this.computeLowHighNumber();
        }
        if (this.m_parsedRange == null) {
            return null;
        }
        if (this.getIntermediateRecordArray() != null) {
            ParsedNumber highnumber = this.m_parsedRange.getHighEndpoint();
            return new ParsedNumber(this.m_IntermediateRecordArray[this.m_IntermediateRecordArray.length - 1].getHouseNumberforSequence((short)highnumber.getAddressNumber()));
        }
        return this.m_parsedRange.getHighEndpoint();
    }

    protected int getDivisionFactor() {
        return this.m_divisionFactor;
    }

    public boolean getPrefixSuffixSwapped() {
        if (this.getParsedRangeScore() == null) {
            return false;
        }
        return this.getParsedRangeScore().isCheckSwappedPrefix();
    }

    public boolean getLetterAdded() {
        if (this.getParsedRangeScore() == null) {
            return false;
        }
        boolean bLetterAdded = this.getParsedRangeScore().isAddsSuffix() || this.getParsedRangeScore().isAddsTrailer();
        return bLetterAdded;
    }

    public ParsedRange getParsedRange() {
        if (!this.m_lowHighSet) {
            this.computeLowHighNumber();
        }
        return this.m_parsedRange;
    }

    public void setParsedRange(ParsedRange m_parsedRange) {
        this.m_parsedRange = m_parsedRange;
    }

    public ParsedRangeScore getParsedRangeScore() {
        return this.m_parsedRangeScore;
    }

    public void setParsedRangeScore(ParsedRangeScore score) {
        this.m_parsedRangeScore = score;
    }

    public void setRangeNumber(int rangeNumber) {
        this.m_rangeNumber = rangeNumber;
    }

    public int getRangeNumber() {
        return this.m_rangeNumber;
    }

    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.m_additionalFields = additionalFields;
    }

    protected Map<String, String> getAdditionalFields() {
        if (this.m_additionalFields == null) {
            this.m_additionalFields = Collections.emptyMap();
        }
        return this.m_additionalFields;
    }
}

