/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.Map;

public class ScoringAddress
implements Address {
    private static final StringScorer m_scorer = new StringScorer();
    private final Address m_address;
    private final Map m_placeNameCache;
    private final Map m_preAddressCache;
    private final Map m_preDirectionalCache;
    private final Map m_preThoroughfareTypeCache;
    private final Map m_mainAddrCache;
    private final Map m_postThoroughfareTypeCache;
    private final Map m_postDirectionalCache;
    private final Map m_postAddressCache;
    private final Map m_areaName1Cache;
    private final Map m_areaName2Cache;
    private final Map m_areaName3Cache;
    private final Map m_areaName4Cache;
    private String m_charsToIgnore = "";
    private ParsedNumber m_parsedUnitValue;

    public ScoringAddress(Address addr) {
        this.m_address = addr;
        this.m_placeNameCache = this.getPlaceName() != null ? new HashMap() : null;
        this.m_preAddressCache = this.getPreAddress() != null ? new HashMap() : null;
        this.m_preDirectionalCache = this.getPreDirectional() != null ? new HashMap() : null;
        this.m_preThoroughfareTypeCache = this.getPreThoroughfareType() != null ? new HashMap() : null;
        this.m_mainAddrCache = this.getMainAddress() != null ? new HashMap() : null;
        this.m_postThoroughfareTypeCache = this.getPostThoroughfareType() != null ? new HashMap() : null;
        this.m_postDirectionalCache = this.getPostDirectional() != null ? new HashMap() : null;
        this.m_postAddressCache = this.getPostAddress() != null ? new HashMap() : null;
        this.m_areaName1Cache = this.getAreaName1() != null ? new HashMap() : null;
        this.m_areaName2Cache = null;
        this.m_areaName3Cache = null;
        this.m_areaName4Cache = null;
        this.m_parsedUnitValue = new ParsedNumber(this.getUnitValue());
    }

    public ScoringAddress(Address addr, boolean bCacheArea1, boolean bCacheTypes, boolean bCachePrePost) {
        this.m_address = addr;
        this.m_placeNameCache = this.getPlaceName() != null ? new HashMap() : null;
        this.m_preDirectionalCache = this.getPreDirectional() != null ? new HashMap() : null;
        Map map = this.m_mainAddrCache = this.getMainAddress() != null ? new HashMap() : null;
        if (bCacheTypes) {
            this.m_preThoroughfareTypeCache = this.getPreThoroughfareType() != null ? new HashMap() : null;
            this.m_postThoroughfareTypeCache = this.getPostThoroughfareType() != null ? new HashMap() : null;
        } else {
            this.m_preThoroughfareTypeCache = null;
            this.m_postThoroughfareTypeCache = null;
        }
        Map map2 = this.m_postDirectionalCache = this.getPostDirectional() != null ? new HashMap() : null;
        if (bCachePrePost) {
            this.m_preAddressCache = this.getPreAddress() != null ? new HashMap() : null;
            this.m_postAddressCache = this.getPostAddress() != null ? new HashMap() : null;
        } else {
            this.m_preAddressCache = null;
            this.m_postAddressCache = null;
        }
        this.m_areaName1Cache = bCacheArea1 ? (this.getAreaName1() != null ? new HashMap() : null) : null;
        this.m_areaName2Cache = null;
        this.m_areaName3Cache = null;
        this.m_areaName4Cache = null;
        this.m_parsedUnitValue = new ParsedNumber(this.getUnitValue());
    }

    protected ScoringAddress(Address addr, Map placeNameCache, Map preAddrCache, Map preDirCache, Map preTypeCache, Map mainAddrCache, Map postTypeCache, Map postDirCache, Map postAddrCache, Map area1Cache, Map area2Cache, Map area3Cache, Map area4Cache) {
        this.m_address = addr;
        this.m_placeNameCache = placeNameCache;
        this.m_preAddressCache = preAddrCache;
        this.m_preDirectionalCache = preDirCache;
        this.m_preThoroughfareTypeCache = preTypeCache;
        this.m_mainAddrCache = mainAddrCache;
        this.m_postThoroughfareTypeCache = postTypeCache;
        this.m_postDirectionalCache = postDirCache;
        this.m_postAddressCache = postAddrCache;
        this.m_areaName1Cache = area1Cache;
        this.m_areaName2Cache = area2Cache;
        this.m_areaName3Cache = area3Cache;
        this.m_areaName4Cache = area4Cache;
        this.m_parsedUnitValue = new ParsedNumber(this.getUnitValue());
    }

    protected Address getAddress() {
        return this.m_address;
    }

    public StringScorer getStringScorer() {
        return m_scorer;
    }

    public void setCharsToIgnore(String chars) {
        this.m_charsToIgnore = chars;
    }

    public String getCharsToIgnore() {
        return this.m_charsToIgnore;
    }

    @Override
    public void setGenericField1(String fld) {
        this.m_address.setGenericField1(fld);
    }

    @Override
    public String getGenericField1() {
        return this.m_address.getGenericField1();
    }

    @Override
    public void setGenericField2(String fld) {
        this.m_address.setGenericField2(fld);
    }

    @Override
    public String getGenericField2() {
        return this.m_address.getGenericField2();
    }

    @Override
    public void setGenericField3(String fld) {
        this.m_address.setGenericField3(fld);
    }

    @Override
    public String getGenericField3() {
        return this.m_address.getGenericField3();
    }

    @Override
    public void setGenericField4(String fld) {
        this.m_address.setGenericField4(fld);
    }

    @Override
    public String getGenericField4() {
        return this.m_address.getGenericField4();
    }

    @Override
    public void setPreAddress(String preAddr) {
        this.m_address.setPreAddress(preAddr);
    }

    @Override
    public String getPreAddress() {
        return this.m_address.getPreAddress();
    }

    @Override
    public void setAddressNumber(String number) {
        this.m_address.setAddressNumber(number);
    }

    @Override
    public void setAddressNumber(ParsedNumber number) {
        this.m_address.setAddressNumber(number);
    }

    @Override
    public String getAddressNumber() {
        return this.m_address.getAddressNumber();
    }

    @Override
    public ParsedNumber getParsedAddressNumber() {
        return this.m_address.getParsedAddressNumber();
    }

    @Override
    public void setMainAddress(String mainAddr) {
        this.m_address.setMainAddress(mainAddr);
    }

    @Override
    public String getMainAddress() {
        return this.m_address.getMainAddress();
    }

    @Override
    public void setPlaceName(String place) {
        this.m_address.setPlaceName(place);
    }

    @Override
    public String getPlaceName() {
        return this.m_address.getPlaceName();
    }

    @Override
    public void setPreThoroughfareType(String type) {
        this.m_address.setPreThoroughfareType(type);
    }

    @Override
    public String getPreThoroughfareType() {
        return this.m_address.getPreThoroughfareType();
    }

    @Override
    public void setPostThoroughfareType(String type) {
        this.m_address.setPostThoroughfareType(type);
    }

    @Override
    public String getPostThoroughfareType() {
        return this.m_address.getPostThoroughfareType();
    }

    @Override
    public void setPostAddress(String postAddr) {
        this.m_address.setPostAddress(postAddr);
    }

    @Override
    public String getPostAddress() {
        return this.m_address.getPostAddress();
    }

    @Override
    public void setPostCode1(String postcode) {
        this.m_address.setPostCode1(postcode);
    }

    @Override
    public String getPostCode1() {
        return this.m_address.getPostCode1();
    }

    @Override
    public void setPostCode2(String postcode) {
        this.m_address.setPostCode2(postcode);
    }

    @Override
    public String getPostCode2() {
        return this.m_address.getPostCode2();
    }

    @Override
    public void setCountry(String country) {
        this.m_address.setCountry(country);
    }

    @Override
    public String getCountry() {
        return this.m_address.getCountry();
    }

    @Override
    public void setAreaName1(String areaname) {
        this.m_address.setAreaName1(areaname);
    }

    @Override
    public String getAreaName1() {
        return this.m_address.getAreaName1();
    }

    @Override
    public void setAreaName2(String areaname) {
        this.m_address.setAreaName2(areaname);
    }

    @Override
    public String getAreaName2() {
        return this.m_address.getAreaName2();
    }

    @Override
    public void setAreaName3(String areaname) {
        this.m_address.setAreaName3(areaname);
    }

    @Override
    public String getAreaName3() {
        return this.m_address.getAreaName3();
    }

    @Override
    public void setAreaName4(String areaname) {
        this.m_address.setAreaName4(areaname);
    }

    @Override
    public String getAreaName4() {
        return this.m_address.getAreaName4();
    }

    @Override
    public void setUnitType(String unittype) {
        this.m_address.setUnitType(unittype);
    }

    @Override
    public String getUnitType() {
        return this.m_address.getUnitType();
    }

    @Override
    public void setUnitValue(String unitvalue) {
        this.m_address.setUnitValue(unitvalue);
    }

    @Override
    public String getUnitValue() {
        return this.m_address.getUnitValue();
    }

    @Override
    public void setPreDirectional(String predir) {
        this.m_address.setPreDirectional(predir);
    }

    @Override
    public String getPreDirectional() {
        return this.m_address.getPreDirectional();
    }

    @Override
    public void setPostDirectional(String postdir) {
        this.m_address.setPostDirectional(postdir);
    }

    @Override
    public String getPostDirectional() {
        return this.m_address.getPostDirectional();
    }

    @Override
    public String getAddressID() {
        return this.m_address.getAddressID();
    }

    @Override
    public void setAddressID(String addressID) {
        this.m_address.setAddressID(addressID);
    }

    @Override
    public void setAdditionalFields(HashMap adFields) {
        this.m_address.setAdditionalFields(adFields);
    }

    @Override
    public HashMap getAdditionalFields() {
        return this.m_address.getAdditionalFields();
    }

    @Override
    public boolean hasAdditionalFields() {
        return this.m_address.hasAdditionalFields();
    }

    @Override
    public void flush() {
        this.m_address.flush();
    }

    @Override
    public String toString() {
        return this.m_address.toString();
    }

    public double scoreCountry(String str) {
        return this.doScore(str, this.getCountry(), null);
    }

    public double scoreGenericField1(String str) {
        return this.doScore(str, this.getGenericField1(), null);
    }

    public double scoreGenericField2(String str) {
        return this.doScore(str, this.getGenericField2(), null);
    }

    public double scoreGenericField3(String str) {
        return this.doScore(str, this.getGenericField3(), null);
    }

    public double scoreGenericField4(String str) {
        return this.doScore(str, this.getGenericField4(), null);
    }

    public double scorePlaceName(String str) {
        return this.doScore(str, this.getPlaceName(), this.m_placeNameCache);
    }

    public double scorePlaceName(String str, boolean bNoShortWordBonus) {
        return this.doScore(str, this.getPlaceName(), this.m_placeNameCache, bNoShortWordBonus);
    }

    public double scorePreAddress(String str) {
        return this.doScore(str, this.getPreAddress(), this.m_preAddressCache);
    }

    public double scorePreDirectional(String str) {
        return this.doScore(str, this.getPreDirectional(), this.m_preDirectionalCache);
    }

    public double scorePreThoroughfareType(String str) {
        return this.doScore(str, this.getPreThoroughfareType(), this.m_preThoroughfareTypeCache);
    }

    public double scoreMainAddress(String str) {
        return this.doScore(str, this.getMainAddress(), this.m_mainAddrCache);
    }

    public double scoreMainAddress(String str, boolean bNoShortWordBonus) {
        return this.doScore(str, this.getMainAddress(), this.m_mainAddrCache, bNoShortWordBonus);
    }

    public double scorePostThoroughfareType(String str) {
        return this.doScore(str, this.getPostThoroughfareType(), this.m_postThoroughfareTypeCache);
    }

    public double scorePostDirectional(String str) {
        return this.doScore(str, this.getPostDirectional(), this.m_postDirectionalCache);
    }

    public double scorePostAddress(String str) {
        return this.doScore(str, this.getPostAddress(), this.m_postAddressCache);
    }

    public double scorePostCode1(String str) {
        return this.doScore(str, this.getPostCode1(), null);
    }

    public double scorePostCode2(String str) {
        return this.doScore(str, this.getPostCode2(), null);
    }

    public double scoreAreaName1(String str) {
        return this.doScore(str, this.getAreaName1(), this.m_areaName1Cache);
    }

    public double scoreAreaName2(String str) {
        return this.doScore(str, this.getAreaName2(), this.m_areaName2Cache);
    }

    public double scoreAreaName3(String str) {
        return this.doScore(str, this.getAreaName3(), this.m_areaName3Cache);
    }

    public double scoreAreaName3(String str1, String str2) {
        return this.doScore(str1, str2, this.m_areaName3Cache);
    }

    public double scoreAreaName3(String str, boolean bNoShortWordBonus) {
        return this.doScore(str, this.getAreaName3(), this.m_areaName3Cache, bNoShortWordBonus);
    }

    public double scoreAreaName3WithoutVowels(String str) {
        String charsToIgnore = this.getCharsToIgnore();
        this.setCharsToIgnore(" AEIOU");
        double score = this.scoreAreaName3(str);
        this.setCharsToIgnore(charsToIgnore);
        return score;
    }

    public double scoreAreaName4(String str) {
        return this.doScore(str, this.getAreaName4(), this.m_areaName4Cache);
    }

    public double scoreUnitType(String str) {
        return this.doScore(str, this.getUnitType(), this.m_areaName4Cache);
    }

    protected double doScore(String str1, String str2, Map cache) {
        return this.doScore(str1, str2, cache, false);
    }

    protected double doScore(String str1, String str2, Map cache, boolean bNoShortWordBonus) {
        Double dbl;
        if (str1 == null) {
            if (str2 == null) {
                return 1.0;
            }
            return 0.0;
        }
        if (str2 == null) {
            return 0.0;
        }
        if (str1.equalsIgnoreCase(str2)) {
            return 1.0;
        }
        if (this.m_charsToIgnore.length() != 0) {
            str1 = StringUtilities.stripString(str1, this.m_charsToIgnore);
            str2 = StringUtilities.stripString(str2, this.m_charsToIgnore);
        }
        if (cache != null && (dbl = (Double)cache.get(str1 + str2)) != null) {
            return dbl;
        }
        double score = this.getStringScorer().scoreString(str1, str2, bNoShortWordBonus);
        if (cache != null) {
            cache.put(str1 + str2, new Double(score));
        }
        return score;
    }

    public ParsedNumber getParsedUnitValue() {
        return this.m_parsedUnitValue;
    }

    public void setParsedUnitValue(ParsedNumber m_parsedUnitValue) {
        this.m_parsedUnitValue = m_parsedUnitValue;
    }
}

