/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.ICompressedSegment;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Segment {
    private List m_SegmentPoints;
    private List m_LeftRanges;
    private List m_RightRanges;
    private String m_LeftPostCode1;
    private String m_LeftPostCode2;
    private String m_RightPostCode1;
    private String m_RightPostCode2;
    private String m_CoordSysInfo;
    private String m_LeftAreaName1;
    private String m_RightAreaName1;
    private String m_LeftAreaName2;
    private String m_RightAreaName2;
    private String m_LeftAreaName3;
    private String m_RightAreaName3;
    private String m_LeftAreaName4;
    private String m_RightAreaName4;
    private String m_segmentId;
    private long segmentOffset = -1L;
    private ICompressedSegment m_compressedSegment;
    private GeoInfoRecord m_geoinfo;
    private ICompressedSegment m_compressedHousePoints;
    private DirectPosition[] m_housePoints;
    public static final int SEGMENT_SIDE_LEFT = 0;
    public static final int SEGMENT_SIDE_RIGHT = 1;
    public static final int[] SEGMENT_SIDES = new int[]{0, 1};

    public Segment() {
    }

    public Segment(Segment segment) {
        this();
        this.copy(segment);
    }

    public void setLeftPostCode1(String postCode1) {
        this.m_LeftPostCode1 = postCode1;
    }

    public String getLeftPostCode1() {
        return this.m_LeftPostCode1;
    }

    public void setLeftPostCode2(String postCode2) {
        this.m_LeftPostCode2 = postCode2;
    }

    public String getLeftPostCode2() {
        return this.m_LeftPostCode2;
    }

    public void setRightPostCode1(String postCode1) {
        this.m_RightPostCode1 = postCode1;
    }

    public String getRightPostCode1() {
        return this.m_RightPostCode1;
    }

    public void setRightPostCode2(String postCode2) {
        this.m_RightPostCode2 = postCode2;
    }

    public String getRightPostCode2() {
        return this.m_RightPostCode2;
    }

    public void setCoordSysInfo(String CoordSysInfo) {
        this.m_CoordSysInfo = CoordSysInfo;
    }

    public String getCoordSysInfo() {
        return this.m_CoordSysInfo;
    }

    public void setLeftAreaName1(String leftAreaName1) {
        this.m_LeftAreaName1 = leftAreaName1;
    }

    public String getLeftAreaName1() {
        return this.m_LeftAreaName1;
    }

    public void setRightAreaName1(String rightAreaName1) {
        this.m_RightAreaName1 = rightAreaName1;
    }

    public String getRightAreaName1() {
        return this.m_RightAreaName1;
    }

    public void setLeftAreaName2(String leftAreaName2) {
        this.m_LeftAreaName2 = leftAreaName2;
    }

    public String getLeftAreaName2() {
        return this.m_LeftAreaName2;
    }

    public void setRightAreaName2(String rightAreaName2) {
        this.m_RightAreaName2 = rightAreaName2;
    }

    public String getRightAreaName2() {
        return this.m_RightAreaName2;
    }

    public void setLeftAreaName3(String leftAreaName3) {
        this.m_LeftAreaName3 = leftAreaName3;
    }

    public String getLeftAreaName3() {
        return this.m_LeftAreaName3;
    }

    public void setRightAreaName3(String rightAreaName3) {
        this.m_RightAreaName3 = rightAreaName3;
    }

    public String getRightAreaName3() {
        return this.m_RightAreaName3;
    }

    public void setLeftAreaName4(String leftAreaName4) {
        this.m_LeftAreaName4 = leftAreaName4;
    }

    public String getLeftAreaName4() {
        return this.m_LeftAreaName4;
    }

    public void setRightAreaName4(String rightAreaName4) {
        this.m_RightAreaName4 = rightAreaName4;
    }

    public String getRightAreaName4() {
        return this.m_RightAreaName4;
    }

    public void setGeoInfoRecord(GeoInfoRecord record) {
        this.m_geoinfo = record;
    }

    public GeoInfoRecord getGeoInfoRecord() {
        return this.m_geoinfo;
    }

    public String getLeftAltAreaName() {
        if (this.m_geoinfo != null) {
            return this.m_geoinfo.getAltAreaName3();
        }
        return null;
    }

    public String getRightAltAreaName() {
        if (this.m_geoinfo != null) {
            return this.m_geoinfo.getAltAreaName3();
        }
        return null;
    }

    public String getSegmentId() {
        return this.m_segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.m_segmentId = segmentId;
    }

    public void addRange(Range range, int side) {
        switch (side) {
            case 0: {
                if (this.m_LeftRanges == null) {
                    this.m_LeftRanges = new ArrayList();
                }
                this.m_LeftRanges.add(range);
                break;
            }
            case 1: {
                if (this.m_RightRanges == null) {
                    this.m_RightRanges = new ArrayList();
                }
                this.m_RightRanges.add(range);
            }
        }
    }

    public void addRange(String from, String to, int side) {
        Range range = this.makeRange(from, to);
        range.setOddEven(0);
        range.setRangeDirection(2);
        this.addRange(range, side);
    }

    public void addRange(String from, String to, int side, int ascDesc, int oddEven) {
        Range range = this.makeRange(from, to);
        this.addRange(range, side);
        range.setRangeDirection(ascDesc);
        range.setOddEven(oddEven);
    }

    public int getRangeCount(int side) {
        switch (side) {
            case 0: {
                if (this.m_LeftRanges == null) {
                    return 0;
                }
                return this.m_LeftRanges.size();
            }
            case 1: {
                if (this.m_RightRanges == null) {
                    return 0;
                }
                return this.m_RightRanges.size();
            }
        }
        return 0;
    }

    public Range getRangeAt(int index, int side) {
        switch (side) {
            case 0: {
                if (this.m_LeftRanges == null || this.m_LeftRanges.size() == 0) {
                    return null;
                }
                return (Range)this.m_LeftRanges.get(index);
            }
            case 1: {
                if (this.m_RightRanges == null || this.m_RightRanges.size() == 0) {
                    return null;
                }
                return (Range)this.m_RightRanges.get(index);
            }
        }
        return null;
    }

    public List getRanges(int side) {
        switch (side) {
            case 0: {
                if (this.m_LeftRanges == null) {
                    this.m_LeftRanges = new ArrayList();
                }
                return this.m_LeftRanges;
            }
            case 1: {
                if (this.m_RightRanges == null) {
                    this.m_RightRanges = new ArrayList();
                }
                return this.m_RightRanges;
            }
        }
        return null;
    }

    public void addSegmentPoint(DirectPosition pnt) {
        if (this.m_SegmentPoints == null) {
            this.m_SegmentPoints = new ArrayList();
        }
        this.m_SegmentPoints.add(pnt);
    }

    public void addSegmentPoint(double x, double y) {
        if (this.m_SegmentPoints == null) {
            this.m_SegmentPoints = new ArrayList();
        }
        DirectPosition pnt = new DirectPosition(x, y);
        this.m_SegmentPoints.add(pnt);
    }

    public int getSegmentPointCount() {
        if (this.m_SegmentPoints == null) {
            if (this.m_compressedSegment != null) {
                return this.m_compressedSegment.getNumberPoints();
            }
            return 0;
        }
        return this.m_SegmentPoints.size();
    }

    public void setPointsAsCompressed(ICompressedSegment compressedSegment) {
        this.m_compressedSegment = compressedSegment;
    }

    public DirectPosition getSegmentPointAt(int index) {
        if (this.m_SegmentPoints == null) {
            this.m_SegmentPoints = new ArrayList();
            this.buildSegmentPointsFromCompressed();
        }
        return (DirectPosition)this.m_SegmentPoints.get(index);
    }

    public List getSegmentPoints() {
        if (this.m_SegmentPoints == null) {
            this.m_SegmentPoints = new ArrayList();
            this.buildSegmentPointsFromCompressed();
        }
        return this.m_SegmentPoints;
    }

    public ICompressedSegment getSegmentPointsAsCompressed() {
        return this.m_compressedSegment;
    }

    public long getSegmentOffset() {
        return this.segmentOffset;
    }

    public void setSegmentOffset(long segmentOffset) {
        this.segmentOffset = segmentOffset;
    }

    public void copy(Segment segment) {
        if (segment != null) {
            Iterator it;
            this.setCoordSysInfo(segment.getCoordSysInfo());
            this.setLeftPostCode1(segment.getLeftPostCode1());
            this.setLeftPostCode2(segment.getLeftPostCode2());
            this.setRightPostCode1(segment.getRightPostCode1());
            this.setRightPostCode2(segment.getRightPostCode2());
            this.setLeftAreaName1(segment.getLeftAreaName1());
            this.setRightAreaName1(segment.getRightAreaName1());
            this.setLeftAreaName2(segment.getLeftAreaName2());
            this.setRightAreaName2(segment.getRightAreaName2());
            this.setLeftAreaName3(segment.getLeftAreaName3());
            this.setRightAreaName3(segment.getRightAreaName3());
            this.setLeftAreaName4(segment.getLeftAreaName4());
            this.setRightAreaName4(segment.getRightAreaName4());
            this.setSegmentId(segment.getSegmentId());
            this.setCoordSysInfo(segment.getCoordSysInfo());
            this.m_compressedSegment = segment.getSegmentPointsAsCompressed();
            if (this.m_compressedSegment == null) {
                this.m_SegmentPoints = new ArrayList();
                if (segment.getSegmentPointCount() > 0) {
                    it = segment.getSegmentPoints().iterator();
                    while (it.hasNext()) {
                        DirectPosition p = new DirectPosition((DirectPosition)it.next());
                        this.addSegmentPoint(p);
                    }
                }
            }
            this.m_LeftRanges = new ArrayList();
            if (segment.getRangeCount(0) > 0) {
                it = segment.getRanges(0).iterator();
                while (it.hasNext()) {
                    this.addRange(this.makeRange((Range)it.next()), 0);
                }
            }
            this.m_RightRanges = new ArrayList();
            if (segment.getRangeCount(1) > 0) {
                it = segment.getRanges(1).iterator();
                while (it.hasNext()) {
                    this.addRange(this.makeRange((Range)it.next()), 1);
                }
            }
            this.segmentOffset = segment.segmentOffset;
            this.m_geoinfo = segment.m_geoinfo;
        }
    }

    public String toString() {
        Range range;
        List rangeList;
        int i;
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer szRc = new StringBuffer("Segment Object");
        szRc.append(lineSeparator);
        szRc.append("leftPostCode1: " + this.getLeftPostCode1());
        szRc.append(lineSeparator);
        szRc.append("leftPostCode2: " + this.getLeftPostCode2());
        szRc.append(lineSeparator);
        szRc.append("leftAreaName1: " + this.getLeftAreaName1());
        szRc.append(lineSeparator);
        szRc.append("leftAreaName2: " + this.getLeftAreaName2());
        szRc.append(lineSeparator);
        szRc.append("leftAreaName3: " + this.getLeftAreaName3());
        szRc.append(lineSeparator);
        szRc.append("leftAreaName4: " + this.getLeftAreaName4());
        szRc.append(lineSeparator);
        szRc.append("rightPostCode1: " + this.getRightPostCode1());
        szRc.append(lineSeparator);
        szRc.append("rightPostCode2: " + this.getRightPostCode2());
        szRc.append(lineSeparator);
        szRc.append("rightAreaName1: " + this.getRightAreaName1());
        szRc.append(lineSeparator);
        szRc.append("rightAreaName2: " + this.getRightAreaName2());
        szRc.append(lineSeparator);
        szRc.append("rightAreaName3: " + this.getRightAreaName3());
        szRc.append(lineSeparator);
        szRc.append("rightAreaName4: " + this.getRightAreaName4());
        if (this.m_segmentId != null) {
            szRc.append(lineSeparator);
            szRc.append("segmentId: " + this.m_segmentId);
        }
        if (this.m_geoinfo != null) {
            szRc.append(lineSeparator);
            szRc.append(this.m_geoinfo.toString());
        }
        szRc.append(lineSeparator);
        szRc.append("coordSysInfo: " + this.getCoordSysInfo());
        szRc.append(lineSeparator);
        szRc.append("SEGMENT POINTS: ");
        for (i = 0; i < this.getSegmentPointCount(); ++i) {
            DirectPosition pnt = this.getSegmentPointAt(i);
            szRc.append(lineSeparator);
            szRc.append(pnt.getX() + "," + pnt.getY());
        }
        szRc.append(lineSeparator);
        if (this.m_LeftRanges != null) {
            szRc.append("Left Ranges:");
            szRc.append(lineSeparator);
            rangeList = this.m_LeftRanges;
            for (i = 0; i < rangeList.size(); ++i) {
                range = (Range)rangeList.get(i);
                szRc.append(range.toString());
            }
            szRc.append(lineSeparator);
        }
        if (this.m_RightRanges != null) {
            szRc.append("Right Ranges:");
            szRc.append(lineSeparator);
            rangeList = this.m_RightRanges;
            for (i = 0; i < rangeList.size(); ++i) {
                range = (Range)rangeList.get(i);
                szRc.append(range.toString());
            }
        }
        return szRc.toString();
    }

    public void setHousePoints(ICompressedSegment housePoints) {
        this.m_compressedHousePoints = housePoints;
    }

    public boolean isHouseSegment() {
        return this.m_compressedHousePoints != null || this.m_housePoints != null;
    }

    public DirectPosition getHousePoint(int pointNumber) {
        if (!this.isHouseSegment()) {
            return null;
        }
        if (this.m_housePoints == null) {
            this.m_housePoints = this.m_compressedHousePoints.convert();
        }
        return this.m_housePoints[pointNumber];
    }

    protected void buildSegmentPointsFromCompressed() {
        DirectPosition[] pnts = this.getSegmentPointsAsCompressed().convert();
        for (int i = 0; i < pnts.length; ++i) {
            this.addSegmentPoint(pnts[i]);
        }
    }

    protected Range makeRange(Range source) {
        return new Range(source);
    }

    protected Range makeRange(String from, String to) {
        return new Range(from, to);
    }

    public void setHousePoints(DirectPosition[] points) {
        this.m_housePoints = points;
    }
}

