/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common;

import com.mapinfo.mapmarker.common.CollatorKeyCache;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class StringScorer {
    private static final ResourceBundle m_rb = ResourceBundle.getBundle("com.mapinfo.mapmarker.common.CommonStrings");
    private static final String CANNOT_RESET_RULES = "ex_StringScorer_cannot_reset_rules";
    private static final int DEFAULT_MAX_SHORT_WORD_LENGTH = 4;
    private final boolean m_ignoreAccents;
    private final boolean m_bPlainCompareOnly;
    private final Collator m_caseInsensitiveCollator;
    private Collator m_accentInsensitiveCollator;
    private final int m_maxShortWordLengthPlus1;
    private final CollatorKeyCache m_collatorKeyCache;

    public StringScorer(boolean ignoreAccents) {
        this(ignoreAccents, Locale.ENGLISH);
    }

    public StringScorer(boolean ignoreAccents, Locale loc) {
        this(ignoreAccents, loc, null);
    }

    public StringScorer(boolean ignoreAccents, Locale loc, String extraCollatorRules) {
        this(ignoreAccents, loc, extraCollatorRules, false);
    }

    public StringScorer(boolean ignoreAccents, Locale loc, String extraCollatorRules, boolean plainCompareOnly) {
        this(ignoreAccents, loc, extraCollatorRules, plainCompareOnly, 4);
    }

    public StringScorer(boolean ignoreAccents, Locale loc, String extraCollatorRules, boolean plainCompareOnly, int maxShortWordLength) {
        this.m_ignoreAccents = ignoreAccents;
        this.m_bPlainCompareOnly = plainCompareOnly;
        this.m_maxShortWordLengthPlus1 = maxShortWordLength + 1;
        if (this.m_bPlainCompareOnly) {
            this.m_caseInsensitiveCollator = null;
            this.m_accentInsensitiveCollator = null;
            this.m_collatorKeyCache = null;
        } else {
            this.m_caseInsensitiveCollator = Collator.getInstance(loc);
            this.m_caseInsensitiveCollator.setDecomposition(2);
            this.m_caseInsensitiveCollator.setStrength(1);
            this.m_accentInsensitiveCollator = Collator.getInstance(loc);
            this.m_accentInsensitiveCollator.setDecomposition(1);
            this.m_accentInsensitiveCollator.setStrength(0);
            if (extraCollatorRules != null && extraCollatorRules.trim().length() != 0) {
                RuleBasedCollator castedCollator = (RuleBasedCollator)this.m_accentInsensitiveCollator;
                RuleBasedCollator collator = null;
                try {
                    collator = new RuleBasedCollator(castedCollator.getRules() + extraCollatorRules);
                }
                catch (ParseException PEx) {
                    String msgstr = m_rb.getString(CANNOT_RESET_RULES);
                    MMJLog.getLog().error(msgstr, (Throwable)PEx);
                }
                if (collator != null) {
                    collator.setDecomposition(2);
                    collator.setStrength(0);
                    this.m_accentInsensitiveCollator = collator;
                }
            }
            this.m_collatorKeyCache = new CollatorKeyCache((RuleBasedCollator)this.m_accentInsensitiveCollator);
        }
    }

    public StringScorer() {
        this(false);
    }

    public double scoreString(String instr1, String instr2, String charsToIgnore) {
        return this.scoreString(instr1, instr2, charsToIgnore, false);
    }

    public double scoreString(String instr1, String instr2, String charsToIgnore, boolean bNoShortWordBonus) {
        if (charsToIgnore == null || charsToIgnore.length() == 0) {
            return this.scoreString(instr1, instr2, bNoShortWordBonus);
        }
        if (instr1 != null && instr2 != null) {
            instr1 = StringUtilities.stripString(instr1, charsToIgnore);
            instr2 = StringUtilities.stripString(instr2, charsToIgnore);
        }
        return this.scoreString(instr1, instr2, bNoShortWordBonus);
    }

    public double scoreString(String inStr1, String inStr2) {
        return this.scoreString(inStr1, inStr2, false);
    }

    public double scoreString(String inStr1, String inStr2, boolean bNoShortWordBonus) {
        double currentScore;
        int bestToken;
        double bestScore;
        int j;
        int i;
        double totalScore = 0.0;
        double possibleScore = 0.0;
        double score = 0.0;
        if (inStr1 == null || inStr2 == null) {
            totalScore = inStr1 == null && inStr2 == null ? 1.0 : 0.0;
            return totalScore;
        }
        if (inStr1.equalsIgnoreCase(inStr2)) {
            return 1.0;
        }
        int str1Len = inStr1.length();
        int str2Len = inStr2.length();
        StringTokenizer st1 = new StringTokenizer(inStr1);
        StringTokenizer st2 = new StringTokenizer(inStr2);
        int num1Tokens = st1.countTokens();
        int num2Tokens = st2.countTokens();
        double tokenPenalityWeight = 0.1;
        if (num1Tokens == 1 && num2Tokens == 1) {
            return this.scoreToken(inStr2, inStr1, bNoShortWordBonus);
        }
        if (num1Tokens == 1 && num2Tokens == 2 && str1Len == str2Len - 1) {
            String temp2 = StringUtilities.stripString(inStr2, " ");
            if (inStr1.equals(temp2)) {
                score = (1.0 + ((double)str1Len + 2.0) / ((double)str2Len + 2.0) + 1.0 + 1.0) / 4.0;
                return score;
            }
            return this.scoreToken(inStr1, temp2);
        }
        if (num1Tokens == 2 && num2Tokens == 1 && str2Len == str1Len - 1) {
            String temp1 = StringUtilities.stripString(inStr1, " ");
            if (inStr2.equals(temp1)) {
                score = (1.0 + ((double)str2Len + 2.0) / ((double)str1Len + 2.0) + 1.0 + 1.0) / 4.0;
                return score;
            }
            return this.scoreToken(inStr2, temp1);
        }
        if (num1Tokens == 1 && num2Tokens == 2 && str1Len == str2Len && inStr1.indexOf(45) > 0) {
            String temp2;
            String temp1 = StringUtilities.stripString(inStr1, "-");
            if (temp1.equals(temp2 = StringUtilities.stripString(inStr2, "- "))) {
                score = (1.0 + ((double)str1Len + 2.0) / ((double)str2Len + 2.0) + 1.0 + 1.0) / 4.0;
                return score;
            }
            return this.scoreToken(temp1, temp2);
        }
        if (num1Tokens == 2 && num2Tokens == 1 && str2Len == str1Len && inStr2.indexOf(45) > 0) {
            String temp1 = StringUtilities.stripString(inStr1, " -");
            String temp2 = StringUtilities.stripString(inStr2, "-");
            if (temp2.equals(temp1)) {
                score = (1.0 + ((double)str2Len + 2.0) / ((double)str1Len + 2.0) + 1.0 + 1.0) / 4.0;
                return score;
            }
            return this.scoreToken(temp2, temp1);
        }
        if (num1Tokens > num2Tokens) {
            i = 1;
            while (st2.hasMoreTokens()) {
                j = 1;
                bestScore = 0.0;
                bestToken = 1;
                StringTokenizer st1temp = new StringTokenizer(inStr1);
                String str2 = st2.nextToken();
                while (st1temp.hasMoreTokens()) {
                    currentScore = this.scoreToken(str2, st1temp.nextToken());
                    if (currentScore > bestScore) {
                        bestScore = currentScore;
                        bestToken = j;
                    }
                    ++j;
                }
                if (bestToken > i) {
                    possibleScore += (double)bestToken * tokenPenalityWeight + 1.0;
                    score += (double)i * tokenPenalityWeight + bestScore;
                } else {
                    possibleScore += (double)i * tokenPenalityWeight + 1.0;
                    score += (double)bestToken * tokenPenalityWeight + bestScore;
                }
                ++i;
            }
        } else {
            i = 1;
            while (st1.hasMoreTokens()) {
                j = 1;
                bestScore = 0.0;
                bestToken = 1;
                StringTokenizer st2temp = new StringTokenizer(inStr2);
                String str1 = st1.nextToken();
                while (st2temp.hasMoreTokens()) {
                    currentScore = this.scoreToken(st2temp.nextToken(), str1);
                    if (currentScore > bestScore) {
                        bestScore = currentScore;
                        bestToken = j;
                    }
                    if (currentScore == 1.0) break;
                    ++j;
                }
                if (bestToken > i) {
                    possibleScore += (double)bestToken * tokenPenalityWeight + 1.0;
                    score += (double)i * tokenPenalityWeight + bestScore;
                } else {
                    possibleScore += (double)i * tokenPenalityWeight + 1.0;
                    score += (double)bestToken * tokenPenalityWeight + bestScore;
                }
                ++i;
            }
        }
        int tokenCountDiff = Math.abs(num1Tokens - num2Tokens);
        for (int x = 0; x < tokenCountDiff; ++x) {
            score *= 0.75;
        }
        if (possibleScore == 0.0) {
            return 0.0;
        }
        return score / possibleScore;
    }

    public double scoreNonNullNonEqualStrings(String inStr1, String inStr2) {
        double currentScore;
        int bestToken;
        double bestScore;
        int j;
        int i;
        double possibleScore = 0.0;
        double score = 0.0;
        StringTokenizer st1 = new StringTokenizer(inStr1);
        StringTokenizer st2 = new StringTokenizer(inStr2);
        int num1Tokens = st1.countTokens();
        int num2Tokens = st2.countTokens();
        double tokenPenalityWeight = 0.1;
        if (num1Tokens == 1 && num2Tokens == 1) {
            return (this.scoreToken(inStr2, inStr1) + 0.1) / 1.1;
        }
        if (num1Tokens > num2Tokens) {
            i = 1;
            while (st2.hasMoreTokens()) {
                j = 1;
                bestScore = 0.0;
                bestToken = 1;
                StringTokenizer st1temp = new StringTokenizer(inStr1);
                String str2 = st2.nextToken();
                while (st1temp.hasMoreTokens()) {
                    currentScore = this.scoreToken(str2, st1temp.nextToken());
                    if (currentScore > bestScore) {
                        bestScore = currentScore;
                        bestToken = j;
                    }
                    ++j;
                }
                if (bestToken > i) {
                    possibleScore += (double)bestToken * tokenPenalityWeight + 1.0;
                    score += (double)i * tokenPenalityWeight + bestScore;
                } else {
                    possibleScore += (double)i * tokenPenalityWeight + 1.0;
                    score += (double)bestToken * tokenPenalityWeight + bestScore;
                }
                ++i;
            }
        } else {
            i = 1;
            while (st1.hasMoreTokens()) {
                j = 1;
                bestScore = 0.0;
                bestToken = 1;
                StringTokenizer st2temp = new StringTokenizer(inStr2);
                String str1 = st1.nextToken();
                while (st2temp.hasMoreTokens()) {
                    currentScore = this.scoreToken(st2temp.nextToken(), str1);
                    if (currentScore > bestScore) {
                        bestScore = currentScore;
                        bestToken = j;
                    }
                    ++j;
                }
                if (bestToken > i) {
                    possibleScore += (double)bestToken * tokenPenalityWeight + 1.0;
                    score += (double)i * tokenPenalityWeight + bestScore;
                } else {
                    possibleScore += (double)i * tokenPenalityWeight + 1.0;
                    score += (double)bestToken * tokenPenalityWeight + bestScore;
                }
                ++i;
            }
        }
        int tokenCountDiff = Math.abs(num1Tokens - num2Tokens);
        for (int x = 0; x < tokenCountDiff; ++x) {
            score *= 0.9;
        }
        if (possibleScore == 0.0) {
            return 0.0;
        }
        return score / possibleScore;
    }

    private double scoreToken(String token1, String token2) {
        return this.scoreToken(token1, token2, false);
    }

    private double scoreToken(String token1, String token2, boolean bNoShortWordBonus) {
        char iBchar;
        int iB;
        String iAcharStr;
        char iAchar;
        int iA;
        double score = 0.0;
        if (token1.equals(token2)) {
            return 1.0;
        }
        if (this.m_bPlainCompareOnly) {
            return this.plainScoreToken(token1, token2, bNoShortWordBonus);
        }
        if (this.m_caseInsensitiveCollator.equals(token1, token2)) {
            return 1.0;
        }
        if (this.m_ignoreAccents && this.m_accentInsensitiveCollator.equals(token1, token2)) {
            return 1.0;
        }
        if (this.m_ignoreAccents) {
            return this.accentScoreToken(token1, token2, bNoShortWordBonus);
        }
        int str1Len = token1.length();
        int str2Len = token2.length();
        boolean[] str1Flags = new boolean[str1Len];
        boolean[] str2Flags = new boolean[str2Len];
        int Rnge = str1Len > str2Len ? str1Len / 2 - 1 : str2Len / 2 - 1;
        if (Rnge < 2) {
            Rnge = 2;
        }
        block0: for (iA = 0; iA < str1Len; ++iA) {
            int HighLim;
            int LowLim = iA - Rnge;
            if (LowLim < 0) {
                LowLim = 0;
            }
            if ((HighLim = iA + Rnge) > str2Len) {
                HighLim = str2Len;
            }
            iAchar = token1.charAt(iA);
            iAcharStr = String.valueOf(iAchar);
            for (iB = LowLim; iB < HighLim; ++iB) {
                if (str2Flags[iB]) continue;
                iBchar = token2.charAt(iB);
                if (iBchar == iAchar) {
                    str2Flags[iB] = true;
                    str1Flags[iA] = true;
                    continue block0;
                }
                if (!this.m_accentInsensitiveCollator.equals(String.valueOf(iBchar), iAcharStr)) continue;
                str2Flags[iB] = true;
                str1Flags[iA] = true;
                continue block0;
            }
        }
        int nTrans = 0;
        int nCom = 0;
        iB = -1;
        int nAccents = 0;
        for (iA = 0; iA < str1Len; ++iA) {
            String iBcharStr;
            if (!str1Flags[iA]) continue;
            ++iB;
            while (iB < str2Len && !str2Flags[iB]) {
                ++iB;
            }
            ++nCom;
            iAchar = token1.charAt(iA);
            if (iAchar == (iBchar = token2.charAt(iB)) || this.m_caseInsensitiveCollator.equals(iAcharStr = String.valueOf(iAchar), iBcharStr = String.valueOf(iBchar))) continue;
            if (this.m_accentInsensitiveCollator.equals(iAcharStr, iBcharStr)) {
                if (this.m_ignoreAccents) continue;
                ++nAccents;
                continue;
            }
            ++nTrans;
        }
        score = nCom == 0 && nTrans == 0 && nAccents == 0 ? 0.0 : (((double)nCom + 2.0) / ((double)str1Len + 2.0) + ((double)nCom + 2.0) / ((double)str2Len + 2.0) + ((double)(nCom - (nTrans /= 2)) + 0.01) / ((double)nCom + 0.01) + ((double)(nCom - nAccents) + 0.01) / ((double)nCom + 0.01)) / 4.0;
        return score;
    }

    private double accentScoreToken(String token1, String token2, boolean bNoShortWordBonus) {
        int[] token2Keys;
        int token2Length;
        int[] token1Keys = this.m_collatorKeyCache.getCollationKeyArray(token1);
        int token1Length = token1Keys.length;
        int range = token1Length > (token2Length = (token2Keys = this.m_collatorKeyCache.getCollationKeyArray(token2)).length) ? token1Length / 2 : token2Length / 2;
        if (range < 2) {
            range = 2;
        }
        int[] token1MatchedIndex = new int[token1Length];
        int[] token2MatchedIndex = new int[token2Length];
        int noMatch = -99;
        Arrays.fill(token1MatchedIndex, noMatch);
        Arrays.fill(token2MatchedIndex, noMatch);
        block0: for (int i = 0; i < token1Length || i < token2Length; ++i) {
            if (i < token1Length && i < token2Length && token2MatchedIndex[i] == noMatch && token1Keys[i] == token2Keys[i]) {
                token1MatchedIndex[i] = i;
                token2MatchedIndex[i] = i;
                continue;
            }
            for (int index = 1; index <= range; ++index) {
                if (i - index < token2Length && i < token1Length && i - index >= 0 && token2MatchedIndex[i - index] == noMatch && token1Keys[i] == token2Keys[i - index]) {
                    token1MatchedIndex[i] = i - index;
                    token2MatchedIndex[i - index] = i;
                    continue block0;
                }
                if (i + index >= token2Length || i >= token1Length || i + index >= token2Length || token2MatchedIndex[i + index] != noMatch || token1Keys[i] != token2Keys[i + index]) continue;
                token1MatchedIndex[i] = i + index;
                token2MatchedIndex[i + index] = i;
                continue block0;
            }
        }
        return this.scorePositionBuffers(token1MatchedIndex, token1Length, token2Length, token1, token2, bNoShortWordBonus);
    }

    private double scorePositionBuffers(int[] token1MatchedIndex, int token1Length, int token2Length, String token1, String token2, boolean bNoShortWordBonus) {
        double nComm = 0.0;
        double nTrans = 0.0;
        double nShifts = 0.0;
        double score = 0.0;
        int index = 0;
        while (index < token1Length) {
            if (index < token1Length - 1 && token1MatchedIndex[index] == index + 1 && token1MatchedIndex[index + 1] == index) {
                nTrans += 1.0;
                index += 2;
                continue;
            }
            if (token1MatchedIndex[index] >= 0) {
                if (index != token1MatchedIndex[index]) {
                    nShifts += (double)Math.abs(index - token1MatchedIndex[index]);
                }
                nComm += 1.0;
                ++index;
                continue;
            }
            ++index;
        }
        nTrans += nTrans * 0.5;
        if (nComm != 0.0 || nTrans != 0.0) {
            double score1 = (nComm + nTrans) / (double)token1Length;
            double score2 = (nComm + nTrans) / (double)token2Length;
            score = (score1 + score2) / 2.0;
            score -= nShifts * 0.01;
        }
        if (!bNoShortWordBonus && token1Length < this.m_maxShortWordLengthPlus1 && token1Length == token2Length && (double)(token1Length - 1) == nComm + nTrans + nShifts && token1.charAt(0) == token2.charAt(0)) {
            score = (1.0 + score) / 2.0;
        }
        return score;
    }

    private double plainScoreToken(String token1, String token2, boolean bNoShortWordBonus) {
        char[] token2Keys;
        int token2Length;
        char[] token1Keys = token1.toCharArray();
        int token1Length = token1Keys.length;
        int range = token1Length > (token2Length = (token2Keys = token2.toCharArray()).length) ? token1Length / 2 : token2Length / 2;
        if (range < 2) {
            range = 2;
        }
        int[] token1MatchedIndex = new int[token1Length];
        int[] token2MatchedIndex = new int[token2Length];
        int noMatch = -99;
        Arrays.fill(token1MatchedIndex, noMatch);
        Arrays.fill(token2MatchedIndex, noMatch);
        block0: for (int i = 0; i < token1Length || i < token2Length; ++i) {
            if (i < token1Length && i < token2Length && token2MatchedIndex[i] == noMatch && token1Keys[i] == token2Keys[i]) {
                token1MatchedIndex[i] = i;
                token2MatchedIndex[i] = i;
                continue;
            }
            for (int index = 1; index <= range; ++index) {
                if (i - index < token2Length && i < token1Length && i - index >= 0 && token2MatchedIndex[i - index] == noMatch && token1Keys[i] == token2Keys[i - index]) {
                    token1MatchedIndex[i] = i - index;
                    token2MatchedIndex[i - index] = i;
                    continue block0;
                }
                if (i + index >= token2Length || i >= token1Length || i + index >= token2Length || token2MatchedIndex[i + index] != noMatch || token1Keys[i] != token2Keys[i + index]) continue;
                token1MatchedIndex[i] = i + index;
                token2MatchedIndex[i + index] = i;
                continue block0;
            }
        }
        return this.scorePositionBuffers(token1MatchedIndex, token1Length, token2Length, token1, token2, bNoShortWordBonus);
    }
}

