/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AbstractIntermediateRangeRecord {
    private static final int MAX_UNSIGNED_BYTE = 255;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final int STORAGE_METHOD_STRING = 0;
    private static final int STORAGE_METHOD_SHORT = 1;
    private IIntermediateDataRecord[] m_records;
    private int m_storageMethod = 0;

    protected AbstractIntermediateRangeRecord(String houseNumber) {
        this.m_records = new IIntermediateDataRecord[1];
        this.m_records[0] = this.makeDataRecord();
        this.m_records[0].setSeqNum((short)0);
        this.m_records[0].setHnr(houseNumber);
        this.m_storageMethod = this.determineStorageMethod();
    }

    protected AbstractIntermediateRangeRecord(IIntermediateDataRecord[] records) {
        this.m_records = records;
        this.m_storageMethod = this.determineStorageMethod();
    }

    protected AbstractIntermediateRangeRecord(byte[] bytes) throws IOException {
        this.read(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public IIntermediateDataRecord[] getIntermediateDataRecords() {
        return this.m_records;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        this.write(out);
        out.close();
        return baos.toByteArray();
    }

    protected abstract IIntermediateDataRecord makeDataRecord();

    private int determineStorageMethod() {
        for (int i = 0; i < this.m_records.length; ++i) {
            try {
                int intValue = Integer.parseInt(this.m_records[i].getHnr());
                if (intValue >= 0 && intValue <= 65535) continue;
                return 0;
            }
            catch (NumberFormatException nfex) {
                return 0;
            }
        }
        return 1;
    }

    private void read(DataInput in) throws IOException {
        this.m_storageMethod = in.readUnsignedByte();
        switch (this.m_storageMethod) {
            case 0: {
                this.read(in, false);
                break;
            }
            case 1: {
                this.read(in, true);
                break;
            }
        }
    }

    private void read(DataInput in, boolean useShorts) throws IOException {
        int arrayLength = this.readCount(in);
        this.m_records = new IIntermediateDataRecord[arrayLength];
        IIntermediateDataRecord record = null;
        for (int i = 0; i < arrayLength; ++i) {
            record = this.makeDataRecord();
            record.setSeqNum((short)(i + 1));
            if (useShorts) {
                record.setHnr(String.valueOf(in.readUnsignedShort()));
            } else {
                record.setHnr(in.readUTF());
            }
            this.m_records[i] = record;
        }
    }

    private void write(DataOutput out) throws IOException {
        out.writeByte(this.m_storageMethod);
        switch (this.m_storageMethod) {
            case 0: {
                this.write(out, false);
                break;
            }
            case 1: {
                this.write(out, true);
                break;
            }
        }
    }

    private void write(DataOutput out, boolean useShorts) throws IOException {
        this.writeCount(out, this.m_records.length);
        for (int i = 0; i < this.m_records.length; ++i) {
            if (useShorts) {
                out.writeShort(Integer.valueOf(this.m_records[i].getHnr()));
                continue;
            }
            out.writeUTF(this.m_records[i].getHnr());
        }
    }

    private void writeCount(DataOutput out, int count) throws IOException {
        if (count < 255) {
            out.writeByte(count);
        } else if (count <= 510) {
            out.writeByte(255);
            out.writeByte(count - 255);
        } else {
            out.writeByte(0);
            out.writeShort(count);
        }
    }

    private int readCount(DataInput in) throws IOException {
        int count = in.readUnsignedByte();
        if (count == 0) {
            count = in.readUnsignedShort();
        } else if (count == 255) {
            count += in.readUnsignedByte();
        }
        return count;
    }
}

