/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.OnDemandDataAccess;
import java.io.IOException;

public class CachingDataAccess
implements IDataAccess {
    public static final int DEFAULT_CACHE_SIZE = 20;
    private IDataAccess m_baseAccess;
    private CacheItem[] m_cache;

    public CachingDataAccess(IDataAccessHelper helper) {
        this(helper, 20);
    }

    public CachingDataAccess(IDataAccessHelper helper, int cacheSize) {
        this(new OnDemandDataAccess(helper), cacheSize);
    }

    public CachingDataAccess(IDataAccess baseAccess) {
        this(baseAccess, 20);
    }

    public CachingDataAccess(IDataAccess baseAccess, int cacheSize) {
        if (EngineThreadingModel.isThreadsafe()) {
            throw new IllegalStateException("Engine must not be in the threadsafe model.");
        }
        this.m_baseAccess = baseAccess;
        this.m_cache = new CacheItem[cacheSize];
    }

    @Override
    public void init(String fileSpec) throws IOException, DataAccessException {
        this.m_baseAccess.init(fileSpec);
    }

    @Override
    public MMJDataFileMetadata getMetadata() {
        return this.m_baseAccess.getMetadata();
    }

    @Override
    public Object getRecord(long offset) throws DataAccessException {
        Object o = this.checkCache(offset);
        if (o == null) {
            o = this.m_baseAccess.getRecord(offset);
            this.insert(new CacheItem(offset, o));
        }
        return o;
    }

    private Object checkCache(long offset) {
        for (int i = 0; i < this.m_cache.length; ++i) {
            if (this.m_cache[i] == null) {
                return null;
            }
            if (!this.m_cache[i].match(offset)) continue;
            Object o = this.m_cache[i].getItem();
            this.promote(i);
            return o;
        }
        return null;
    }

    private void insert(CacheItem item) {
        this.promote(this.m_cache.length - 1);
        this.m_cache[0] = item;
    }

    private void promote(int index) {
        if (index != 0) {
            CacheItem atIndex = this.m_cache[index];
            System.arraycopy(this.m_cache, 0, this.m_cache, 1, index);
            this.m_cache[0] = atIndex;
        }
    }

    private static class CacheItem {
        private long m_offset;
        private Object m_item;

        private CacheItem(long offset, Object item) {
            this.m_offset = offset;
            this.m_item = item;
        }

        private boolean match(long offset) {
            return offset == this.m_offset;
        }

        public Object getItem() {
            return this.m_item;
        }
    }
}

