/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;

public class DataFileMasks {
    public static final byte MASK_TYPE_STREET = 0;
    public static final byte MASK_TYPE_SEGMENT = 1;
    public static final byte MASK_TYPE_RANGE = 2;
    public static final byte MASK_TYPE_RANGE_UNIT = 3;
    public static final byte MASK_TYPE_GEOINFO = 4;
    public static final byte MASK_TYPE_POSTINFO = 5;
    public static final short CUSTOM_RECORD = 0;
    public static final int MAX_TYPES = 127;
    public static final int MAX_MASKS_PER_TYPE = 255;
    private TypeMask[][] m_masks = new TypeMask[127][];
    private HashMap[] m_searchMaps = new HashMap[127];

    public DataFileMasks() {
    }

    public DataFileMasks(DataFileMasks that) {
        this();
        if (that != null && that.m_masks != null) {
            for (byte i = 0; i < (byte)(that.m_masks.length - 1); i = (byte)(i + 1)) {
                if (that.m_masks[i] == null) continue;
                this.m_masks[i] = new TypeMask[128];
                for (short j = 0; j < (short)that.m_masks[i].length; j = (short)(j + 1)) {
                    if (that.m_masks[i][j] == null) continue;
                    this.m_masks[i][j] = that.m_masks[i][j];
                }
            }
        }
    }

    public TypeMask getIndexedTypeMask(byte maskType, short maskID) {
        TypeMask[] a = this.m_masks[maskType];
        if (a != null) {
            return a[maskID - 1];
        }
        return null;
    }

    private HashMap makeSearchMap(TypeMask[] masks) {
        HashMap<TypeMask, Short> map = new HashMap<TypeMask, Short>();
        for (int i = 0; i < masks.length; i = (int)((short)(i + 1))) {
            if (masks[i] == null) continue;
            map.put(masks[i], new Short((short)(i + 1)));
        }
        return map;
    }

    public short getTypeMaskIndex(byte maskType, TypeMask mask) {
        TypeMask[] a = this.m_masks[maskType];
        if (a != null) {
            Short index;
            if (this.m_searchMaps[maskType] == null) {
                this.m_searchMaps[maskType] = this.makeSearchMap(a);
            }
            if ((index = (Short)this.m_searchMaps[maskType].get(mask)) == null) {
                return 0;
            }
            return index;
        }
        return 0;
    }

    public void setIndexedTypeMask(byte maskType, short maskID, TypeMask mask) {
        if (maskID <= 255 && maskID != 0) {
            if (this.m_masks[maskType] == null) {
                this.m_masks[maskType] = new TypeMask[255];
            }
            this.m_masks[maskType][maskID - 1] = mask;
        }
    }

    public void write(DataOutput out) throws IOException {
        byte i;
        int recordTypesCount = 0;
        for (i = 0; i < (byte)(this.m_masks.length - 1); i = (byte)(i + 1)) {
            if (this.m_masks[i] == null) continue;
            recordTypesCount = (byte)(recordTypesCount + 1);
        }
        out.writeByte(recordTypesCount);
        for (i = 0; i < (byte)this.m_masks.length; i = (byte)(i + 1)) {
            short j;
            if (this.m_masks[i] == null) continue;
            out.writeByte(i);
            int count = 0;
            for (j = 0; j < (short)this.m_masks[i].length; j = (short)(j + 1)) {
                if (this.m_masks[i][j] == null) continue;
                count = (short)(count + 1);
            }
            out.writeByte(count);
            for (j = 1; j < (short)(this.m_masks[i].length + 1); j = (short)(j + 1)) {
                if (this.m_masks[i][j - 1] == null) continue;
                out.writeByte(j);
                this.m_masks[i][j - 1].write(out);
            }
        }
    }

    public void read(DataInput in) throws IOException {
        byte recordTypesCount = in.readByte();
        for (byte i = 0; i < recordTypesCount; i = (byte)(i + 1)) {
            byte type = in.readByte();
            this.m_masks[type] = new TypeMask[255];
            short count = (short)in.readUnsignedByte();
            for (short j = 0; j < count; j = (short)(j + 1)) {
                short maskID = (short)in.readUnsignedByte();
                TypeMask mask = new TypeMask();
                mask.read(in);
                this.m_masks[type][maskID - 1] = mask;
            }
        }
    }
}

