/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import com.mapinfo.mapmarker.common.dp.binary.TypeMaskStats;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataFileStatistics {
    private TypeMaskStats[][] m_stats = new TypeMaskStats[127][];
    private List[] m_customStats = new ArrayList[127];
    private int[] m_customCounts = new int[127];
    private String[] m_maskLabels = new String[127];
    private static DataFileStatistics m_instance;
    private String m_miscString;

    protected DataFileStatistics() {
        this.m_maskLabels[4] = "GeoInfo";
        this.m_maskLabels[5] = "PostInfo";
        this.m_maskLabels[0] = "Street";
        this.m_maskLabels[1] = "Segment";
        this.m_maskLabels[2] = "Range";
        this.m_maskLabels[3] = "RangeUnit";
    }

    public static DataFileStatistics getStatisticsInstance() {
        if (m_instance == null) {
            m_instance = new DataFileStatistics();
        }
        return m_instance;
    }

    public static void resetStatistics() {
        m_instance = new DataFileStatistics();
    }

    public void setMaskLabel(byte maskType, String label) {
        this.m_maskLabels[maskType] = label;
    }

    public void logMask(byte maskType, TypeMask mask, short maskID) {
        if (maskID == 0) {
            TypeMaskStats stat2;
            byte by = maskType;
            this.m_customCounts[by] = this.m_customCounts[by] + 1;
            if (this.m_customStats[maskType] == null) {
                this.m_customStats[maskType] = new ArrayList();
            }
            for (TypeMaskStats stat2 : this.m_customStats[maskType]) {
                if (!stat2.getTypeMask().equals(mask)) continue;
                stat2.incrementMask();
                return;
            }
            stat2 = new TypeMaskStats();
            stat2.setTypeMask(mask);
            stat2.incrementMask();
            this.m_customStats[maskType].add(stat2);
        } else {
            if (this.m_stats[maskType] == null) {
                this.m_stats[maskType] = new TypeMaskStats[256];
            }
            if (this.m_stats[maskType][maskID] == null) {
                this.m_stats[maskType][maskID] = new TypeMaskStats();
                this.m_stats[maskType][maskID].setTypeMask(mask);
            }
            this.m_stats[maskType][maskID].incrementMask();
        }
    }

    public void outputStatistics(String statisticsFileName) {
        if (statisticsFileName == null) {
            return;
        }
        StringBuffer stats = new StringBuffer();
        for (int i = 0; i < this.m_stats.length; ++i) {
            String maskTypeLabel = this.m_maskLabels[i];
            if (maskTypeLabel == null) {
                maskTypeLabel = "MaskType: " + i;
            }
            long totalOfType = 0L;
            if (this.m_stats[i] != null) {
                stats.append(maskTypeLabel + "\n");
                for (int j = 1; j < this.m_stats[i].length; ++j) {
                    if (this.m_stats[i][j] == null) continue;
                    totalOfType += this.m_stats[i][j].getMaskCount();
                    stats.append("\tIndex: " + j + " Count: " + this.m_stats[i][j].getMaskCount() + " " + this.m_stats[i][j].getTypeMask().toString() + "\n");
                }
            }
            if (this.m_customStats[i] != null) {
                stats.append("Custom " + maskTypeLabel + " \n");
                stats.append("Total Custom " + maskTypeLabel + ": " + this.m_customCounts[i] + ".\n");
                Collections.sort(this.m_customStats[i]);
                int size = this.m_customStats[i].size();
                for (int j = 0; j < size; ++j) {
                    TypeMaskStats stat = (TypeMaskStats)this.m_customStats[i].get(j);
                    totalOfType += stat.getMaskCount();
                    stats.append(stat.toString());
                }
            }
            if (totalOfType == 0L) continue;
            stats.append("\t\t\tTotal " + maskTypeLabel + ": " + totalOfType + ".\n\n");
        }
        if (this.m_miscString != null) {
            stats.append(this.m_miscString);
        }
        try {
            PrintStream statFile = new PrintStream(new FileOutputStream(statisticsFileName + ".sts"));
            statFile.print(stats.toString());
            statFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addMiscStatString(String statString) {
        this.m_miscString = statString;
    }
}

