/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.OnDemandDataAccess;
import com.mapinfo.mapmarker.utils.IntObjMap;
import java.io.IOException;

public class DeferredLoadingDataAccess
implements IDataAccess {
    private IDataAccess m_baseAccess;
    private final IntObjMap m_dataAccessCache;
    private IDataAccessHelper m_helper;
    private String m_fileSpec;

    public DeferredLoadingDataAccess(IDataAccessHelper helper) {
        this(new OnDemandDataAccess(helper));
        this.m_helper = helper;
    }

    public DeferredLoadingDataAccess(IDataAccess baseAccess) {
        if (EngineThreadingModel.isThreadsafe()) {
            throw new IllegalStateException("Engine must not be in the threadsafe model.");
        }
        this.m_baseAccess = baseAccess;
        this.m_dataAccessCache = new IntObjMap();
    }

    @Override
    public void init(String fileSpec) throws IOException, DataAccessException {
        this.m_fileSpec = fileSpec;
        this.m_baseAccess.init(fileSpec);
    }

    @Override
    public MMJDataFileMetadata getMetadata() {
        return this.m_baseAccess.getMetadata();
    }

    @Override
    public Object getRecord(long offset) throws DataAccessException {
        Object record = this.m_dataAccessCache.get((int)offset);
        if (record == null) {
            record = this.m_baseAccess.getRecord(offset);
            this.m_dataAccessCache.put((int)offset, record);
        }
        return record;
    }

    protected IntObjMap getDataAccessCache() {
        return this.m_dataAccessCache;
    }

    protected String getFileSpec() {
        return this.m_fileSpec;
    }

    protected IDataAccessHelper getHelper() {
        return this.m_helper;
    }
}

