/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;

public class FrequentDataFileStrings {
    private String[][] m_frequentStrings;
    private HashMap[] m_searchMaps;
    public static final int MAX_BYTE_VALUE_INDEX = 255;
    public static final int MAX_SHORT_VALUE_INDEX = 65535;
    public static final int STRING_NOT_FOUND = -1;
    public static final int STREET_DATA_MAINADDRESS_STRINGS = 0;
    public static final int STREET_DATA_STREET_TYPE_STRINGS = 1;
    public static final int GEOINFO_DATA_AREANAME1_STRINGS = 0;
    public static final int GEOINFO_DATA_AREANAME2_STRINGS = 1;
    public static final int GEOINFO_DATA_AREANAME3_STRINGS = 2;
    public static final int GEOINFO_DATA_AREANAME4_STRINGS = 3;

    public FrequentDataFileStrings() {
        this.m_frequentStrings = null;
        this.m_searchMaps = null;
    }

    public FrequentDataFileStrings(FrequentDataFileStrings src) {
        this();
        this.copy(src);
    }

    public FrequentDataFileStrings(int[] types) {
        int numberOfTypes = this.max(types);
        this.m_frequentStrings = new String[numberOfTypes + 1][];
        this.m_searchMaps = new HashMap[numberOfTypes + 1];
    }

    public void addTypeStrings(int type, String[] typeStrings) {
        this.m_frequentStrings[type] = typeStrings;
    }

    public String getFrequentString(int type, int stringNumber) {
        if (this.m_frequentStrings == null || type >= this.m_frequentStrings.length) {
            return null;
        }
        String[] typeStrings = this.m_frequentStrings[type];
        if (typeStrings == null || stringNumber >= typeStrings.length) {
            return null;
        }
        return typeStrings[stringNumber];
    }

    private HashMap makeSearchMap(String[] strings) {
        HashMap<String, Short> map = new HashMap<String, Short>();
        for (short i = 0; i < strings.length; i = (short)((short)(i + 1))) {
            if (strings[i] == null) continue;
            map.put(strings[i], new Short(i));
        }
        return map;
    }

    public int getStringNumber(int type, String str) {
        Short index;
        if (this.m_frequentStrings == null || type >= this.m_frequentStrings.length) {
            return -1;
        }
        String[] typeStrings = this.m_frequentStrings[type];
        if (typeStrings == null) {
            return -1;
        }
        if (this.m_searchMaps[type] == null) {
            this.m_searchMaps[type] = this.makeSearchMap(typeStrings);
        }
        if ((index = (Short)this.m_searchMaps[type].get(str)) != null) {
            return index.intValue();
        }
        return -1;
    }

    public static final int convertByteToIndex(byte b) {
        if (b < 0) {
            int temp = b * -1;
            return temp += 127;
        }
        return b;
    }

    public static final int convertShortToIndex(short s) {
        if (s < 0) {
            int temp = s * -1;
            return temp += Short.MAX_VALUE;
        }
        return s;
    }

    public static final byte convertIndexToByte(int index) {
        if (index > 255 || index < 0) {
            System.err.println("ERROR: Index out of range.  Index Value: " + index + ".");
            System.exit(1);
        }
        if (index > 127) {
            int overFlow = index - 127;
            return (byte)(-1 * overFlow);
        }
        return (byte)index;
    }

    public static final short convertIndexToShort(int index) {
        if (index > 65535 || index < 0) {
            System.err.println("ERROR: Index out of range.  Index Value: " + index + ".");
            System.exit(1);
        }
        if (index > Short.MAX_VALUE) {
            int overFlow = index - Short.MAX_VALUE;
            return (short)(-1 * overFlow);
        }
        return (short)index;
    }

    public void write(DataOutput out) throws IOException {
        int numberOfTypes = 0;
        if (this.m_frequentStrings != null) {
            numberOfTypes = this.m_frequentStrings.length;
        }
        out.writeInt(numberOfTypes);
        for (int i = 0; i < numberOfTypes; ++i) {
            int numberOfStrings = 0;
            if (this.m_frequentStrings[i] != null) {
                numberOfStrings = this.m_frequentStrings[i].length;
            }
            out.writeInt(numberOfStrings);
            for (int j = 0; j < numberOfStrings; ++j) {
                out.writeUTF(this.m_frequentStrings[i][j]);
            }
        }
    }

    public void read(DataInput in) throws IOException {
        int numberOfTypes = in.readInt();
        if (numberOfTypes == 0) {
            return;
        }
        this.m_frequentStrings = new String[numberOfTypes][];
        for (int i = 0; i < numberOfTypes; ++i) {
            int numberOfStrings = in.readInt();
            if (numberOfStrings == 0) {
                this.m_frequentStrings[i] = null;
                continue;
            }
            this.m_frequentStrings[i] = new String[numberOfStrings];
            for (int j = 0; j < numberOfStrings; ++j) {
                this.m_frequentStrings[i][j] = in.readUTF();
            }
        }
    }

    public void copy(FrequentDataFileStrings src) {
        if (src != null) {
            int numberOfTypes = 0;
            if (src.m_frequentStrings != null) {
                numberOfTypes = src.m_frequentStrings.length;
                this.m_frequentStrings = new String[numberOfTypes][];
                for (int i = 0; i < numberOfTypes; ++i) {
                    int numberOfStrings = 0;
                    if (src.m_frequentStrings[i] != null) {
                        numberOfStrings = src.m_frequentStrings[i].length;
                        this.m_frequentStrings[i] = new String[numberOfStrings];
                        for (int j = 0; j < numberOfStrings; ++j) {
                            this.m_frequentStrings[i][j] = src.m_frequentStrings[i][j];
                        }
                        continue;
                    }
                    this.m_frequentStrings[i] = null;
                }
            } else {
                this.m_frequentStrings = null;
            }
        } else {
            this.m_frequentStrings = null;
        }
    }

    private int max(int[] ints) {
        int max = -1;
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] <= max) continue;
            max = ints[i];
        }
        return max;
    }
}

