/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.IDictionarySearchOrder;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.RangeUnit;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataItemFetcher;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.BlobAdditionalFieldsFactory;
import com.mapinfo.mapmarker.common.dp.binary.FrequentDataFileStrings;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GenericIINtermediateRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.TAIntermediateRangeRecord;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class GenericAddressFetcher
extends AbstractDataItemFetcher
implements IAddressFetcher {
    public static final String ERROR_BAD_STRING_LOOKUP_INDEX = "exception.localization.bad.lookup.index";

    public GenericAddressFetcher(Properties localSettings, Properties localStrings) {
        super(localSettings, localStrings);
    }

    public IRetrievedCandidates buildRetrievedCandidates(List candidates) {
        return new CoreRetrievedCandidates(candidates);
    }

    protected InternalCandidateAddress makeInternalCandidateAddress(StreetCandidateAddress street, IConstraints constraints) {
        return new InternalCandidateAddress(street);
    }

    protected Segment makeSegment() {
        return new Segment();
    }

    protected Range makeRange() {
        return new Range();
    }

    protected RangeUnit makeRangeUnit() {
        return new RangeUnit();
    }

    @Override
    public List makeStreetCandidates(StreetCandidateAddress street, SeekableDataInput file, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints) throws LocalizationException, IOException, MMJEDataCorruptedException {
        file.seek(street.getSegmentBlockOffset());
        int segmentCount = file.readUnsignedShort();
        ArrayList<InternalCandidateAddress> candidates = new ArrayList<InternalCandidateAddress>(segmentCount);
        IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
        Segment lastSegment = null;
        for (int h = 0; h < segmentCount; ++h) {
            InternalCandidateAddress cand = this.makeInternalCandidateAddress(street, constraints);
            cand.setVendorCode(String.valueOf(metadata.getVendorCode()));
            cand.setStreetOffset(street.getStreetOffset());
            candidates.add(cand);
            Segment segment = this.makeSegment();
            cand.setSegment(segment);
            GenericSegment genericSegment = this.createSegmentObject();
            long segmentOffset = file.getFilePointer();
            genericSegment.read((DataInput)file, metadata);
            this.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
            this.populateSegmentHousePoints(segment, genericSegment, metadata);
            lastSegment = segment;
            int rc = genericSegment.getRangeCount();
            if (rc == 0) continue;
            Range lastRange = null;
            for (int i = 0; i < rc; ++i) {
                GenericRange genericRange = genericSegment.getRange(i);
                Range range = this.makeRange();
                range.setRangeNumber(i);
                this.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
                lastRange = range;
                this.addRangeToSegment(segment, range, genericRange);
                int uc = genericRange.getRangeUnitCount();
                if (uc == 0) continue;
                RangeUnit lastRangeUnit = null;
                for (int j = 0; j < uc; ++j) {
                    GenericUnit genericUnit = genericRange.getRangeUnit(j);
                    RangeUnit unit = this.makeRangeUnit();
                    this.populateRangeUnitFromData(unit, genericUnit, metadata, dict, lastRangeUnit);
                    lastRangeUnit = unit;
                    range.addRangeUnit(unit);
                }
            }
        }
        return candidates;
    }

    protected StreetCandidateAddress getStreetCandidateAddressObject() {
        return new StreetCandidateAddress();
    }

    public StreetCandidateAddress makeStreetCandidateAddress(IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints) throws LocalizationException, IOException {
        StreetCandidateAddress address = this.getStreetCandidateAddressObject();
        this.populateCandidateFromData(address, street, streetOffset, metadata);
        return address;
    }

    @Override
    public List makeAlternateStreetCandidates(StreetCandidateAddress street, SeekableDataInput file, AlternateDataRecord record, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints) throws LocalizationException, IOException, MMJEDataCorruptedException {
        boolean allUnits;
        boolean allRanges;
        ArrayList<InternalCandidateAddress> candList = new ArrayList<InternalCandidateAddress>();
        IDictionarySearchOrder order = constraints.getDictionarySearchOrder();
        file.seek(street.getSegmentBlockOffset());
        int segmentCount = file.readUnsignedShort();
        short referencedSegment = record.getSegmentNumber();
        boolean allSegments = referencedSegment == -1;
        short referencedRange = 0;
        short referencedUnit = 0;
        if (allSegments) {
            allRanges = true;
            allUnits = true;
        } else {
            referencedRange = record.getRangeNumber();
            boolean bl = allRanges = referencedRange == -1;
            allUnits = allRanges ? true : (referencedUnit = record.getUnitNumber()) == -1;
        }
        Segment lastSegment = null;
        for (int i = 0; i < segmentCount; ++i) {
            GenericSegment genericSegment = this.createSegmentObject();
            long segmentOffset = file.getFilePointer();
            genericSegment.read((DataInput)file, metadata);
            Segment segment = this.makeSegment();
            this.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
            this.populateSegmentHousePoints(segment, genericSegment, metadata);
            lastSegment = segment;
            if (!allSegments && i != referencedSegment) continue;
            InternalCandidateAddress cand = this.makeInternalCandidateAddress(street, constraints);
            cand.setVendorCode(String.valueOf(metadata.getVendorCode()));
            cand.setStreetOffset(street.getStreetOffset());
            int dictNum = dict.getDictionaryNumber();
            cand.setDictionaryPriority(dictNum);
            if (order != null) {
                cand.setUserDictionaryPriority(order.getSearchOrderForDictionary(dictNum + 1));
            } else {
                cand.setUserDictionaryPriority(dictNum + 1);
            }
            segment.setSegmentOffset(record.getDataRecordSource() + (long)i);
            int rangeCount = genericSegment.getRangeCount();
            Range lastRange = null;
            for (int j = 0; j < rangeCount; ++j) {
                GenericRange genericRange = genericSegment.getRange(j);
                Range range = this.makeRange();
                range.setRangeNumber(j);
                this.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
                lastRange = range;
                if (!allRanges && referencedRange != j) continue;
                int unitCount = genericRange.getRangeUnitCount();
                RangeUnit lastRangeUnit = null;
                for (int k = 0; k < unitCount; ++k) {
                    GenericUnit genericUnit = genericRange.getRangeUnit(k);
                    RangeUnit unit = this.makeRangeUnit();
                    this.populateRangeUnitFromData(unit, genericUnit, metadata, dict, lastRangeUnit);
                    lastRangeUnit = unit;
                    if (!allUnits && referencedUnit != k) continue;
                    range.addRangeUnit(unit);
                }
                this.addRangeToSegment(segment, range, genericRange);
            }
            cand.setSegment(segment);
            candList.add(cand);
        }
        return candList;
    }

    @Override
    public InternalBrowseAddress makeBrowseAddress(StreetCandidateAddress street, SeekableDataInput file, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints) throws LocalizationException, IOException, MMJEDataCorruptedException {
        InternalBrowseAddress browseAddr = constraints.getHandler().getBrowseHelper().makeBrowseAddress(street);
        Segment lastSegment = null;
        file.seek(street.getSegmentBlockOffset());
        int segmentCount = file.readUnsignedShort();
        for (int i = 0; i < segmentCount; ++i) {
            browseAddr.setVendorCode(String.valueOf(metadata.getVendorCode()));
            GenericSegment genericSegment = this.createSegmentObject();
            long segmentOffset = file.getFilePointer();
            genericSegment.read((DataInput)file, metadata);
            Segment segment = this.makeSegment();
            this.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
            this.populateSegmentHousePoints(segment, genericSegment, metadata);
            lastSegment = segment;
            Segment previousSegment = browseAddr.getMatchingSegment(segment);
            if (previousSegment == null) {
                browseAddr.addSegment(segment);
            } else {
                segment = previousSegment;
            }
            int rangeCount = genericSegment.getRangeCount();
            Range lastRange = null;
            for (int j = 0; j < rangeCount; ++j) {
                GenericRange genericRange = genericSegment.getRange(j);
                Range range = this.makeRange();
                range.setRangeNumber(j);
                this.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
                lastRange = range;
                int unitCount = genericRange.getRangeUnitCount();
                RangeUnit lastRangeUnit = null;
                for (int k = 0; k < unitCount; ++k) {
                    GenericUnit genericUnit = genericRange.getRangeUnit(k);
                    RangeUnit unit = this.makeRangeUnit();
                    this.populateRangeUnitFromData(unit, genericUnit, metadata, dict, lastRangeUnit);
                    lastRangeUnit = unit;
                    range.addRangeUnit(unit);
                }
                this.addRangeToSegment(segment, range, genericRange);
            }
        }
        return browseAddr;
    }

    @Override
    public InternalBrowseAddress makeAlternateBrowseAddress(StreetCandidateAddress street, AlternateDataRecord record, SeekableDataInput file, MMJDataFileMetadata metadata, IDataDictionary dict, IConstraints constraints) throws LocalizationException, IOException, MMJEDataCorruptedException {
        boolean allUnits;
        boolean allRanges;
        InternalBrowseAddress browseAddr = constraints.getHandler().getBrowseHelper().makeBrowseAddress(street);
        file.seek(street.getSegmentBlockOffset());
        int segmentCount = file.readUnsignedShort();
        Segment lastSegment = null;
        short referencedSegment = record.getSegmentNumber();
        boolean allSegments = referencedSegment == -1;
        short referencedRange = 0;
        short referencedUnit = 0;
        if (allSegments) {
            allRanges = true;
            allUnits = true;
        } else {
            referencedRange = record.getRangeNumber();
            boolean bl = allRanges = referencedSegment == -1;
            allUnits = allRanges ? true : (referencedUnit = record.getUnitNumber()) == -1;
        }
        for (int i = 0; i < segmentCount; ++i) {
            GenericSegment genericSegment = this.createSegmentObject();
            long segmentOffset = file.getFilePointer();
            genericSegment.read((DataInput)file, metadata);
            Segment segment = this.makeSegment();
            this.populateSegmentFromData(segment, genericSegment, segmentOffset, metadata, dict, lastSegment);
            this.populateSegmentHousePoints(segment, genericSegment, metadata);
            lastSegment = segment;
            if (!allSegments && i != referencedSegment) continue;
            if (allSegments) {
                Segment previousSegment = browseAddr.getMatchingSegment(segment);
                if (previousSegment == null) {
                    browseAddr.addSegment(segment);
                } else {
                    segment = previousSegment;
                }
            } else {
                browseAddr.addSegment(segment);
            }
            int rangeCount = genericSegment.getRangeCount();
            Range lastRange = null;
            for (int j = 0; j < rangeCount; ++j) {
                GenericRange genericRange = genericSegment.getRange(j);
                Range range = this.makeRange();
                range.setRangeNumber(j);
                this.populateRangeFromData(range, genericRange, metadata, dict, lastRange);
                lastRange = range;
                if (!allRanges && j != referencedRange) continue;
                int unitCount = genericRange.getRangeUnitCount();
                RangeUnit lastRangeUnit = null;
                for (int k = 0; k < unitCount; ++k) {
                    if (!allUnits && k != referencedUnit) continue;
                    GenericUnit genericUnit = genericRange.getRangeUnit(k);
                    RangeUnit unit = this.makeRangeUnit();
                    this.populateRangeUnitFromData(unit, genericUnit, metadata, dict, lastRangeUnit);
                    lastRangeUnit = unit;
                    range.addRangeUnit(unit);
                }
                this.addRangeToSegment(segment, range, genericRange);
            }
        }
        return browseAddr;
    }

    protected void addRangeToSegment(Segment segment, Range range, GenericRange genericRange) throws LocalizationException {
        try {
            segment.addRange(range, genericRange.hasByte(2) ? (int)genericRange.getByte(2) : 0);
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
    }

    @Override
    public List getStreetData(SeekableDataInput file, long ptr, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException, LocalizationException {
        ArrayList<StreetCandidateAddress> data = null;
        if (file != null) {
            file.seek(ptr);
            int streetCount = file.readUnsignedShort();
            data = new ArrayList<StreetCandidateAddress>(streetCount);
            for (int i = 0; i < streetCount; ++i) {
                GenericStreet street = this.createStreetObject();
                long streetOffset = file.getFilePointer();
                street.read((DataInput)file, metadata);
                StreetCandidateAddress address = this.getStreetCandidateAddressObject();
                this.populateCandidateFromData(address, street, streetOffset, metadata);
                data.add(address);
            }
        }
        return data;
    }

    @Override
    public StreetCandidateAddress getSingleStreet(SeekableDataInput file, long offset, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException, LocalizationException {
        GenericStreet street = null;
        if (file != null) {
            street = this.createStreetObject();
            file.seek(offset);
            street.read((DataInput)file, metadata);
        }
        StreetCandidateAddress address = this.getStreetCandidateAddressObject();
        this.populateCandidateFromData(address, street, offset, metadata);
        return address;
    }

    @Override
    public AlternateDataRecord getAlternateData(SeekableDataInput file, long offset, MMJDataFileMetadata metadata) throws IOException {
        AlternateDataRecord record = new AlternateDataRecord();
        file.seek(offset);
        record.read(file);
        return record;
    }

    protected GenericStreet createStreetObject() {
        return new GenericStreet();
    }

    protected GenericSegment createSegmentObject() {
        return new GenericSegment();
    }

    protected void populateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        this.populateAddressFromData(cand, street, streetOffset, metadata);
    }

    protected void populateAddressFromData(Address addr, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException {
        GenericStreet genericStreet = (GenericStreet)street;
        MMJComplexDataFileMetadata complexMetadata = (MMJComplexDataFileMetadata)metadata;
        ((StreetCandidateAddress)addr).setStreetOffset(streetOffset);
        ((StreetCandidateAddress)addr).setSegmentBlockOffset(((GenericStreet)street).getSegmentBlockOffset());
        if (genericStreet.hasString(0)) {
            addr.setGenericField1(GenericDataItemAccessor.getDataString(0, genericStreet));
        }
        if (genericStreet.hasString(1)) {
            addr.setGenericField2(GenericDataItemAccessor.getDataString(1, genericStreet));
        }
        if (genericStreet.hasString(2)) {
            addr.setGenericField3(GenericDataItemAccessor.getDataString(2, genericStreet));
        }
        if (genericStreet.hasString(3)) {
            addr.setGenericField4(GenericDataItemAccessor.getDataString(3, genericStreet));
        }
        if (genericStreet.hasString(4)) {
            addr.setPreAddress(GenericDataItemAccessor.getDataString(4, genericStreet));
        }
        if (genericStreet.hasByte(1)) {
            addr.setMainAddress(complexMetadata.getFrequentStrings().getFrequentString(0, FrequentDataFileStrings.convertByteToIndex(GenericDataItemAccessor.getDataByte(1, genericStreet))));
        } else if (genericStreet.hasString(7)) {
            addr.setMainAddress(GenericDataItemAccessor.getDataString(7, genericStreet));
        }
        if (genericStreet.hasByte(0)) {
            addr.setPreThoroughfareType(complexMetadata.getFrequentStrings().getFrequentString(1, FrequentDataFileStrings.convertByteToIndex(GenericDataItemAccessor.getDataByte(0, genericStreet))));
        } else if (genericStreet.hasString(6)) {
            addr.setPreThoroughfareType(GenericDataItemAccessor.getDataString(6, genericStreet));
        }
        if (genericStreet.hasByte(2)) {
            addr.setPostThoroughfareType(complexMetadata.getFrequentStrings().getFrequentString(1, FrequentDataFileStrings.convertByteToIndex(GenericDataItemAccessor.getDataByte(2, genericStreet))));
        } else if (genericStreet.hasString(8)) {
            addr.setPostThoroughfareType(GenericDataItemAccessor.getDataString(8, genericStreet));
        }
        if (genericStreet.hasString(10)) {
            addr.setPostAddress(GenericDataItemAccessor.getDataString(10, genericStreet));
        }
        if (genericStreet.hasString(5)) {
            addr.setPreDirectional(GenericDataItemAccessor.getDataString(5, genericStreet));
        }
        if (genericStreet.hasString(9)) {
            addr.setPostDirectional(GenericDataItemAccessor.getDataString(9, genericStreet));
        }
        if (genericStreet.hasString(11)) {
            addr.setPostCode1(GenericDataItemAccessor.getDataString(11, genericStreet));
        }
        if (genericStreet.hasString(12)) {
            addr.setPostCode2(GenericDataItemAccessor.getDataString(12, genericStreet));
        }
        addr.setCountry(metadata.getCountry());
        if (genericStreet.hasString(13)) {
            addr.setAreaName1(GenericDataItemAccessor.getDataString(13, genericStreet));
        }
        if (genericStreet.hasString(14)) {
            addr.setAreaName2(GenericDataItemAccessor.getDataString(14, genericStreet));
        }
        if (genericStreet.hasString(15)) {
            addr.setAreaName3(GenericDataItemAccessor.getDataString(15, genericStreet));
        }
        if (genericStreet.hasString(16)) {
            addr.setAreaName4(GenericDataItemAccessor.getDataString(16, genericStreet));
        }
    }

    protected void populateSegmentHousePoints(Segment segment, GenericSegment genericSegment, MMJDataFileMetadata metadata) throws IOException, LocalizationException {
        try {
            segment.setHousePoints(genericSegment.getHousePoints(metadata));
        }
        catch (MMJEDataCorruptedException MMJEDCEx) {
            throw new LocalizationException(MMJEDCEx);
        }
    }

    protected void populateSegmentFromData(Segment segment, GenericSegment genericSegment, long segmentOffset, MMJDataFileMetadata metadata, IDataDictionary dict, Segment lastSegment) throws LocalizationException, IOException {
        String s;
        segment.setSegmentOffset(segmentOffset);
        if (genericSegment.hasString(14)) {
            s = GenericDataItemAccessor.getDataString(14, genericSegment);
            segment.setLeftAreaName1(s);
            segment.setRightAreaName1(s);
        } else {
            if (genericSegment.hasString(5)) {
                segment.setRightAreaName1(GenericDataItemAccessor.getDataString(5, genericSegment));
            }
            if (genericSegment.hasString(4)) {
                segment.setLeftAreaName1(GenericDataItemAccessor.getDataString(4, genericSegment));
            }
        }
        if (genericSegment.hasString(15)) {
            s = GenericDataItemAccessor.getDataString(15, genericSegment);
            segment.setLeftAreaName2(s);
            segment.setRightAreaName2(s);
        } else {
            if (genericSegment.hasString(7)) {
                segment.setRightAreaName2(GenericDataItemAccessor.getDataString(7, genericSegment));
            }
            if (genericSegment.hasString(6)) {
                segment.setLeftAreaName2(GenericDataItemAccessor.getDataString(6, genericSegment));
            }
        }
        if (genericSegment.hasString(16)) {
            s = GenericDataItemAccessor.getDataString(16, genericSegment);
            segment.setLeftAreaName3(s);
            segment.setRightAreaName3(s);
        } else {
            if (genericSegment.hasString(9)) {
                segment.setRightAreaName3(GenericDataItemAccessor.getDataString(9, genericSegment));
            }
            if (genericSegment.hasString(8)) {
                segment.setLeftAreaName3(GenericDataItemAccessor.getDataString(8, genericSegment));
            }
        }
        if (genericSegment.hasString(17)) {
            s = GenericDataItemAccessor.getDataString(17, genericSegment);
            segment.setLeftAreaName4(s);
            segment.setRightAreaName4(s);
        } else {
            if (genericSegment.hasString(11)) {
                segment.setRightAreaName4(GenericDataItemAccessor.getDataString(11, genericSegment));
            }
            if (genericSegment.hasString(10)) {
                segment.setLeftAreaName4(GenericDataItemAccessor.getDataString(10, genericSegment));
            }
        }
        if (genericSegment.hasString(12)) {
            s = GenericDataItemAccessor.getDataString(12, genericSegment);
            segment.setLeftPostCode1(s);
            segment.setRightPostCode1(s);
        } else {
            if (genericSegment.hasString(1)) {
                segment.setRightPostCode1(GenericDataItemAccessor.getDataString(1, genericSegment));
            }
            if (genericSegment.hasString(0)) {
                segment.setLeftPostCode1(GenericDataItemAccessor.getDataString(0, genericSegment));
            }
        }
        if (genericSegment.hasString(13)) {
            s = GenericDataItemAccessor.getDataString(13, genericSegment);
            segment.setLeftPostCode2(s);
            segment.setRightPostCode2(s);
        } else {
            if (genericSegment.hasString(3)) {
                segment.setRightPostCode2(GenericDataItemAccessor.getDataString(3, genericSegment));
            }
            if (genericSegment.hasString(2)) {
                segment.setLeftPostCode2(GenericDataItemAccessor.getDataString(2, genericSegment));
            }
        }
        if (genericSegment.hasString(19)) {
            segment.setSegmentId(GenericDataItemAccessor.getDataString(19, genericSegment));
        }
        if (genericSegment.hasLong(3)) {
            segment.setSegmentId(String.valueOf(GenericDataItemAccessor.getDataLong(3, genericSegment)));
        }
        segment.setPointsAsCompressed(genericSegment.getCompressedSegment());
    }

    protected void populateRangeFromData(Range range, GenericRange genericRange, MMJDataFileMetadata metadata, IDataDictionary dict, Range lastRange) throws LocalizationException, IOException {
        if (genericRange.hasByte(1)) {
            range.setRangeDirection(GenericDataItemAccessor.getDataByte(1, genericRange));
        }
        if (genericRange.hasByte(0)) {
            range.setOddEven(GenericDataItemAccessor.getDataByte(0, genericRange));
        }
        if (genericRange.hasString(2)) {
            range.setPlaceName(GenericDataItemAccessor.getDataString(2, genericRange));
        }
        if (genericRange.hasUnsignedByte(1)) {
            range.setFrom(new ParsedNumber(GenericDataItemAccessor.getDataUnsignedByte(1, genericRange)));
        } else if (genericRange.hasUnsignedShort(1)) {
            range.setFrom(new ParsedNumber(GenericDataItemAccessor.getDataUnsignedShort(1, genericRange)));
        } else if (genericRange.hasInteger(0)) {
            range.setFrom(new ParsedNumber(GenericDataItemAccessor.getDataInt(0, genericRange)));
        } else if (genericRange.hasLong(0)) {
            range.setFrom(new ParsedNumber(GenericDataItemAccessor.getDataLong(0, genericRange)));
        } else if (genericRange.hasString(1)) {
            range.setFrom(GenericDataItemAccessor.getDataString(1, genericRange));
        }
        if (genericRange.hasUnsignedByte(2)) {
            range.setTo(new ParsedNumber(GenericDataItemAccessor.getDataUnsignedByte(2, genericRange)));
        } else if (genericRange.hasUnsignedShort(2)) {
            range.setTo(new ParsedNumber(GenericDataItemAccessor.getDataUnsignedShort(2, genericRange)));
        } else if (genericRange.hasInteger(1)) {
            range.setTo(new ParsedNumber(GenericDataItemAccessor.getDataInt(1, genericRange)));
        } else if (genericRange.hasLong(1)) {
            range.setTo(new ParsedNumber(GenericDataItemAccessor.getDataLong(1, genericRange)));
        } else if (genericRange.hasString(0)) {
            range.setTo(GenericDataItemAccessor.getDataString(0, genericRange));
        }
        if (genericRange.hasBlob(0)) {
            range.setIntermediateRecordArray(new GenericIINtermediateRangeRecord().getRecord(GenericDataItemAccessor.getDataBlob(0, genericRange)));
        } else if (genericRange.hasBlob(1)) {
            byte[] blob = GenericDataItemAccessor.getDataBlob(1, genericRange);
            range.setIntermediateRecordArray(new TAIntermediateRangeRecord(blob).getIntermediateDataRecords());
        }
        if (genericRange.hasBlob(2)) {
            range.setAdditionalFields(BlobAdditionalFieldsFactory.createAdditionalFields(GenericDataItemAccessor.getDataBlob(2, genericRange)));
        }
    }

    protected void populateRangeUnitFromData(RangeUnit unit, GenericUnit genericUnit, MMJDataFileMetadata metadata, IDataDictionary dict, RangeUnit lastUnit) throws LocalizationException, IOException {
        if (genericUnit.hasString(0)) {
            unit.setLowUnit(GenericDataItemAccessor.getDataString(0, genericUnit));
        }
        if (genericUnit.hasString(1)) {
            unit.setHighUnit(GenericDataItemAccessor.getDataString(1, genericUnit));
        }
        if (genericUnit.hasString(2)) {
            unit.setUnitType(GenericDataItemAccessor.getDataString(2, genericUnit));
        }
        if (genericUnit.hasString(3)) {
            unit.setPlaceName(GenericDataItemAccessor.getDataString(3, genericUnit));
        }
        if (genericUnit.hasBlob(0)) {
            unit.setAdditionalFields(BlobAdditionalFieldsFactory.createAdditionalFields(GenericDataItemAccessor.getDataBlob(0, genericUnit)));
        }
    }
}

