/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericUnit;
import com.mapinfo.mapmarker.common.dp.binary.ICustomDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GenericRange
extends GenericDataItem
implements IDataFileDataItem {
    private List m_units;

    public GenericRange() {
        this(null);
    }

    public GenericRange(ICustomDataHandler handler) {
        super(handler);
    }

    public GenericUnit getRangeUnit(int index) {
        if (this.m_units == null) {
            return null;
        }
        return (GenericUnit)this.m_units.get(index);
    }

    public List getRangeUnits() {
        return this.m_units;
    }

    public void addRangeUnit(GenericUnit unit) {
        if (this.m_units == null) {
            this.m_units = new ArrayList();
        }
        this.m_units.add(unit);
    }

    public void addRangeUnit(int index, GenericUnit unit) {
        if (this.m_units == null) {
            this.m_units = new ArrayList();
        }
        this.m_units.add(index, unit);
    }

    protected GenericUnit removeRangeUnit(int index) {
        if (this.m_units == null) {
            return null;
        }
        return (GenericUnit)this.m_units.remove(index);
    }

    public int getRangeUnitCount() {
        if (this.m_units == null) {
            return 0;
        }
        return this.m_units.size();
    }

    @Override
    public void write(DataOutput out, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        int rangeUnitCount = this.getRangeUnitCount();
        if (rangeUnitCount > 0) {
            if (rangeUnitCount <= 255) {
                try {
                    this.putUnsignedByte(0, (short)rangeUnitCount);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            } else if (rangeUnitCount <= 65535) {
                try {
                    this.putUnsignedShort(0, rangeUnitCount);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            } else {
                throw new MMJEDataCorruptedException("Too many units on GenericRange.");
            }
        }
        DataFileMasks masks = metadata.getDataFileMasks();
        TypeMask rangeMask = this.getMask();
        short rangeMaskID = 0;
        if (masks != null) {
            rangeMaskID = masks.getTypeMaskIndex((byte)2, rangeMask);
        }
        out.writeByte(rangeMaskID);
        StreetDataFileStatistics stats = StreetDataFileStatistics.getStreetFileStatisticsObject();
        stats.logRangeMask(rangeMask, rangeMaskID);
        super.write(out, rangeMask, rangeMaskID == 0);
        for (int i = 0; i < rangeUnitCount; ++i) {
            GenericUnit obj = this.getRangeUnit(i);
            obj.write(out, metadata);
        }
    }

    @Override
    public void read(DataInput in, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        DataFileMasks masks = metadata.getDataFileMasks();
        short rangeMaskID = (short)in.readUnsignedByte();
        TypeMask rangeMask = null;
        if (masks != null && rangeMaskID != 0) {
            rangeMask = masks.getIndexedTypeMask((byte)2, rangeMaskID);
        }
        super.read(in, rangeMask);
        int rangeUnitCount = 0;
        if (this.hasUnsignedByte(0)) {
            try {
                rangeUnitCount = this.getUnsignedByte(0);
            }
            catch (MMJETypeArraySizeExceededException e) {
                throw new MMJEDataCorruptedException(e);
            }
        }
        if (this.hasUnsignedShort(0)) {
            try {
                rangeUnitCount = this.getUnsignedShort(0);
            }
            catch (MMJETypeArraySizeExceededException e) {
                throw new MMJEDataCorruptedException(e);
            }
        }
        for (int i = 0; i < rangeUnitCount; ++i) {
            GenericUnit obj = this.createUnit();
            obj.read(in, metadata);
            this.addRangeUnit(obj);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(super.toString());
        int count = this.getRangeUnitCount();
        for (int i = 0; i < count; ++i) {
            sb.append(" Unit");
            sb.append(i);
            sb.append(": ");
            sb.append(this.getRangeUnit(i).toString());
        }
        return sb.toString();
    }

    protected GenericUnit createUnit() {
        return new GenericUnit();
    }
}

