/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.CompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericRange;
import com.mapinfo.mapmarker.common.dp.binary.ICompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.ICustomDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.NoModCompressedSegment;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GenericSegment
extends GenericDataItem
implements IDataFileDataItem {
    private final List m_ranges = new ArrayList();
    private List m_points = null;
    private CompressedSegment m_compressed = null;
    private NoModCompressedSegment m_housePoints;

    public GenericSegment() {
        this(null);
    }

    public GenericSegment(ICustomDataHandler handler) {
        super(handler);
    }

    public GenericRange getRange(int index) {
        return (GenericRange)this.m_ranges.get(index);
    }

    public List getRanges() {
        return this.m_ranges;
    }

    public void addRange(GenericRange range) {
        this.m_ranges.add(range);
    }

    protected void addRange(int index, GenericRange range) {
        this.m_ranges.add(index, range);
    }

    protected GenericRange removeRange(int index) {
        return (GenericRange)this.m_ranges.remove(index);
    }

    public int getRangeCount() {
        if (this.m_ranges != null) {
            return this.m_ranges.size();
        }
        return 0;
    }

    public DirectPosition getPoint(int index) {
        if (this.m_points == null) {
            this.m_points = new ArrayList();
            this.buildPointsFromCompressed();
        }
        return (DirectPosition)this.m_points.get(index);
    }

    public List getPoints() {
        if (this.m_points == null) {
            this.m_points = new ArrayList();
            this.buildPointsFromCompressed();
        }
        return this.m_points;
    }

    public void addPoint(DirectPosition point) {
        if (this.m_points == null) {
            this.m_points = new ArrayList();
        }
        this.m_points.add(point);
    }

    protected void addPoint(int index, DirectPosition point) {
        if (this.m_points == null) {
            this.m_points = new ArrayList();
        }
        this.m_points.add(index, point);
    }

    protected DirectPosition removePoint(int index) {
        if (this.m_points == null) {
            this.m_points = new ArrayList();
            this.buildPointsFromCompressed();
        }
        return (DirectPosition)this.m_points.remove(index);
    }

    public int getPointCount() {
        if (this.m_points == null) {
            if (this.m_compressed != null) {
                return this.m_compressed.getNumberPoints();
            }
            return 0;
        }
        return this.m_points.size();
    }

    public void setHousePoints(NoModCompressedSegment housePoints) throws MMJEDataCorruptedException, IOException {
        byte[] blob = housePoints.toBytes();
        if (blob != null) {
            try {
                this.putBlob(0, blob);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                throw new MMJEDataCorruptedException(MMJETASEEx);
            }
        }
    }

    public ICompressedSegment getHousePoints(MMJDataFileMetadata metadata) throws MMJEDataCorruptedException, IOException {
        if (this.m_housePoints != null) {
            return this.m_housePoints;
        }
        if (this.hasBlob(0)) {
            byte[] blob;
            try {
                blob = this.getBlob(0);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                throw new MMJEDataCorruptedException(MMJETASEEx);
            }
            this.m_housePoints = new NoModCompressedSegment(blob);
            this.m_housePoints.setPow10(metadata.getXPow10(), metadata.getYPow10(), metadata.getXFactor(), metadata.getYFactor());
            return this.m_housePoints;
        }
        return null;
    }

    @Override
    public void write(DataOutput out, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        int rangeCount = this.getRangeCount();
        if (rangeCount > 0) {
            if (rangeCount <= 255) {
                try {
                    this.putUnsignedByte(0, (short)rangeCount);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            } else if (rangeCount <= 65535) {
                try {
                    this.putUnsignedShort(0, rangeCount);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            } else {
                throw new MMJEDataCorruptedException("Too many ranges on GenericSegment.");
            }
        }
        if (this.getPointCount() > 0) {
            short pointCount;
            if (this.m_compressed == null) {
                DirectPosition[] pnts = this.m_points.toArray(new DirectPosition[this.m_points.size()]);
                this.m_compressed = new CompressedSegment(pnts, metadata.getXPow10(), metadata.getYPow10(), metadata.getXFactor(), metadata.getYFactor());
                StreetDataFileStatistics.getStreetFileStatisticsObject().logSegmentPointInfo(pnts.length, this.m_compressed.getNumberPoints());
            }
            if ((pointCount = this.m_compressed.getNumberPoints()) <= 255) {
                try {
                    this.putUnsignedByte(1, pointCount);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            } else if (pointCount <= 65535) {
                try {
                    this.putUnsignedShort(1, pointCount);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            } else {
                throw new MMJEDataCorruptedException("Too many points for GenericSegment.");
            }
            long firstXOffset = this.m_compressed.getFirstXOffset();
            long firstYOffset = this.m_compressed.getFirstYOffset();
            if (firstXOffset >= -128L && firstXOffset <= 127L) {
                try {
                    this.putByte(0, (byte)firstXOffset);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            }
            if (firstXOffset >= -32768L && firstXOffset <= 32767L) {
                try {
                    this.putShort(0, (short)firstXOffset);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            }
            if (firstXOffset >= Integer.MIN_VALUE && firstXOffset <= Integer.MAX_VALUE) {
                try {
                    this.putInt(0, (int)firstXOffset);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            }
            try {
                this.putLong(1, firstXOffset);
            }
            catch (MMJETypeArraySizeExceededException e) {
                throw new MMJEDataCorruptedException(e);
            }
            if (firstYOffset >= -128L && firstYOffset <= 127L) {
                try {
                    this.putByte(1, (byte)firstYOffset);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            }
            if (firstYOffset >= -32768L && firstYOffset <= 32767L) {
                try {
                    this.putShort(1, (short)firstYOffset);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            }
            if (firstYOffset >= Integer.MIN_VALUE && firstYOffset <= Integer.MAX_VALUE) {
                try {
                    this.putInt(1, (int)firstYOffset);
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            }
            try {
                this.putLong(2, firstYOffset);
            }
            catch (MMJETypeArraySizeExceededException e) {
                throw new MMJEDataCorruptedException(e);
            }
        }
        DataFileMasks masks = metadata.getDataFileMasks();
        TypeMask segmentMask = this.getMask();
        short segmentMaskID = 0;
        if (masks != null) {
            segmentMaskID = masks.getTypeMaskIndex((byte)1, segmentMask);
        }
        out.writeByte(segmentMaskID);
        StreetDataFileStatistics.getStreetFileStatisticsObject().logSegmentMask(segmentMask, segmentMaskID);
        super.write(out, segmentMask, segmentMaskID == 0);
        for (int i = 0; i < rangeCount; ++i) {
            this.getRange(i).write(out, metadata);
        }
        if (this.m_compressed != null) {
            this.m_compressed.write(out, false);
        }
    }

    @Override
    public void read(DataInput in, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        long firstYOffset;
        long firstXOffset;
        int pointCount;
        block27: {
            DataFileMasks masks = metadata.getDataFileMasks();
            short segmentMaskID = (short)in.readUnsignedByte();
            TypeMask segmentMask = null;
            if (masks != null && segmentMaskID != 0) {
                segmentMask = masks.getIndexedTypeMask((byte)1, segmentMaskID);
            }
            super.read(in, segmentMask);
            int rangeCount = 0;
            try {
                if (this.hasUnsignedByte(0)) {
                    rangeCount = this.getUnsignedByte(0);
                } else if (this.hasUnsignedShort(0)) {
                    rangeCount = this.getUnsignedShort(0);
                }
            }
            catch (MMJETypeArraySizeExceededException e) {
                throw new MMJEDataCorruptedException(e);
            }
            for (int i = 0; i < rangeCount; ++i) {
                GenericRange obj = this.createRange();
                obj.read(in, metadata);
                this.addRange(obj);
            }
            pointCount = 0;
            try {
                if (this.hasUnsignedByte(1)) {
                    pointCount = this.getUnsignedByte(1);
                } else if (this.hasUnsignedShort(1)) {
                    pointCount = this.getUnsignedShort(1);
                }
            }
            catch (MMJETypeArraySizeExceededException e) {
                throw new MMJEDataCorruptedException(e);
            }
            firstXOffset = 0L;
            firstYOffset = 0L;
            if (pointCount > 0) {
                try {
                    if (this.hasByte(0)) {
                        firstXOffset = this.getByte(0);
                    } else if (this.hasShort(0)) {
                        firstXOffset = this.getShort(0);
                    } else if (this.hasInteger(0)) {
                        firstXOffset = this.getInt(0);
                    } else if (this.hasLong(1)) {
                        firstXOffset = this.getLong(1);
                    } else {
                        throw new MMJEDataCorruptedException("No first X coord for GenericSegment.");
                    }
                    if (this.hasByte(1)) {
                        firstYOffset = this.getByte(1);
                        break block27;
                    }
                    if (this.hasShort(1)) {
                        firstYOffset = this.getShort(1);
                        break block27;
                    }
                    if (this.hasInteger(1)) {
                        firstYOffset = this.getInt(1);
                        break block27;
                    }
                    if (this.hasLong(2)) {
                        firstYOffset = this.getLong(2);
                        break block27;
                    }
                    throw new MMJEDataCorruptedException("No first Y coord for GenericSegment.");
                }
                catch (MMJETypeArraySizeExceededException e) {
                    throw new MMJEDataCorruptedException(e);
                }
            }
        }
        this.m_compressed = new CompressedSegment((short)pointCount, firstXOffset, firstYOffset, metadata.getXPow10(), metadata.getYPow10(), metadata.getXFactor(), metadata.getYFactor());
        this.m_compressed.read(in, false);
    }

    protected void buildPointsFromCompressed() {
        if (this.m_compressed == null) {
            return;
        }
        DirectPosition[] pnts = this.m_compressed.convert();
        for (int i = 0; i < pnts.length; ++i) {
            this.addPoint(pnts[i]);
        }
    }

    public void setCompressedSegment(CompressedSegment compressed) {
        this.m_compressed = compressed;
    }

    public CompressedSegment getCompressedSegment() {
        return this.m_compressed;
    }

    @Override
    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer(512);
        sb.append(super.toString());
        int count = this.getRangeCount();
        for (i = 0; i < count; ++i) {
            sb.append(" Range");
            sb.append(i);
            sb.append(": ");
            sb.append(this.getRange(i).toString());
        }
        count = this.getPointCount();
        for (i = 0; i < count; ++i) {
            sb.append(" Point");
            sb.append(i);
            sb.append(": ");
            sb.append(this.getPoint(i).toString());
        }
        return sb.toString();
    }

    protected GenericRange createRange() {
        return new GenericRange();
    }
}

