/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.ICustomDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GenericStreet
extends GenericDataItem
implements IDataFileDataItem {
    private final List segments = new ArrayList();
    private long m_segmentBlockOffset = -1L;
    private Segment m_lastSegment = null;

    public GenericStreet() {
        this(null);
    }

    public GenericStreet(ICustomDataHandler handler) {
        super(handler);
    }

    public GenericSegment getSegment(int index) {
        return (GenericSegment)this.segments.get(index);
    }

    public List getSegments() {
        return this.segments;
    }

    public void addSegment(GenericSegment segment) {
        this.segments.add(segment);
    }

    protected void addSegment(int index, GenericSegment segment) {
        this.segments.add(index, segment);
    }

    protected GenericSegment removeSegment(int index) {
        return (GenericSegment)this.segments.remove(index);
    }

    protected int getSegmentCount() {
        return this.segments.size();
    }

    public long getSegmentBlockOffset() {
        return this.m_segmentBlockOffset;
    }

    @Override
    public void write(DataOutput out, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        DataFileMasks masks = metadata.getDataFileMasks();
        TypeMask streetMask = this.getMask();
        short streetMaskID = 0;
        if (masks != null) {
            streetMaskID = masks.getTypeMaskIndex((byte)0, streetMask);
        }
        out.writeByte(streetMaskID);
        StreetDataFileStatistics stats = StreetDataFileStatistics.getStreetFileStatisticsObject();
        stats.logStreetMask(streetMask, streetMaskID);
        super.write(out, streetMask, streetMaskID == 0);
    }

    @Override
    public void read(DataInput in, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        DataFileMasks masks = metadata.getDataFileMasks();
        short streetMaskID = (short)in.readUnsignedByte();
        TypeMask streetMask = null;
        if (masks != null && streetMaskID != 0) {
            streetMask = masks.getIndexedTypeMask((byte)0, streetMaskID);
        }
        super.read(in, streetMask);
        this.m_segmentBlockOffset = in.readInt();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(super.toString());
        int count = this.getSegmentCount();
        for (int i = 0; i < count; ++i) {
            sb.append(" Segment");
            sb.append(i);
            sb.append(": ");
            sb.append(this.getSegment(i).toString());
        }
        return sb.toString();
    }

    protected GenericSegment createSegment() {
        return new GenericSegment();
    }

    public void setLastSegment(Segment lastSegment) {
        this.m_lastSegment = lastSegment;
    }

    public Segment getLastSegment() {
        return this.m_lastSegment;
    }
}

