/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.DataFileMasks;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.ICustomDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GenericUnit
extends GenericDataItem
implements IDataFileDataItem {
    public GenericUnit() {
        this(null);
    }

    public GenericUnit(ICustomDataHandler handler) {
        super(handler);
    }

    @Override
    public void read(DataInput in, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        DataFileMasks masks = metadata.getDataFileMasks();
        short rangeUnitMaskID = (short)in.readUnsignedByte();
        TypeMask rangeUnitMask = null;
        if (masks != null && rangeUnitMaskID != 0) {
            rangeUnitMask = masks.getIndexedTypeMask((byte)3, rangeUnitMaskID);
        }
        super.read(in, rangeUnitMask);
    }

    @Override
    public void write(DataOutput out, MMJDataFileMetadata metadata) throws IOException, MMJEDataCorruptedException {
        DataFileMasks masks = metadata.getDataFileMasks();
        TypeMask rangeUnitMask = this.getMask();
        short rangeUnitMaskID = 0;
        if (masks != null) {
            rangeUnitMaskID = masks.getTypeMaskIndex((byte)3, rangeUnitMask);
        }
        out.writeByte(rangeUnitMaskID);
        StreetDataFileStatistics stats = StreetDataFileStatistics.getStreetFileStatisticsObject();
        stats.logRangeUnitMask(rangeUnitMask, rangeUnitMaskID);
        super.write(out, rangeUnitMask, rangeUnitMaskID == 0);
    }
}

