/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.MMJSac2FnRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacFileData;
import com.mapinfo.mapmarker.utils.IntObjMap;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.TreeSet;

public class MMJSac2FnData {
    public static final String SAC2FN_FILE_NAME = "sac2fn.mmj";
    public static final String SAC2FN_UD_FILE_NAME = "sac2fn_ud.mmj";
    private final IntObjMap m_map = new IntObjMap();
    private boolean m_forUserDictionary;

    public MMJSac2FnData(String dataPath) throws IOException {
        File sac2fnFile = new File(StringUtilities.appendToPath(dataPath, SAC2FN_FILE_NAME));
        if (!sac2fnFile.exists()) {
            sac2fnFile = new File(StringUtilities.appendToPath(dataPath, SAC2FN_UD_FILE_NAME));
            this.m_forUserDictionary = true;
        }
        this.load(sac2fnFile);
    }

    protected MMJSac2FnData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(File sac2fnFile) throws IOException {
        FilterInputStream in = null;
        try {
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(sac2fnFile)));
                while (true) {
                    MMJSac2FnRecord record = MMJSac2FnRecord.read((DataInput)((Object)in));
                    this.m_map.put(record.getSac(), record.getData());
                }
            }
            catch (EOFException eOFException) {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                in.close();
            }
            throw throwable;
        }
    }

    protected IntObjMap getMap() {
        return this.m_map;
    }

    protected void setForUserDictionary(boolean flag) {
        this.m_forUserDictionary = flag;
    }

    public SacFileData getFnForSac(int sac) {
        return (SacFileData)this.m_map.get(sac);
    }

    public String[] getStreetDataFileNames() {
        TreeSet<String> namesSet = new TreeSet<String>();
        Object[] datas = this.m_map.values();
        for (int i = 0; i < datas.length; ++i) {
            if (datas[i] == null) continue;
            namesSet.add(((SacFileData)datas[i]).getStreetFileName());
        }
        int setSize = namesSet.size();
        return namesSet.toArray(new String[setSize]);
    }

    protected boolean forUserDictionary() {
        return this.m_forUserDictionary;
    }
}

