/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalPostalCandidate;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataItemFetcher;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccess;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.PreLoadedData;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.PostInfoIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PostInfoFetcherImpl
extends AbstractDataItemFetcher
implements IPostInfoFetcher {
    protected static final String NO_POSTINFO_DATA_FILE = "exception.no.data.postinfo";
    protected static final String POSTINFO_DATA_FILE_OPEN = "exception.open.data.postinfo";
    protected static final String POSTINFO_DATA_FILE_ACCESS = "exception.access.data.postinfo";
    protected static final String NO_POSTINFO_INDEX_FILE = "exception.no.index.postinfo";
    protected static final String POSTINFO_INDEX_FILE_OPEN = "exception.open.index.postinfo";
    protected static final String POSTINFO_INDEX_FILE_ACCESS = "exception.access.index.postinfo";
    private String m_dataPath;
    private IDataAccess m_dataAccess;
    private IMapMarkerIndex m_index;
    public static final String POSTINFO_DATA_FILE_BASE_NAME = "postinfo";

    public PostInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(localSettings, localMessages);
        this.m_dataPath = dataPath;
        this.init();
    }

    protected void init() throws DataDictionaryIntializationException {
        try {
            this.m_dataAccess = this.getDataAccessType();
            this.m_dataAccess.init(StringUtilities.appendToPath(this.m_dataPath, this.getPostInfoDataFileName()));
        }
        catch (FileNotFoundException e) {
            throw new DataDictionaryIntializationException(NO_POSTINFO_DATA_FILE, e);
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException(POSTINFO_DATA_FILE_OPEN, e);
        }
        catch (DataAccessException DAEx) {
            throw new DataDictionaryIntializationException(DAEx);
        }
        this.m_index = this.getPostInfoIndexType();
        try {
            ((IMapMarkerReadOnlyIndexFile)this.m_index).open(StringUtilities.appendToPath(this.m_dataPath, this.getPostInfoIndexFileName()));
        }
        catch (FileNotFoundException e) {
            throw new DataDictionaryIntializationException(NO_POSTINFO_INDEX_FILE, e);
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException(POSTINFO_INDEX_FILE_OPEN, e);
        }
    }

    @Override
    public void close() throws DataAccessException {
        if (this.m_index != null) {
            try {
                ((IMapMarkerReadOnlyIndexFile)this.m_index).close();
                this.m_index = null;
            }
            catch (IOException IOEx) {
                throw new DataAccessException(2102, (Throwable)IOEx);
            }
        }
    }

    protected String getDataPath() {
        return this.m_dataPath;
    }

    protected String getPostInfoDataFileName() {
        return "postinfo.jdr";
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        return new PostInfoPreLoadedDataHelper();
    }

    protected IDataAccess getDataAccessType() {
        return new PreLoadedData(this.getDataAccessHelperType());
    }

    protected IMapMarkerIndex getPostInfoIndexType() {
        return new StandardPostInfoIndex();
    }

    protected String getPostInfoIndexFileName() {
        return "postinfo.jdx";
    }

    protected void setPostInfoData(IDataAccess postInfoDataAccess) {
        this.m_dataAccess = postInfoDataAccess;
    }

    protected IDataAccess getPostInfoDataAccess() {
        return this.m_dataAccess;
    }

    protected void setPostInfoIndex(IMapMarkerIndex index) {
        this.m_index = index;
    }

    protected IMapMarkerIndex getPostInfoIndex() {
        return this.m_index;
    }

    @Override
    public List getPostInfoCandidates(Address addr, IConstraints constraints) throws IOException, LocalizationException, MMJEDataCorruptedException {
        if (this.m_index == null) {
            return null;
        }
        ArrayList<ICandidate> candidates = null;
        MapMarkerIndexKey[] keys = this.makePostInfoKeys(addr, constraints);
        if (keys != null) {
            int keyCount = keys.length;
            for (int i = 0; i < keyCount; ++i) {
                PostInfoIndexValue value = (PostInfoIndexValue)this.m_index.search(keys[i]);
                if (value == null) continue;
                GenericDataItem item = null;
                try {
                    item = (GenericDataItem)this.m_dataAccess.getRecord(value.getPostalOffset());
                }
                catch (DataAccessException dataAccessException) {
                    // empty catch block
                }
                ICandidate candidate = this.makePostalCandidate(item);
                if (candidate == null) continue;
                if (candidates == null) {
                    candidates = new ArrayList<ICandidate>();
                }
                candidates.add(candidate);
            }
        }
        return candidates;
    }

    protected ICandidate getPostInfoCandidateType() {
        return new InternalPostalCandidate();
    }

    protected MapMarkerIndexKey[] makePostInfoKeys(Address addr, IConstraints constraints) {
        MapMarkerIndexKey[] keys = null;
        if (addr.getPostCode1() != null) {
            keys = new MapMarkerIndexKey[]{new StandardPostInfoIndexKey(new StandardPostalBase(addr.getPostCode1()))};
        }
        return keys;
    }

    protected MMJDataFileMetadata getMetaData() {
        return this.m_dataAccess.getMetadata();
    }

    protected ICandidate makePostalCandidate(GenericDataItem genericItem) throws LocalizationException {
        InternalPostalCandidate candidate = (InternalPostalCandidate)this.getPostInfoCandidateType();
        candidate.setVendorCode(String.valueOf(this.m_dataAccess.getMetadata().getVendorCode()));
        try {
            if (genericItem.hasString(0)) {
                candidate.setPostCode1(genericItem.getString(0));
            }
            if (genericItem.hasString(1)) {
                candidate.setPostCode2(genericItem.getString(1));
            }
            if (genericItem.hasString(2)) {
                candidate.setAreaName1(genericItem.getString(2));
            }
            if (genericItem.hasString(3)) {
                candidate.setAreaName2(genericItem.getString(3));
            }
            if (genericItem.hasString(4)) {
                candidate.setAreaName3(genericItem.getString(4));
            }
            if (genericItem.hasString(5)) {
                candidate.setAreaName4(genericItem.getString(5));
            }
            if (genericItem.hasLong(0)) {
                long longX = genericItem.getLong(0);
                if (genericItem.hasLong(1)) {
                    long longY = genericItem.getLong(1);
                    double x = (double)longX / (double)this.m_dataAccess.getMetadata().getXFactor();
                    double y = (double)longY / (double)this.m_dataAccess.getMetadata().getYFactor();
                    DirectPosition pnt = new DirectPosition(x, y);
                    candidate.setPoint(pnt);
                    if (genericItem.hasByte(0)) {
                        candidate.setMatchLevel(genericItem.getByte(0));
                    }
                }
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            throw new LocalizationException(e);
        }
        candidate.setCountry(this.m_dataAccess.getMetadata().getCountry());
        return candidate;
    }

    private class PostInfoPreLoadedDataHelper
    implements IDataAccessHelper {
        private PostInfoPreLoadedDataHelper() {
        }

        @Override
        public IDataFileDataItem getDataItemType() {
            return new PostInfoDataItem();
        }

        @Override
        public MMJDataFileMetadata getMetadataType() {
            return new MMJComplexDataFileMetadata();
        }

        @Override
        public Object makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) throws LocalizationException {
            return item;
        }
    }
}

