/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.utils.IntArray;
import com.mapinfo.mapmarker.utils.LongArray;
import java.util.Set;

public class SacData {
    private final IntArray m_sacList;
    private final LongArray m_locList;

    public SacData() {
        this.m_sacList = new IntArray();
        this.m_locList = new LongArray();
    }

    public SacData(Set<Integer> initialSacs) {
        this.m_sacList = new IntArray(initialSacs.size());
        this.m_locList = new LongArray();
        for (Integer sac : initialSacs) {
            this.m_sacList.add(sac);
        }
    }

    protected void addSac(int sac) {
        if (!this.m_sacList.contains(sac)) {
            this.m_sacList.add(sac);
        }
    }

    void addIndex(long loc) {
        if (!this.m_locList.contains(loc)) {
            this.m_locList.add(loc);
        }
    }

    int[] getSacs() {
        return this.m_sacList.asArray();
    }

    long[] getIndexes() {
        return this.m_locList.asArray();
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer(256);
        sb.append("sacs=");
        int sz = this.m_sacList.length();
        sb.append(sz);
        for (i = 0; i < sz; ++i) {
            sb.append(",");
            sb.append(this.m_sacList.get(i));
        }
        sb.append("  locs=");
        sz = this.m_locList.length();
        sb.append(sz);
        for (i = 0; i < sz; ++i) {
            sb.append(",");
            sb.append(this.m_locList.get(i));
        }
        return sb.toString();
    }
}

