/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.common.dp.binary.TypeMask;
import com.mapinfo.mapmarker.common.dp.binary.TypeMaskStats;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StreetDataFileStatistics {
    private TypeMaskStats[] m_streetMasks = new TypeMaskStats[255];
    private TypeMaskStats[] m_segmentMasks = new TypeMaskStats[255];
    private TypeMaskStats[] m_rangeMasks = new TypeMaskStats[255];
    private TypeMaskStats[] m_rangeUnitMasks = new TypeMaskStats[255];
    private long m_customStreetCount = 0L;
    private long m_customSegmentCount = 0L;
    private long m_customRangeCount = 0L;
    private long m_customRangeUnitCount = 0L;
    private boolean m_logCustomMasks;
    private long m_segmentsCombined;
    private List m_customStreets;
    private List m_customSegments;
    private List m_customRanges;
    private List m_customRangeUnits;
    private long m_sacCount;
    private long m_sacSoundexCount;
    private long m_totalSegmentPoints = 0L;
    private long m_totalAddedPoints = 0L;
    private long m_segmentsWithAddedPoints = 0L;
    private long m_segmentsWithPoints = 0L;
    private static StreetDataFileStatistics m_statObj = null;

    private StreetDataFileStatistics(boolean logCustomMasks) {
        this.m_logCustomMasks = logCustomMasks;
        this.m_segmentsCombined = 0L;
        if (this.m_logCustomMasks) {
            this.m_customStreets = new LinkedList();
            this.m_customSegments = new LinkedList();
            this.m_customRanges = new LinkedList();
            this.m_customRangeUnits = new LinkedList();
        } else {
            this.m_customStreets = null;
            this.m_customSegments = null;
            this.m_customRanges = null;
            this.m_customRangeUnits = null;
        }
        this.m_sacCount = 0L;
        this.m_sacSoundexCount = 0L;
    }

    public static void createStreetFileStatistics(boolean logCustomMasks) {
        m_statObj = new StreetDataFileStatistics(logCustomMasks);
    }

    public static StreetDataFileStatistics getStreetFileStatisticsObject() {
        return m_statObj;
    }

    public void logStreetMask(TypeMask streetMask, short streetMaskID) {
        if (streetMaskID == 0) {
            ++this.m_customStreetCount;
            this.logCustomStreet(streetMask);
            return;
        }
        if (this.m_streetMasks[streetMaskID - 1] != null) {
            this.m_streetMasks[streetMaskID - 1].incrementMask();
        } else {
            this.m_streetMasks[streetMaskID - 1] = new TypeMaskStats();
            this.m_streetMasks[streetMaskID - 1].setTypeMask(streetMask);
            this.m_streetMasks[streetMaskID - 1].incrementMask();
        }
    }

    public void logSegmentMask(TypeMask segmentMask, short segmentMaskID) {
        if (segmentMaskID == 0) {
            ++this.m_customSegmentCount;
            this.logCustomSegment(segmentMask);
            return;
        }
        if (this.m_segmentMasks[segmentMaskID - 1] != null) {
            this.m_segmentMasks[segmentMaskID - 1].incrementMask();
        } else {
            this.m_segmentMasks[segmentMaskID - 1] = new TypeMaskStats();
            this.m_segmentMasks[segmentMaskID - 1].setTypeMask(segmentMask);
            this.m_segmentMasks[segmentMaskID - 1].incrementMask();
        }
    }

    public void logRangeMask(TypeMask rangeMask, short rangeMaskID) {
        if (rangeMaskID == 0) {
            ++this.m_customRangeCount;
            this.logCustomRange(rangeMask);
            return;
        }
        if (this.m_rangeMasks[rangeMaskID - 1] != null) {
            this.m_rangeMasks[rangeMaskID - 1].incrementMask();
        } else {
            this.m_rangeMasks[rangeMaskID - 1] = new TypeMaskStats();
            this.m_rangeMasks[rangeMaskID - 1].setTypeMask(rangeMask);
            this.m_rangeMasks[rangeMaskID - 1].incrementMask();
        }
    }

    public void logRangeUnitMask(TypeMask rangeUnitMask, short rangeUnitMaskID) {
        if (rangeUnitMaskID == 0) {
            ++this.m_customRangeUnitCount;
            this.logCustomRangeUnit(rangeUnitMask);
            return;
        }
        if (this.m_rangeUnitMasks[rangeUnitMaskID - 1] != null) {
            this.m_rangeUnitMasks[rangeUnitMaskID - 1].incrementMask();
        } else {
            this.m_rangeUnitMasks[rangeUnitMaskID - 1] = new TypeMaskStats();
            this.m_rangeUnitMasks[rangeUnitMaskID - 1].setTypeMask(rangeUnitMask);
            this.m_rangeUnitMasks[rangeUnitMaskID - 1].incrementMask();
        }
    }

    public void logCustomStreet(TypeMask streetMask) {
        if (this.m_customStreets != null) {
            Iterator customStreetIterator = this.m_customStreets.iterator();
            if (customStreetIterator.hasNext()) {
                while (customStreetIterator.hasNext()) {
                    TypeMaskStats stats = (TypeMaskStats)customStreetIterator.next();
                    if (!stats.getTypeMask().equals(streetMask)) continue;
                    stats.incrementMask();
                    return;
                }
            }
            TypeMaskStats stat = new TypeMaskStats();
            stat.setTypeMask(streetMask);
            stat.incrementMask();
            this.m_customStreets.add(stat);
        }
    }

    public void logCustomSegment(TypeMask segmentMask) {
        if (this.m_customSegments != null) {
            Iterator customSegmentIterator = this.m_customSegments.iterator();
            if (customSegmentIterator.hasNext()) {
                while (customSegmentIterator.hasNext()) {
                    TypeMaskStats stats = (TypeMaskStats)customSegmentIterator.next();
                    if (!stats.getTypeMask().equals(segmentMask)) continue;
                    stats.incrementMask();
                    return;
                }
            }
            TypeMaskStats stat = new TypeMaskStats();
            stat.setTypeMask(segmentMask);
            stat.incrementMask();
            this.m_customSegments.add(stat);
        }
    }

    public void logCustomRange(TypeMask rangeMask) {
        if (this.m_customRanges != null) {
            Iterator customRangeIterator = this.m_customRanges.iterator();
            if (customRangeIterator.hasNext()) {
                while (customRangeIterator.hasNext()) {
                    TypeMaskStats stats = (TypeMaskStats)customRangeIterator.next();
                    if (!stats.getTypeMask().equals(rangeMask)) continue;
                    stats.incrementMask();
                    return;
                }
            }
            TypeMaskStats stat = new TypeMaskStats();
            stat.setTypeMask(rangeMask);
            stat.incrementMask();
            this.m_customRanges.add(stat);
        }
    }

    public void logCustomRangeUnit(TypeMask rangeUnitMask) {
        if (this.m_customRangeUnits != null) {
            Iterator customRangeUnitIterator = this.m_customRangeUnits.iterator();
            if (customRangeUnitIterator.hasNext()) {
                while (customRangeUnitIterator.hasNext()) {
                    TypeMaskStats stats = (TypeMaskStats)customRangeUnitIterator.next();
                    if (!stats.getTypeMask().equals(rangeUnitMask)) continue;
                    stats.incrementMask();
                    return;
                }
            }
            TypeMaskStats stat = new TypeMaskStats();
            stat.setTypeMask(rangeUnitMask);
            stat.incrementMask();
            this.m_customRangeUnits.add(stat);
        }
    }

    public void logSegmentPointInfo(long sourcePointCount, long finalPointCount) {
        if (sourcePointCount != finalPointCount) {
            ++this.m_segmentsWithAddedPoints;
            this.m_totalAddedPoints += finalPointCount - sourcePointCount;
        }
        if (finalPointCount > 0L) {
            ++this.m_segmentsWithPoints;
        }
        this.m_totalSegmentPoints += finalPointCount;
    }

    public void incrementSacCount() {
        ++this.m_sacCount;
    }

    private long getSacCount() {
        return this.m_sacCount;
    }

    public void incrementSacSoundexCount() {
        ++this.m_sacSoundexCount;
    }

    private long getSacSoundexCount() {
        return this.m_sacSoundexCount;
    }

    public void incrementCombinedSegments() {
        ++this.m_segmentsCombined;
    }

    public long getSegmentsCombined() {
        return this.m_segmentsCombined;
    }

    private String getCustomStatistics(List customList) {
        if (customList == null || customList.isEmpty()) {
            return null;
        }
        Collections.sort(customList);
        StringBuffer statsBuffer = new StringBuffer();
        for (TypeMaskStats stat : customList) {
            String statString = stat.toString();
            statsBuffer.append(statString);
        }
        return statsBuffer.toString();
    }

    public String getStatistics() {
        int i;
        StringBuffer stats = new StringBuffer();
        long totalStreets = 0L;
        long totalSegments = 0L;
        long totalRanges = 0L;
        long totalRangeUnits = 0L;
        stats.append("\nStreets: \n");
        for (i = 0; i < this.m_streetMasks.length; ++i) {
            if (this.m_streetMasks[i] == null) continue;
            totalStreets += this.m_streetMasks[i].getMaskCount();
            stats.append("Index: " + (i + 1) + " Count: " + this.m_streetMasks[i].getMaskCount() + " " + this.m_streetMasks[i].getTypeMask().toString() + "\n");
        }
        stats.append("\nCustom Streets: " + this.m_customStreetCount + "\n");
        if (this.m_logCustomMasks) {
            String customStat = this.getCustomStatistics(this.m_customStreets);
            stats.append(customStat != null ? customStat : "");
        }
        stats.append("Total Streets: " + (totalStreets += this.m_customStreetCount) + "\n");
        stats.append("\nSegments: \n");
        for (i = 0; i < this.m_segmentMasks.length; ++i) {
            if (this.m_segmentMasks[i] == null) continue;
            totalSegments += this.m_segmentMasks[i].getMaskCount();
            stats.append("Index: " + (i + 1) + " Count: " + this.m_segmentMasks[i].getMaskCount() + " " + this.m_segmentMasks[i].getTypeMask().toString() + "\n");
        }
        stats.append("\nCustom Segments: " + this.m_customSegmentCount + "\n");
        if (this.m_logCustomMasks) {
            String customStat = this.getCustomStatistics(this.m_customSegments);
            stats.append(customStat != null ? customStat : "");
        }
        stats.append("Total Segments: " + (totalSegments += this.m_customSegmentCount) + "\n");
        stats.append("\nRanges: \n");
        for (int i2 = 0; i2 < this.m_rangeMasks.length; ++i2) {
            if (this.m_rangeMasks[i2] == null) continue;
            totalRanges += this.m_rangeMasks[i2].getMaskCount();
            stats.append("Index: " + (i2 + 1) + " Count: " + this.m_rangeMasks[i2].getMaskCount() + " " + this.m_rangeMasks[i2].getTypeMask().toString() + "\n");
        }
        stats.append("\nCustom Ranges: " + this.m_customRangeCount + "\n");
        if (this.m_logCustomMasks) {
            String customStat = this.getCustomStatistics(this.m_customRanges);
            stats.append(customStat != null ? customStat : "");
        }
        stats.append("Total Ranges: " + (totalRanges += this.m_customRangeCount) + "\n");
        stats.append("\nRangeUnits: \n");
        for (int i3 = 0; i3 < this.m_rangeUnitMasks.length; ++i3) {
            if (this.m_rangeUnitMasks[i3] == null) continue;
            totalRangeUnits += this.m_rangeUnitMasks[i3].getMaskCount();
            stats.append("Index: " + (i3 + 1) + " Count: " + this.m_rangeUnitMasks[i3].getMaskCount() + " " + this.m_rangeUnitMasks[i3].getTypeMask().toString() + "\n");
        }
        stats.append("\nCustom RangeUnits: " + this.m_customRangeUnitCount + "\n");
        if (this.m_logCustomMasks) {
            String customStat = this.getCustomStatistics(this.m_customRangeUnits);
            stats.append(customStat != null ? customStat : "");
        }
        stats.append("Total RangeUnits: " + (totalRangeUnits += this.m_customRangeUnitCount) + "\n");
        stats.append("\n\nTotal number of sacs: " + this.getSacCount() + "\n");
        stats.append("Total number of sac/soundex blocks: " + this.getSacSoundexCount() + "\n");
        stats.append("\n\n\nTotals: \n");
        stats.append("Segments / Street: " + (double)totalSegments / (double)totalStreets + "\n");
        stats.append("Ranges / Segment: " + (double)totalRanges / (double)totalSegments + "\n");
        stats.append("\nTotal number of points: " + this.m_totalSegmentPoints + "\n");
        stats.append("\nTotal number of segments with points: " + this.m_segmentsWithPoints + "\n");
        stats.append("\nTotal number of segments with added points: " + this.m_segmentsWithAddedPoints + "\n");
        stats.append("Average number of points added: " + (this.m_segmentsWithAddedPoints != 0L ? this.m_totalAddedPoints / this.m_segmentsWithAddedPoints : 0L) + "\n");
        stats.append("\nTotal number of segments combined: " + this.m_segmentsCombined + "\n");
        return stats.toString();
    }
}

