/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary;

import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.utils.DataInputUtilities;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TypeMask {
    private short m_typesHash = 0;
    private long m_boolHash = 0L;
    private long m_byteHash = 0L;
    private long m_charHash = 0L;
    private long m_doubleHash = 0L;
    private long m_floatHash = 0L;
    private long m_intHash = 0L;
    private long m_longHash = 0L;
    private long m_shortHash = 0L;
    private long m_stringHash = 0L;
    private long m_blobHash = 0L;
    private long m_unsignedByteHash = 0L;
    private long m_unsignedShortHash = 0L;
    private long[] m_customDatumHash = null;
    private byte[] m_booleans = null;
    private byte[] m_bytes = null;
    private byte[] m_chars = null;
    private byte[] m_doubles = null;
    private byte[] m_floats = null;
    private byte[] m_ints = null;
    private byte[] m_longs;
    private byte[] m_shorts = null;
    private byte[] m_strings = null;
    private byte[] m_blobs = null;
    private byte[] m_unsignedBytes = null;
    private byte[] m_unsignedShorts = null;
    private byte[][] m_customDatums = null;
    private int m_primitivesSize = 0;
    private boolean m_createdTypeArrays = false;
    private static final short BOOLEAN = 1;
    private static final short BYTE = 2;
    private static final short CHAR = 4;
    private static final short DOUBLE = 8;
    private static final short FLOAT = 16;
    private static final short INT = 32;
    private static final short LONG = 64;
    private static final short SHORT = 128;
    private static final short STRING = 256;
    private static final short BLOB = 512;
    private static final short UNSIGNED_BYTE = 1024;
    private static final short UNSIGNED_SHORT = 2048;
    private static final short[] CUSTOM_DATUMS = new short[]{4096, 8192, 16384};
    public static final short MAX_HASH_KEYS = 63;
    public static final byte MAX_CUSTOM_INDEX = 2;
    private static final boolean m_bUseLock = EngineThreadingModel.isThreadsafe();
    private final Object m_lock = new Object();

    private void addHash(short hash) {
        this.m_typesHash = (short)(this.m_typesHash | hash);
    }

    private void removeHash(short hash) {
        this.m_typesHash = (short)(this.m_typesHash & ~hash);
    }

    private boolean hasHash(short hash) {
        return (this.m_typesHash & hash) != 0;
    }

    private short getTypesHash() {
        return this.m_typesHash;
    }

    public void setBoolHash(long boolHash) {
        this.m_boolHash = boolHash;
        if (this.m_boolHash != 0L) {
            this.addHash((short)1);
        } else {
            this.removeHash((short)1);
        }
    }

    public long getBoolHash() {
        return this.m_boolHash;
    }

    byte[] getBoolHashArray() {
        this.createTypeArrays();
        return this.m_booleans;
    }

    public void setByteHash(long byteHash) {
        this.m_byteHash = byteHash;
        if (this.m_byteHash != 0L) {
            this.addHash((short)2);
        } else {
            this.removeHash((short)2);
        }
    }

    public long getByteHash() {
        return this.m_byteHash;
    }

    byte[] getByteHashArray() {
        this.createTypeArrays();
        return this.m_bytes;
    }

    public void setCharHash(long charHash) {
        this.m_charHash = charHash;
        if (this.m_charHash != 0L) {
            this.addHash((short)4);
        } else {
            this.removeHash((short)4);
        }
    }

    public long getCharHash() {
        return this.m_charHash;
    }

    byte[] getCharHashArray() {
        this.createTypeArrays();
        return this.m_chars;
    }

    public void setDoubleHash(long doubleHash) {
        this.m_doubleHash = doubleHash;
        if (this.m_doubleHash != 0L) {
            this.addHash((short)8);
        } else {
            this.removeHash((short)8);
        }
    }

    public long getDoubleHash() {
        return this.m_doubleHash;
    }

    byte[] getDoubleHashArray() {
        this.createTypeArrays();
        return this.m_doubles;
    }

    public void setFloatHash(long floatHash) {
        this.m_floatHash = floatHash;
        if (this.m_floatHash != 0L) {
            this.addHash((short)16);
        } else {
            this.removeHash((short)16);
        }
    }

    public long getFloatHash() {
        return this.m_floatHash;
    }

    byte[] getFloatHashArray() {
        this.createTypeArrays();
        return this.m_floats;
    }

    public void setIntHash(long intHash) {
        this.m_intHash = intHash;
        if (this.m_intHash != 0L) {
            this.addHash((short)32);
        } else {
            this.removeHash((short)32);
        }
    }

    public long getIntHash() {
        return this.m_intHash;
    }

    byte[] getIntHashArray() {
        this.createTypeArrays();
        return this.m_ints;
    }

    public void setLongHash(long longHash) {
        this.m_longHash = longHash;
        if (this.m_longHash != 0L) {
            this.addHash((short)64);
        } else {
            this.removeHash((short)64);
        }
    }

    public long getLongHash() {
        return this.m_longHash;
    }

    byte[] getLongHashArray() {
        this.createTypeArrays();
        return this.m_longs;
    }

    public void setShortHash(long shortHash) {
        this.m_shortHash = shortHash;
        if (this.m_shortHash != 0L) {
            this.addHash((short)128);
        } else {
            this.removeHash((short)128);
        }
    }

    public long getShortHash() {
        return this.m_shortHash;
    }

    byte[] getShortHashArray() {
        this.createTypeArrays();
        return this.m_shorts;
    }

    public void setStringHash(long stringHash) {
        this.m_stringHash = stringHash;
        if (this.m_stringHash != 0L) {
            this.addHash((short)256);
        } else {
            this.removeHash((short)256);
        }
    }

    public long getStringHash() {
        return this.m_stringHash;
    }

    byte[] getStringHashArray() {
        this.createTypeArrays();
        return this.m_strings;
    }

    public void setBlobHash(long blobHash) {
        this.m_blobHash = blobHash;
        if (this.m_blobHash != 0L) {
            this.addHash((short)512);
        } else {
            this.removeHash((short)512);
        }
    }

    public long getBlobHash() {
        return this.m_blobHash;
    }

    byte[] getBlobHashArray() {
        this.createTypeArrays();
        return this.m_blobs;
    }

    public void setUnsignedByteHash(long unsignedByteHash) {
        this.m_unsignedByteHash = unsignedByteHash;
        if (this.m_unsignedByteHash != 0L) {
            this.addHash((short)1024);
        } else {
            this.removeHash((short)1024);
        }
    }

    public long getUnsignedByteHash() {
        return this.m_unsignedByteHash;
    }

    public byte[] getUnsignedByteHashArray() {
        this.createTypeArrays();
        return this.m_unsignedBytes;
    }

    public void setUnsignedShortHash(long unsignedShortHash) {
        this.m_unsignedShortHash = unsignedShortHash;
        if (this.m_unsignedShortHash != 0L) {
            this.addHash((short)2048);
        } else {
            this.removeHash((short)2048);
        }
    }

    public long getUnsignedShortHash() {
        return this.m_unsignedShortHash;
    }

    public byte[] getUnsignedShortHashArray() {
        this.createTypeArrays();
        return this.m_unsignedShorts;
    }

    public void setCustomDatumHash(byte customDatumType, long customDatumHash) {
        if (customDatumHash != 0L) {
            this.addHash(CUSTOM_DATUMS[customDatumType]);
        } else {
            this.removeHash(CUSTOM_DATUMS[customDatumType]);
        }
        if (this.m_customDatumHash == null) {
            this.m_customDatumHash = new long[3];
        }
        this.m_customDatumHash[customDatumType] = customDatumHash;
    }

    public void setCustomDatumsHash(long[] customDatumsHash) {
        this.m_customDatumHash = customDatumsHash;
        if (this.m_customDatumHash == null) {
            for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
                this.removeHash(CUSTOM_DATUMS[i]);
            }
        } else {
            for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
                if (this.m_customDatumHash[i] == 0L) {
                    this.removeHash(CUSTOM_DATUMS[i]);
                    continue;
                }
                this.addHash(CUSTOM_DATUMS[i]);
            }
        }
    }

    public long[] getCustomDatumHashes() {
        return this.m_customDatumHash;
    }

    public byte[] getCustomDatumHashArray(byte customDatumType) {
        this.createTypeArrays();
        if (this.m_customDatums != null) {
            return this.m_customDatums[customDatumType];
        }
        return null;
    }

    int getPrimitivesSize() {
        this.createTypeArrays();
        return this.m_primitivesSize;
    }

    public void write(DataOutput out) throws IOException {
        this.createTypeArrays();
        out.writeShort(this.m_typesHash);
        if (this.hasHash((short)1)) {
            out.writeLong(this.m_boolHash);
        }
        if (this.hasHash((short)2)) {
            out.writeLong(this.m_byteHash);
        }
        if (this.hasHash((short)4)) {
            out.writeLong(this.m_charHash);
        }
        if (this.hasHash((short)8)) {
            out.writeLong(this.m_doubleHash);
        }
        if (this.hasHash((short)16)) {
            out.writeLong(this.m_floatHash);
        }
        if (this.hasHash((short)32)) {
            out.writeLong(this.m_intHash);
        }
        if (this.hasHash((short)64)) {
            out.writeLong(this.m_longHash);
        }
        if (this.hasHash((short)128)) {
            out.writeLong(this.m_shortHash);
        }
        if (this.hasHash((short)256)) {
            out.writeLong(this.m_stringHash);
        }
        if (this.hasHash((short)512)) {
            out.writeLong(this.m_blobHash);
        }
        if (this.hasHash((short)1024)) {
            out.writeLong(this.m_unsignedByteHash);
        }
        if (this.hasHash((short)2048)) {
            out.writeLong(this.m_unsignedShortHash);
        }
        if (this.m_customDatumHash != null) {
            for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
                if (!this.hasHash(CUSTOM_DATUMS[i])) continue;
                out.writeLong(this.m_customDatumHash[i]);
            }
        }
    }

    public void read(DataInput in) throws IOException {
        this.m_typesHash = in.readShort();
        boolean bHasBooleanHash = this.hasHash((short)1);
        boolean bHasByteHash = this.hasHash((short)2);
        boolean bHasCharHash = this.hasHash((short)4);
        boolean bHasDoubleHash = this.hasHash((short)8);
        boolean bHasFloatHash = this.hasHash((short)16);
        boolean bHasIntHash = this.hasHash((short)32);
        boolean bHasLongHash = this.hasHash((short)64);
        boolean bHasShortHash = this.hasHash((short)128);
        boolean bHasStringHash = this.hasHash((short)256);
        boolean bHasBlobHash = this.hasHash((short)512);
        boolean bHasUnsignedByteHash = this.hasHash((short)1024);
        boolean bHasUnsignedShortHash = this.hasHash((short)2048);
        boolean[] customHashes = null;
        int customCount = 0;
        for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
            if (!this.hasHash(CUSTOM_DATUMS[i])) continue;
            if (customHashes == null) {
                customHashes = new boolean[CUSTOM_DATUMS.length];
            }
            customHashes[i] = true;
            ++customCount;
        }
        int longsToRead = (bHasBooleanHash ? 1 : 0) + (bHasByteHash ? 1 : 0) + (bHasCharHash ? 1 : 0) + (bHasDoubleHash ? 1 : 0) + (bHasFloatHash ? 1 : 0) + (bHasIntHash ? 1 : 0) + (bHasLongHash ? 1 : 0) + (bHasShortHash ? 1 : 0) + (bHasStringHash ? 1 : 0) + (bHasBlobHash ? 1 : 0) + (bHasUnsignedByteHash ? 1 : 0) + (bHasUnsignedShortHash ? 1 : 0) + customCount;
        if (longsToRead > 0) {
            int lenToRead = longsToRead * 8;
            byte[] tmpBlock = DataInputUtilities.readByteArray(in, lenToRead);
            int byteIndex = 0;
            if (bHasBooleanHash) {
                this.m_boolHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasByteHash) {
                this.m_byteHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasCharHash) {
                this.m_charHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasDoubleHash) {
                this.m_doubleHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasFloatHash) {
                this.m_floatHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasIntHash) {
                this.m_intHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasLongHash) {
                this.m_longHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasShortHash) {
                this.m_shortHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasStringHash) {
                this.m_stringHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasBlobHash) {
                this.m_blobHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasUnsignedByteHash) {
                this.m_unsignedByteHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (bHasUnsignedShortHash) {
                this.m_unsignedShortHash = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                byteIndex += 8;
            }
            if (customCount > 0) {
                for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
                    if (!customHashes[i]) continue;
                    if (this.m_customDatumHash == null) {
                        this.m_customDatumHash = new long[CUSTOM_DATUMS.length];
                    }
                    this.m_customDatumHash[i] = DataInputUtilities.getLongFromByteArray(byteIndex, tmpBlock);
                    byteIndex += 8;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTypeArrays() {
        if (m_bUseLock) {
            Object object = this.m_lock;
            synchronized (object) {
                if (!this.m_createdTypeArrays) {
                    this.makeTypeArrays();
                    this.m_createdTypeArrays = true;
                }
            }
        } else if (!this.m_createdTypeArrays) {
            this.makeTypeArrays();
            this.m_createdTypeArrays = true;
        }
    }

    private void makeTypeArrays() {
        this.m_primitivesSize = 0;
        if (this.m_boolHash != 0L) {
            this.m_booleans = HashKeyFactory.get(this.m_boolHash);
            this.m_primitivesSize += this.m_booleans.length;
        }
        if (this.m_byteHash != 0L) {
            this.m_bytes = HashKeyFactory.get(this.m_byteHash);
            this.m_primitivesSize += this.m_bytes.length;
        }
        if (this.m_charHash != 0L) {
            this.m_chars = HashKeyFactory.get(this.m_charHash);
            this.m_primitivesSize += this.m_chars.length * 2;
        }
        if (this.m_doubleHash != 0L) {
            this.m_doubles = HashKeyFactory.get(this.m_doubleHash);
            this.m_primitivesSize += this.m_doubles.length * 8;
        }
        if (this.m_floatHash != 0L) {
            this.m_floats = HashKeyFactory.get(this.m_floatHash);
            this.m_primitivesSize += this.m_floats.length * 4;
        }
        if (this.m_intHash != 0L) {
            this.m_ints = HashKeyFactory.get(this.m_intHash);
            this.m_primitivesSize += this.m_ints.length * 4;
        }
        if (this.m_longHash != 0L) {
            this.m_longs = HashKeyFactory.get(this.m_longHash);
            this.m_primitivesSize += this.m_longs.length * 8;
        }
        if (this.m_shortHash != 0L) {
            this.m_shorts = HashKeyFactory.get(this.m_shortHash);
            this.m_primitivesSize += this.m_shorts.length * 2;
        }
        if (this.m_stringHash != 0L) {
            this.m_strings = HashKeyFactory.get(this.m_stringHash);
        }
        if (this.m_blobHash != 0L) {
            this.m_blobs = HashKeyFactory.get(this.m_blobHash);
        }
        if (this.m_unsignedByteHash != 0L) {
            this.m_unsignedBytes = HashKeyFactory.get(this.m_unsignedByteHash);
            this.m_primitivesSize += this.m_unsignedBytes.length;
        }
        if (this.m_unsignedShortHash != 0L) {
            this.m_unsignedShorts = HashKeyFactory.get(this.m_unsignedShortHash);
            this.m_primitivesSize += this.m_unsignedShorts.length * 2;
        }
        if (this.m_customDatumHash != null) {
            for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
                if (this.m_customDatumHash[i] == 0L) continue;
                if (this.m_customDatums == null) {
                    this.m_customDatums = new byte[3][];
                }
                this.m_customDatums[i] = HashKeyFactory.get(this.m_customDatumHash[i]);
            }
        }
    }

    private String maskToString(long typeMask) {
        StringBuffer maskBuffer = new StringBuffer();
        StringBuffer bitMask = new StringBuffer();
        boolean hadKey = false;
        for (int i = 0; i < 63; ++i) {
            long bitValue = 1L << i;
            if ((typeMask & bitValue) != 0L) {
                bitMask.insert(0, "1");
                if (hadKey) {
                    maskBuffer.append(", " + i);
                    continue;
                }
                maskBuffer.append(i);
                hadKey = true;
                continue;
            }
            bitMask.insert(0, "0");
        }
        return bitMask.toString() + ": " + maskBuffer.toString();
    }

    public static long convertBinaryStringToHash(String binaryString) {
        if (binaryString == null || binaryString.length() != 63) {
            System.err.println("ERROR: String passed to TypeMask.convertBinaryStringToHash must be 63 characters long.");
            return 0L;
        }
        StringBuffer temp = new StringBuffer(binaryString);
        long hash = 0L;
        for (long i = 0L; i < 63L; ++i) {
            char digit = temp.charAt((int)(63L - i - 1L));
            if (digit != '1') continue;
            hash += 1L << (int)i;
        }
        return hash;
    }

    public String toString() {
        StringBuffer maskBuffer = new StringBuffer();
        maskBuffer.append("Types:");
        if (this.hasHash((short)1)) {
            maskBuffer.append(" BOOLEANS: ");
            maskBuffer.append(this.maskToString(this.m_boolHash));
        }
        if (this.hasHash((short)2)) {
            maskBuffer.append(" BYTES: ");
            maskBuffer.append(this.maskToString(this.m_byteHash));
        }
        if (this.hasHash((short)4)) {
            maskBuffer.append(" CHARS: ");
            maskBuffer.append(this.maskToString(this.m_charHash));
        }
        if (this.hasHash((short)8)) {
            maskBuffer.append(" DOUBLES: ");
            maskBuffer.append(this.maskToString(this.m_doubleHash));
        }
        if (this.hasHash((short)16)) {
            maskBuffer.append(" FLOATS: ");
            maskBuffer.append(this.maskToString(this.m_floatHash));
        }
        if (this.hasHash((short)32)) {
            maskBuffer.append(" INTS: ");
            maskBuffer.append(this.maskToString(this.m_intHash));
        }
        if (this.hasHash((short)64)) {
            maskBuffer.append(" LONGS: ");
            maskBuffer.append(this.maskToString(this.m_longHash));
        }
        if (this.hasHash((short)128)) {
            maskBuffer.append(" SHORTS: ");
            maskBuffer.append(this.maskToString(this.m_shortHash));
        }
        if (this.hasHash((short)256)) {
            maskBuffer.append(" STRINGS: ");
            maskBuffer.append(this.maskToString(this.m_stringHash));
        }
        if (this.hasHash((short)512)) {
            maskBuffer.append(" BLOBS: ");
            maskBuffer.append(this.maskToString(this.m_blobHash));
        }
        if (this.hasHash((short)1024)) {
            maskBuffer.append(" UNSIGNED-BYTES: ");
            maskBuffer.append(this.maskToString(this.m_unsignedByteHash));
        }
        if (this.hasHash((short)2048)) {
            maskBuffer.append(" UNSIGNED-SHORTS: ");
            maskBuffer.append(this.maskToString(this.m_unsignedShortHash));
        }
        for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
            if (!this.hasHash(CUSTOM_DATUMS[i])) continue;
            maskBuffer.append(" CUSTOM DATUM " + i + ": ");
            maskBuffer.append(this.maskToString(this.m_customDatumHash[i]));
        }
        return maskBuffer.toString();
    }

    public boolean equals(Object that) {
        return this.equals((TypeMask)that);
    }

    public boolean equals(TypeMask that) {
        if (this.getTypesHash() != that.getTypesHash()) {
            return false;
        }
        if (this.getBoolHash() != that.getBoolHash()) {
            return false;
        }
        if (this.getByteHash() != that.getByteHash()) {
            return false;
        }
        if (this.getCharHash() != that.getCharHash()) {
            return false;
        }
        if (this.getDoubleHash() != that.getDoubleHash()) {
            return false;
        }
        if (this.getFloatHash() != that.getFloatHash()) {
            return false;
        }
        if (this.getIntHash() != that.getIntHash()) {
            return false;
        }
        if (this.getLongHash() != that.getLongHash()) {
            return false;
        }
        if (this.getShortHash() != that.getShortHash()) {
            return false;
        }
        if (this.getStringHash() != that.getStringHash()) {
            return false;
        }
        if (this.getBlobHash() != that.getBlobHash()) {
            return false;
        }
        if (this.getUnsignedByteHash() != that.getUnsignedByteHash()) {
            return false;
        }
        if (this.getUnsignedShortHash() != that.getUnsignedShortHash()) {
            return false;
        }
        if (this.m_customDatumHash == null && that.m_customDatumHash != null || this.m_customDatumHash != null && that.m_customDatumHash == null) {
            return false;
        }
        if (this.m_customDatumHash != null) {
            for (int i = 0; i <= 2; i = (int)((byte)(i + 1))) {
                if (this.m_customDatumHash[i] == that.m_customDatumHash[i]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.m_typesHash;
    }

    byte getNumberOfTypes() {
        byte numberOfTypes = 0;
        if (this.m_blobHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_boolHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_byteHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_charHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_customDatumHash != null) {
            for (int i = 0; i < this.m_customDatumHash.length; i = (int)((byte)(i + 1))) {
                if (this.m_customDatumHash[i] == 0L) continue;
                numberOfTypes = (byte)(numberOfTypes + 1);
            }
        }
        if (this.m_doubleHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_floatHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_intHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_longHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_shortHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_stringHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_unsignedByteHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        if (this.m_unsignedShortHash != 0L) {
            numberOfTypes = (byte)(numberOfTypes + 1);
        }
        return numberOfTypes;
    }

    private static class HashKeyFactory {
        private static final long[] HASH_KEYS = new long[63];

        private HashKeyFactory() {
        }

        private static byte[] get(long hashValue) {
            byte[] bytes = new byte[63];
            int count = 0;
            for (int n = 0; n < 63 && HASH_KEYS[n] <= hashValue; ++n) {
                if ((hashValue & HASH_KEYS[n]) == 0L) continue;
                bytes[count] = (byte)n;
                ++count;
            }
            byte[] newbytes = new byte[count];
            System.arraycopy(bytes, 0, newbytes, 0, count);
            return newbytes;
        }

        static {
            for (int n = 0; n < 63; ++n) {
                HashKeyFactory.HASH_KEYS[n] = 1L << n;
            }
        }
    }
}

