/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.ILoadableMapMarkerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMultiLevelMapMarkerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerListSubIndexNoFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerListSubIndexNode;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;
import java.util.ArrayList;

public abstract class LoadableMapMarkerListSubIndex
extends MapMarkerListSubIndexNoFile
implements ILoadableMapMarkerSubIndex {
    @Override
    public void load(SeekableDataInput file, long offset, int level, IMultiLevelMapMarkerIndexHelper helper) throws IOException {
        file.seek(offset);
        int listSize = file.readShort();
        this.setList(new ArrayList(listSize));
        for (int i = 0; i < listSize; ++i) {
            MapMarkerIndexKey key = this.getIndexKeyType();
            key.read(file);
            Object value = this.getIndexValueType();
            if (value instanceof MapMarkerIndexValue) {
                ((MapMarkerIndexValue)value).read(file);
            } else {
                ((INextIndexValue)value).read(file);
            }
            if (!this.isTerminal()) {
                long currentOffset = file.getFilePointer();
                ILoadableMapMarkerSubIndex nextIndex = helper.getSubIndexAt(level + 1);
                nextIndex.load(file, ((INextIndexValue)value).getOffset(), level + 1, helper);
                this.getList().add(new MapMarkerListSubIndexNode(key, nextIndex));
                file.seek(currentOffset);
                continue;
            }
            this.getList().add(new MapMarkerListSubIndexNode(key, value));
        }
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract Object getIndexValueType();
}

