/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeNode;
import com.mapinfo.mapmarker.common.dp.binary.index.ILoadableMapMarkerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMultiLevelMapMarkerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerTreeSubIndexNoFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerTreeSubIndexNoFileNode;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;

public abstract class LoadableMapMarkerTreeSubIndex
extends MapMarkerTreeSubIndexNoFile
implements ILoadableMapMarkerSubIndex {
    private static final long NO_OFFSET = -1L;

    @Override
    public void load(SeekableDataInput file, long offset, int level, IMultiLevelMapMarkerIndexHelper helper) throws IOException {
        this.root = this.readNodeAt(file, offset, level, helper);
    }

    private BinaryTreeNode readNodeAt(SeekableDataInput file, long offset, int level, IMultiLevelMapMarkerIndexHelper helper) throws IOException {
        MapMarkerTreeSubIndexNoFileNode node;
        if (offset == -1L) {
            return MapMarkerTreeSubIndexNoFile.z;
        }
        file.seek(offset);
        MapMarkerIndexKey key = this.getIndexKeyType();
        key.read(file);
        Object value = this.getIndexValueType();
        if (value instanceof MapMarkerIndexValue) {
            ((MapMarkerIndexValue)value).read(file);
        } else {
            ((INextIndexValue)value).read(file);
        }
        long leftChildOffset = file.readLong();
        long rightChildOffset = file.readLong();
        if (this.isTerminal()) {
            node = new MapMarkerTreeSubIndexNoFileNode(new TreeItem(key, value));
        } else {
            ILoadableMapMarkerSubIndex nextIndex = helper.getSubIndexAt(level + 1);
            nextIndex.load(file, ((INextIndexValue)value).getOffset(), level + 1, helper);
            node = new MapMarkerTreeSubIndexNoFileNode(new TreeItem(key, nextIndex));
        }
        node.attachLeft(this.readNodeAt(file, leftChildOffset, level, helper));
        node.attachRight(this.readNodeAt(file, rightChildOffset, level, helper));
        return node;
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract Object getIndexValueType();
}

