/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerCharSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIntSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class MapMarkerBrowseMultiLevelIndexKey
implements MapMarkerMultiLevelIndexKey {
    private int m_levels = 3;
    private MapMarkerIndexKey[] m_keys = new MapMarkerIndexKey[this.m_levels];

    public MapMarkerBrowseMultiLevelIndexKey() {
        this(-1, '\u0000', null);
    }

    public MapMarkerBrowseMultiLevelIndexKey(int sac, char firstLetter, int[] collationKey) {
        if (collationKey == null) {
            this.m_keys[0] = new MapMarkerIntSubIndexKey();
            this.m_keys[1] = new MapMarkerCharSubIndexKey();
            this.m_keys[2] = new MapMarkerBrowseSubIndexKey();
        } else {
            this.m_keys[0] = new MapMarkerIntSubIndexKey(sac);
            this.m_keys[1] = new MapMarkerCharSubIndexKey(firstLetter);
            this.m_keys[2] = new MapMarkerBrowseSubIndexKey(collationKey);
        }
    }

    @Override
    public int getLevels() {
        return this.m_levels;
    }

    @Override
    public MapMarkerIndexKey getKeyAt(int level) {
        return this.m_keys[level];
    }

    @Override
    public void write(DataOutput out) throws IOException {
        for (int i = 0; i < this.m_levels; ++i) {
            this.m_keys[i].write(out);
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        for (int i = 0; i < this.m_levels; ++i) {
            this.m_keys[i].read(in);
        }
    }

    public boolean equals(Object that) {
        MapMarkerBrowseMultiLevelIndexKey thatKey = (MapMarkerBrowseMultiLevelIndexKey)that;
        return Arrays.equals(this.m_keys, thatKey.m_keys);
    }

    public int compareTo(Object o2) {
        MapMarkerBrowseMultiLevelIndexKey key2 = (MapMarkerBrowseMultiLevelIndexKey)o2;
        if (this.equals(key2)) {
            return 0;
        }
        for (int i = 0; i < this.m_levels; ++i) {
            if (this.m_keys[i].equals(key2.m_keys[i])) continue;
            return this.m_keys[i].compareTo(key2.m_keys[i]);
        }
        return 0;
    }

    public void replaceSac(int newSac) {
        this.m_keys[0] = new MapMarkerIntSubIndexKey(newSac);
    }
}

