/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.ILoadableMapMarkerMultiLevelFirstLevelSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyMultiLevelIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyMultiLevelLoadableFirstLevelIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;

public class MapMarkerMultiLevelReadOnlyIndexFile
implements IMapMarkerReadOnlyIndexFile {
    private MapMarkerMultiLevelIndexFileMetadata m_metadata;
    private String m_indexFileName;
    private int m_levels;
    private IMapMarkerReadOnlyMultiLevelIndexFileHelper m_helper;
    private long m_indexStart;
    private ILoadableMapMarkerMultiLevelFirstLevelSubIndex m_firstLevel;

    public MapMarkerMultiLevelReadOnlyIndexFile(IMapMarkerReadOnlyMultiLevelIndexFileHelper helper) {
        this.m_helper = helper;
        if (this.m_helper instanceof IMapMarkerReadOnlyMultiLevelLoadableFirstLevelIndexFileHelper) {
            this.m_firstLevel = ((IMapMarkerReadOnlyMultiLevelLoadableFirstLevelIndexFileHelper)this.m_helper).getFirstLevel();
        }
    }

    public String getIndexFileName() {
        return this.m_indexFileName;
    }

    @Override
    public void open(String indexFileName) throws IOException {
        SeekableDataInput indexFile = FileProviderFactory.getFileProvider().get(indexFileName);
        try {
            this.open(indexFileName, indexFile);
        }
        finally {
            FileProviderFactory.getFileProvider().release(indexFile);
        }
    }

    protected void open(String indexFileName, SeekableDataInput indexFile) throws IOException {
        this.m_indexFileName = indexFileName;
        indexFile.seek(0L);
        this.m_metadata = this.getMetadataType();
        this.m_metadata.read(indexFile);
        this.m_levels = this.m_metadata.getLevels();
        this.m_indexStart = indexFile.getFilePointer();
        if (this.m_firstLevel != null) {
            this.m_firstLevel.load(indexFile, this.m_indexStart);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.m_firstLevel != null) {
            this.m_firstLevel.close();
        }
    }

    public MapMarkerIndexValue search(MapMarkerIndexKey key, SeekableDataInput file) throws IOException {
        MapMarkerMultiLevelIndexKey multiKey = (MapMarkerMultiLevelIndexKey)key;
        MapMarkerIndexValue result = null;
        INextIndexValue value = this.m_firstLevel == null ? (INextIndexValue)this.m_helper.getSubIndexAt(0).search(multiKey.getKeyAt(0), file, this.m_indexStart) : (INextIndexValue)this.m_firstLevel.search(multiKey.getKeyAt(0));
        if (value != null) {
            int lastLevelIndex = this.m_levels - 1;
            for (int i = 1; i < lastLevelIndex && (value = (INextIndexValue)this.m_helper.getSubIndexAt(i).search(multiKey.getKeyAt(i), file, value.getOffset())) != null; ++i) {
            }
            if (value != null) {
                result = (MapMarkerIndexValue)this.m_helper.getSubIndexAt(lastLevelIndex).search(multiKey.getKeyAt(lastLevelIndex), file, value.getOffset());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapMarkerIndexValue search(MapMarkerIndexKey key) throws IOException {
        SeekableDataInput file = FileProviderFactory.getFileProvider().get(this.m_indexFileName);
        try {
            MapMarkerIndexValue mapMarkerIndexValue = this.search(key, file);
            return mapMarkerIndexValue;
        }
        finally {
            FileProviderFactory.getFileProvider().release(file);
        }
    }

    protected MapMarkerMultiLevelIndexFileMetadata getMetadataType() {
        return new MapMarkerMultiLevelIndexFileMetadata();
    }
}

