/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerSingleThreadedMultiLevelIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.ISingleThreadedNextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.ISingleThreadedSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.SeekableDataInputNIO;
import java.io.File;
import java.io.IOException;

public class MapMarkerMultiLevelSingleThreadedIndexFile
implements IMapMarkerReadOnlyIndexFile {
    private SeekableDataInput m_indexStream;
    private MapMarkerMultiLevelIndexFileMetadata m_metadata;
    private int m_levels;
    private IMapMarkerSingleThreadedMultiLevelIndexFileHelper m_helper;
    private ISingleThreadedSubIndex m_firstLevel;

    public MapMarkerMultiLevelSingleThreadedIndexFile(IMapMarkerSingleThreadedMultiLevelIndexFileHelper helper) {
        this.m_helper = helper;
        this.m_metadata = this.getMetadataType();
    }

    @Override
    public void open(String fileSpec) throws IOException {
        this.m_indexStream = new SeekableDataInputNIO(new File(fileSpec));
        this.m_metadata.read(this.m_indexStream);
        this.m_levels = this.m_metadata.getLevels();
        this.m_firstLevel = this.m_helper.getSubIndexAt(0);
        this.m_firstLevel.open(this.m_indexStream, this.m_indexStream.getFilePointer());
    }

    @Override
    public void close() throws IOException {
        this.m_indexStream.close();
        this.m_metadata = null;
    }

    @Override
    public MapMarkerIndexValue search(MapMarkerIndexKey key) throws IOException {
        int i;
        MapMarkerMultiLevelIndexKey multiKey = (MapMarkerMultiLevelIndexKey)key;
        ISingleThreadedNextIndexValue next = (ISingleThreadedNextIndexValue)this.m_firstLevel.search(multiKey.getKeyAt(0), this.m_indexStream);
        if (next == null) {
            return null;
        }
        for (i = 1; i < this.m_levels - 1; ++i) {
            if (next.getNextIndex() == null) {
                this.attachSubIndexIndex(next, this.m_helper.getSubIndexAt(i));
            }
            if ((next = (ISingleThreadedNextIndexValue)next.getNextIndex().search(multiKey.getKeyAt(i), this.m_indexStream)) != null) continue;
            return null;
        }
        if (next.getNextIndex() == null) {
            this.attachSubIndexIndex(next, this.m_helper.getSubIndexAt(i));
        }
        return (MapMarkerIndexValue)next.getNextIndex().search(multiKey.getKeyAt(i), this.m_indexStream);
    }

    protected MapMarkerMultiLevelIndexFileMetadata getMetadataType() {
        return new MapMarkerMultiLevelIndexFileMetadata();
    }

    private void attachSubIndexIndex(ISingleThreadedNextIndexValue next, ISingleThreadedSubIndex index) throws IOException {
        index.open(this.m_indexStream, next.getOffset());
        next.attachIndex(index);
    }
}

