/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeIndexFileNode;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import com.mapinfo.mapmarker.utils.SeekableDataInputNIO;
import java.io.File;
import java.io.IOException;

public abstract class MapMarkerSimpleSingleThreadedIndexFile
implements IMapMarkerReadOnlyIndexFile {
    private TreeIndexFileNode m_root;
    private SeekableDataInput m_indexStream;
    private MapMarkerIndexFileMetadata m_metadata;

    @Override
    public void open(String fileSpec) throws IOException {
        this.m_indexStream = new SeekableDataInputNIO(new File(fileSpec));
        this.m_metadata = this.getMetadataType();
        this.m_metadata.read(this.m_indexStream);
        this.m_root = this.getIndexFileNodeType();
        this.m_root.read(this.m_indexStream);
    }

    @Override
    public void close() throws IOException {
        this.m_indexStream.close();
    }

    @Override
    public MapMarkerIndexValue search(MapMarkerIndexKey key) throws IOException {
        return this.searchTree(this.m_root, key);
    }

    protected MapMarkerIndexFileMetadata getMetadataType() {
        return new MapMarkerIndexFileMetadata();
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract MapMarkerIndexValue getIndexValueType();

    private TreeIndexFileNode getIndexFileNodeType() {
        return new TreeIndexFileNode(this.getIndexKeyType(), this.getIndexValueType());
    }

    private MapMarkerIndexValue searchTree(TreeIndexFileNode node, MapMarkerIndexKey key) throws IOException {
        int keyRelation = node.getKey().compareTo(key);
        if (keyRelation == 0) {
            return node.getValue();
        }
        if (keyRelation > 0) {
            if (node.getLeft() == TreeIndexFileNode.z) {
                if (node.getLeftOffset() != -1L) {
                    this.attachLeft(node);
                    return this.searchFile(node.getLeft(), key);
                }
                return null;
            }
            return this.searchTree(node.getLeft(), key);
        }
        if (node.getRight() == TreeIndexFileNode.z) {
            if (node.getRightOffset() != -1L) {
                this.attachRight(node);
                return this.searchFile(node.getRight(), key);
            }
            return null;
        }
        return this.searchTree(node.getRight(), key);
    }

    private void attachLeft(TreeIndexFileNode node) throws IOException {
        this.m_indexStream.seek(node.getLeftOffset());
        node.attachLeft(this.getIndexFileNodeType());
        node.getLeft().read(this.m_indexStream);
    }

    private void attachRight(TreeIndexFileNode node) throws IOException {
        this.m_indexStream.seek(node.getRightOffset());
        node.attachRight(this.getIndexFileNodeType());
        node.getRight().read(this.m_indexStream);
    }

    private MapMarkerIndexValue searchFile(TreeIndexFileNode node, MapMarkerIndexKey key) throws IOException {
        int keyRelation = node.getKey().compareTo(key);
        if (keyRelation == 0) {
            return node.getValue();
        }
        if (keyRelation > 0) {
            if (node.getLeftOffset() != -1L) {
                this.attachLeft(node);
                return this.searchFile(node.getLeft(), key);
            }
            return null;
        }
        if (node.getRightOffset() != -1L) {
            this.attachRight(node);
            return this.searchFile(node.getRight(), key);
        }
        return null;
    }
}

