/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerCharSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIntSubIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class MapMarkerStreetMultiLevelIndexKey
implements MapMarkerMultiLevelIndexKey {
    private int m_levels = 3;
    private MapMarkerIndexKey[] m_keys = new MapMarkerIndexKey[this.m_levels];

    MapMarkerStreetMultiLevelIndexKey() {
        this(null);
    }

    MapMarkerStreetMultiLevelIndexKey(MiSoundexStreetDataIndexKey key) {
        if (key == null) {
            this.m_keys[0] = new MapMarkerIntSubIndexKey();
            this.m_keys[1] = new MapMarkerCharSubIndexKey();
            this.m_keys[2] = new MapMarkerIntSubIndexKey();
        } else {
            this.m_keys[0] = new MapMarkerIntSubIndexKey(key.getSac());
            MiSoundexKey soundex = (MiSoundexKey)key.getSoundex();
            this.m_keys[1] = new MapMarkerCharSubIndexKey(soundex.getFirstChar());
            this.m_keys[2] = new MapMarkerIntSubIndexKey(soundex.getNumericValue());
        }
    }

    public MapMarkerStreetMultiLevelIndexKey(int sac, MiSoundexKey soundex) {
        this(new MiSoundexStreetDataIndexKey(sac, soundex));
    }

    public void replaceSac(int sac) {
        this.m_keys[0] = new MapMarkerIntSubIndexKey(sac);
    }

    @Override
    public int getLevels() {
        return this.m_levels;
    }

    @Override
    public MapMarkerIndexKey getKeyAt(int level) {
        return this.m_keys[level];
    }

    @Override
    public void write(DataOutput out) throws IOException {
        for (int i = 0; i < this.m_levels; ++i) {
            this.m_keys[i].write(out);
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        for (int i = 0; i < this.m_levels; ++i) {
            this.m_keys[i].read(in);
        }
    }

    public boolean equals(Object that) {
        MapMarkerStreetMultiLevelIndexKey thatKey = (MapMarkerStreetMultiLevelIndexKey)that;
        return Arrays.equals(this.m_keys, thatKey.m_keys);
    }

    public int compareTo(Object o2) {
        MapMarkerStreetMultiLevelIndexKey key2 = (MapMarkerStreetMultiLevelIndexKey)o2;
        if (this.equals(key2)) {
            return 0;
        }
        for (int i = 0; i < this.m_levels; ++i) {
            if (this.m_keys[i].equals(key2.m_keys[i])) continue;
            return this.m_keys[i].compareTo(key2.m_keys[i]);
        }
        return 0;
    }

    public String toString() {
        String retStr = null;
        for (int i = 0; i < this.m_levels; ++i) {
            retStr = retStr == null ? this.m_keys[i].toString() : retStr + " : " + this.m_keys[i].toString();
        }
        return retStr;
    }
}

