/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeNode;
import com.mapinfo.mapmarker.common.dp.binary.index.ILoadableMapMarkerMultiLevelFirstLevelSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.INextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerTreeSubIndexNoFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerTreeSubIndexNoFileNode;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;

public abstract class MapMarkerTreeLoadableFirstLevelSubIndex
extends MapMarkerTreeSubIndexNoFile
implements ILoadableMapMarkerMultiLevelFirstLevelSubIndex {
    private static final long NO_OFFSET = -1L;

    @Override
    public void load(SeekableDataInput file, long offset) throws IOException {
        this.root = this.readNodeAt(file, offset);
    }

    @Override
    public void close() throws IOException {
        this.root = null;
    }

    private BinaryTreeNode readNodeAt(SeekableDataInput file, long offset) throws IOException {
        if (offset == -1L) {
            return MapMarkerTreeSubIndexNoFile.z;
        }
        file.seek(offset);
        MapMarkerIndexKey key = this.getIndexKeyType();
        key.read(file);
        INextIndexValue value = this.getIndexValueType();
        value.read(file);
        long leftChildOffset = file.readLong();
        long rightChildOffset = file.readLong();
        MapMarkerTreeSubIndexNoFileNode node = new MapMarkerTreeSubIndexNoFileNode(new TreeItem(key, value));
        node.attachLeft(this.readNodeAt(file, leftChildOffset));
        node.attachRight(this.readNodeAt(file, rightChildOffset));
        return node;
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract INextIndexValue getIndexValueType();
}

