/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.INextIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.IReadOnlySubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;

public abstract class ReadOnlyTreeSubIndex
implements IReadOnlySubIndex {
    private static final long NO_OFFSET = -1L;

    @Override
    public Object search(MapMarkerIndexKey searchKey, SeekableDataInput file, long searchStart) throws IOException {
        if (searchStart == -1L) {
            return null;
        }
        file.seek(searchStart);
        MapMarkerIndexKey key = this.getIndexKeyType();
        key.read(file);
        Object value = this.getIndexValueType();
        if (this.isTerminal()) {
            ((MapMarkerIndexValue)value).read(file);
        } else {
            ((INextIndexValue)value).read(file);
        }
        int keyRelation = key.compareTo(searchKey);
        if (keyRelation == 0) {
            return value;
        }
        if (keyRelation > 0) {
            return this.search(searchKey, file, file.readLong());
        }
        file.skipBytes(8);
        return this.search(searchKey, file, file.readLong());
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract Object getIndexValueType();

    protected abstract boolean isTerminal();
}

