/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTree;
import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeNode;
import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.RedBlackTreeNode;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;

class RedBlackTree
extends BinaryTree {
    public RedBlackTree() {
        this.root = null;
    }

    @Override
    public void insert(TreeItem item) throws DuplicateKeyException {
        RedBlackTreeNode node = (RedBlackTreeNode)this.makeNode(item);
        this.insert(node);
        this.balance(node);
    }

    @Override
    public void dispose() {
        super.dispose();
        ((RedBlackTreeNode)RedBlackTree.z).parent = null;
    }

    @Override
    BinaryTreeNode makeNode(TreeItem item) {
        return new RedBlackTreeNode(item);
    }

    protected void balance(RedBlackTreeNode node) {
        while (node != this.root && node.getParent().isRed()) {
            RedBlackTreeNode y;
            if (node.parent == node.parent.parent.left) {
                y = (RedBlackTreeNode)node.parent.parent.right;
                if (y.isRed()) {
                    node.parent.makeBlack();
                    y.makeBlack();
                    node.parent.parent.makeRed();
                    node = node.parent.parent;
                    continue;
                }
                if (node == node.parent.right) {
                    node = node.parent;
                    this.leftRotate(node);
                }
                node.parent.makeBlack();
                node.parent.parent.makeRed();
                this.rightRotate(node.parent.parent);
                continue;
            }
            y = (RedBlackTreeNode)node.parent.parent.left;
            if (y.isRed()) {
                node.parent.makeBlack();
                y.makeBlack();
                node.parent.parent.makeRed();
                node = node.parent.parent;
                continue;
            }
            if (node == node.parent.left) {
                node = node.parent;
                this.rightRotate(node);
            }
            node.parent.makeBlack();
            node.parent.parent.makeRed();
            this.leftRotate(node.parent.parent);
        }
        ((RedBlackTreeNode)this.root).makeBlack();
    }

    private void leftRotate(RedBlackTreeNode node) {
        RedBlackTreeNode y = (RedBlackTreeNode)node.right;
        node.right = y.left;
        if (y.left != null) {
            ((RedBlackTreeNode)y.left).parent = node;
        }
        y.parent = node.parent;
        if (node.parent == null) {
            this.root = y;
        } else if (node == node.parent.left) {
            node.parent.left = y;
        } else {
            node.parent.right = y;
        }
        y.left = node;
        node.parent = y;
    }

    private void rightRotate(RedBlackTreeNode node) {
        RedBlackTreeNode y = (RedBlackTreeNode)node.left;
        node.left = y.right;
        if (y.right != null) {
            ((RedBlackTreeNode)y.right).parent = node;
        }
        y.setParent(node.getParent());
        if (node.getParent() == null) {
            this.root = y;
        } else if (node == node.parent.left) {
            node.parent.left = y;
        } else {
            node.parent.right = y;
        }
        y.right = node;
        node.parent = y;
    }

    static {
        z = new RedBlackTreeNode(null);
        ((RedBlackTreeNode)z).makeBlack();
        RedBlackTree.z.left = null;
        RedBlackTree.z.right = null;
    }
}

