/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeNode;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.SimpleMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.SimpleMapMarkerIndexNode;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;
import com.mapinfo.mapmarker.utils.FileProviderFactory;
import com.mapinfo.mapmarker.utils.SeekableDataInput;
import java.io.IOException;

public abstract class SimpleLoadableMapMarkerIndex
extends SimpleMapMarkerIndex
implements IMapMarkerReadOnlyIndexFile {
    private static final long NO_OFFSET = -1L;
    private MapMarkerIndexFileMetadata m_metadata = this.getMetadataType();

    @Override
    public final void open(String filename) throws IOException {
        SeekableDataInput file = FileProviderFactory.getFileProvider().get(filename);
        try {
            file.seek(0L);
            this.m_metadata.read(file);
            this.root = this.readNodeAt(file, file.getFilePointer());
        }
        finally {
            FileProviderFactory.getFileProvider().release(file);
        }
    }

    @Override
    public void close() throws IOException {
        this.root = null;
    }

    private BinaryTreeNode readNodeAt(SeekableDataInput file, long offset) throws IOException {
        if (offset == -1L) {
            return SimpleMapMarkerIndex.z;
        }
        MapMarkerIndexKey key = this.getIndexKeyType();
        MapMarkerIndexValue value = this.getIndexValueType();
        file.seek(offset);
        key.read(file);
        value.read(file);
        long leftNodeOffset = file.readLong();
        long rightNodeOffset = file.readLong();
        SimpleMapMarkerIndexNode node = new SimpleMapMarkerIndexNode(new TreeItem(key, value));
        node.attachLeft(this.readNodeAt(file, leftNodeOffset));
        node.attachRight(this.readNodeAt(file, rightNodeOffset));
        return node;
    }

    protected abstract MapMarkerIndexKey getIndexKeyType();

    protected abstract MapMarkerIndexValue getIndexValueType();

    protected MapMarkerIndexFileMetadata getMetadataType() {
        return new MapMarkerIndexFileMetadata();
    }
}

