/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StreetDataIndexKey
implements MapMarkerIndexKey {
    private int sac;
    private ISoundexKey soundex;

    public StreetDataIndexKey() {
        this(-1, null);
    }

    public StreetDataIndexKey(int sac, ISoundexKey soundex) {
        this.sac = sac;
        this.soundex = soundex;
    }

    public int getSac() {
        return this.sac;
    }

    public ISoundexKey getSoundex() {
        return this.soundex;
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.sac = in.readInt();
        this.soundex.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.sac);
        this.soundex.write(out);
    }

    public int compareTo(Object o2) {
        StreetDataIndexKey key2 = (StreetDataIndexKey)o2;
        if (this.equals(key2)) {
            return 0;
        }
        if (this.sac == key2.sac) {
            return this.soundex.compareTo(key2.soundex);
        }
        return this.sac - key2.sac;
    }

    public boolean equals(Object o) {
        StreetDataIndexKey that = (StreetDataIndexKey)o;
        if (this.sac == that.sac) {
            return this.soundex.equals(that.soundex);
        }
        return false;
    }

    public String toString() {
        return "Sac: " + this.sac + "\tSoundex: " + this.soundex.toString();
    }
}

