/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.TreeItem;
import com.mapinfo.mapmarker.common.dp.binary.index.WritableTreeKey;
import com.mapinfo.mapmarker.common.dp.binary.index.WritableTreeValue;
import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;

class WritableTreeItem
extends TreeItem {
    private long leftChildPosition = -1L;
    private long rightChildPosition = -1L;

    public WritableTreeItem(WritableTreeKey key, WritableTreeValue value) {
        super(key, value);
    }

    public void setLeftChildPosition(long leftChildPosition) {
        this.leftChildPosition = leftChildPosition;
    }

    public long getLeftChildPosition() {
        return this.leftChildPosition;
    }

    public void setRightChildPosition(long rightChildPosition) {
        this.rightChildPosition = rightChildPosition;
    }

    public long getRightChildPosition() {
        return this.rightChildPosition;
    }

    public void write(RandomAccessFile out) throws IOException {
        ((WritableTreeKey)this.getKey()).write(out);
        ((WritableTreeValue)this.getValue()).write(out);
        out.writeLong(this.leftChildPosition);
        out.writeLong(this.rightChildPosition);
    }

    public void update(RandomAccessFile out, long position) throws IOException {
        out.seek(position);
        this.write(out);
    }

    public void read(DataInput in) throws IOException {
        ((WritableTreeKey)this.getKey()).read(in);
        ((WritableTreeValue)this.getValue()).read(in);
        this.leftChildPosition = in.readLong();
        this.rightChildPosition = in.readLong();
    }
}

