/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.descriptor;

import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.descriptor.MetaData;
import com.mapinfo.mapmarker.utils.FileUtilities;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class DataDescriptorProvider {
    String DICTIONARY_DESC = "dictionarydesc.properties";
    String CYPHER_KEY = "1A22440ED3A39F98DDF15FDC5176015B";
    private static DataDescriptorProvider provider;
    private Map<String, List<MetaData>> metaDataMap;

    private DataDescriptorProvider() {
    }

    public static DataDescriptorProvider getInstance() throws IOException {
        if (provider == null) {
            provider = new DataDescriptorProvider();
            provider.initMetaData();
        }
        return provider;
    }

    public void initMetaData() throws IOException {
        DataManagerSettingsProvider provider = DataManagerSettingsProvider.getInstance();
        this.metaDataMap = new HashMap<String, List<MetaData>>();
        HashMap map = provider.getSettingsForAllCountries();
        if (map != null && map.size() > 0) {
            for (Object key : map.keySet()) {
                int count;
                Properties properties = (Properties)map.get(key);
                String dicCount = properties.getProperty("DICTIONARY_COUNT");
                if (StringUtilities.isEmpty(dicCount) || (count = Integer.valueOf(dicCount).intValue()) <= 0) continue;
                for (int i = 1; i <= count; ++i) {
                    String licenseCodes;
                    Properties desc;
                    String supportedCountries;
                    File file;
                    String path = properties.getProperty("DICTIONARY_PATH" + i);
                    if (path == null || !(file = new File(Paths.get(path, new String[0]).toAbsolutePath() + "/" + this.DICTIONARY_DESC)).exists() || StringUtilities.isEmpty(supportedCountries = (desc = FileUtilities.loadProperties(file)).getProperty("supportedCountries"))) continue;
                    String[] countries = supportedCountries.split(",");
                    ArrayList<MetaData> metaDatas = this.metaDataMap.containsKey(countries[0]) ? this.metaDataMap.get(countries[0]) : new ArrayList<MetaData>();
                    MetaData metaData = new MetaData();
                    metaData.setCountries(Arrays.asList(countries));
                    metaData.setDataType(desc.getProperty("dataType"));
                    metaData.setDescription(desc.getProperty("description"));
                    metaData.setProductCode(desc.getProperty("productCode"));
                    metaData.setVersion(desc.getProperty("vintage"));
                    metaData.setLanguage(desc.getProperty("language"));
                    metaData.setPrecisionType(desc.getProperty("precisionType"));
                    String internalProductCode = desc.getProperty("internalProductCode");
                    if (!StringUtilities.isEmpty(internalProductCode) && !StringUtilities.isEmpty(licenseCodes = this.decryptDecode(internalProductCode))) {
                        String licenseOverride = null;
                        if (licenseCodes.contains(":")) {
                            String[] temp = licenseCodes.split(":");
                            licenseOverride = temp[1];
                            licenseCodes = temp[0];
                        }
                        String[] licenseCodes1 = licenseCodes.split(",");
                        metaData.setLicenseCodes(Arrays.asList(licenseCodes1));
                        metaData.setUltraLicenseCode(licenseOverride);
                    }
                    metaData.setLocation(file.getParentFile().toPath());
                    metaDatas.add(metaData);
                    this.metaDataMap.put(countries[0], metaDatas);
                }
            }
        }
    }

    public String decryptDecode(String encryptedString) {
        String res = encryptedString;
        try {
            if (StringUtilities.isEmpty(res)) {
                return res;
            }
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] key = sha.digest(this.CYPHER_KEY.getBytes("UTF-8"));
            key = Arrays.copyOf(key, 16);
            SecretKeySpec aesKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, aesKey);
            byte[] decoded = DatatypeConverter.parseBase64Binary((String)this.fixPadding(encryptedString));
            res = new String(cipher.doFinal(decoded));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private String fixPadding(String value) {
        if (!StringUtilities.isEmpty(value)) {
            while (value.length() % 4 != 0) {
                value = value + "=";
            }
        }
        return value;
    }

    public List<MetaData> getMetaData(String country) {
        if (this.metaDataMap.containsKey(country)) {
            return this.metaDataMap.get(country);
        }
        return new ArrayList<MetaData>();
    }

    public List<MetaData> getMetaData() {
        ArrayList<MetaData> metaDatas = new ArrayList<MetaData>();
        if (this.metaDataMap.size() > 0) {
            for (String key : this.metaDataMap.keySet()) {
                metaDatas.addAll((Collection<MetaData>)this.metaDataMap.get(key));
            }
        }
        return metaDatas;
    }
}

