/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial;

import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.operations.GeometryOperations;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.Offset;

public class IndexUtils {
    public static final SpatialInfo SI = new SpatialInfo(CoordSysConstants.longLatWGS84);

    public static Envelope createRect(DirectPosition p, Length d) {
        if (!SI.getCoordSys().getMBR().contains(p)) {
            Envelope result = new Envelope(SI);
            result.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return result;
        }
        GeometryFactory factory = new GeometryFactory(SI);
        Point point = factory.newPoint(p.getX(), p.getY());
        try {
            IFeatureGeometry geometry = GeometryOperations.buffer((IGeometry)point, (Offset)new Offset(d.getValue(LinearUnit.METER) + 1.0, LinearUnit.METER));
            Envelope e = geometry.getEnvelope();
            Envelope result = new Envelope(SI);
            result.set(e.getLLX(), e.getLLY(), e.getURX(), e.getURY());
            return result;
        }
        catch (RuntimeException ex) {
            Envelope result = new Envelope(SI);
            result.set(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return result;
        }
    }
}

