/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskNode;
import java.util.ArrayList;
import java.util.List;

class BreadthIterator {
    private final DiskNode m_rootNode;
    private List<NodeState> m_itrState = new ArrayList<NodeState>();
    private int m_currentLevel;

    public BreadthIterator(DiskNode rootNode) {
        this.m_rootNode = rootNode;
        this.m_currentLevel = rootNode.getLevel();
        this.m_itrState.add(new NodeState(rootNode, Integer.MIN_VALUE));
    }

    public boolean hasNextNode() {
        return !this.m_itrState.isEmpty();
    }

    public DiskNode nextNode() {
        DiskNode result = this.m_itrState.get(this.m_itrState.size() - 1).getNode();
        this.loadNextNode();
        return result;
    }

    private void loadNextNode() {
        NodeState nodeState = this.m_itrState.remove(this.m_itrState.size() - 1);
        this.loadNextChild(nodeState.getIndexInParent());
        if (this.m_itrState.size() == 0) {
            --this.m_currentLevel;
            if (this.m_currentLevel >= 0) {
                this.loadToLevel();
            }
        }
    }

    private void loadToLevel() {
        this.m_itrState.add(new NodeState(this.m_rootNode, Integer.MIN_VALUE));
        for (int i = this.m_rootNode.getLevel(); i != this.m_currentLevel; --i) {
            DiskNode node = this.m_itrState.get(this.m_itrState.size() - 1).getNode();
            this.m_itrState.add(new NodeState((DiskNode)node.getChild(0), 0));
        }
    }

    private void loadNextChild(int lastChildIndex) {
        if (this.m_itrState.isEmpty()) {
            return;
        }
        NodeState nodeState = this.m_itrState.get(this.m_itrState.size() - 1);
        DiskNode node = nodeState.getNode();
        if (node.size() > ++lastChildIndex) {
            DiskNode child = (DiskNode)node.getChild(lastChildIndex);
            this.m_itrState.add(new NodeState(child, lastChildIndex));
        } else {
            DiskNode newParent;
            this.m_itrState.remove(this.m_itrState.size() - 1);
            this.loadNextChild(nodeState.getIndexInParent());
            if (this.m_itrState.size() > 0 && (newParent = this.m_itrState.get(this.m_itrState.size() - 1).getNode()).size() > 0) {
                this.m_itrState.add(new NodeState((DiskNode)newParent.getChild(0), 0));
            }
        }
    }

    private static class NodeState {
        public static final int NO_PARENT = Integer.MIN_VALUE;
        private DiskNode m_node;
        private int m_indexInParent;

        private NodeState(DiskNode node, int indexInParent) {
            this.m_node = node;
            this.m_indexInParent = indexInParent;
        }

        public DiskNode getNode() {
            return this.m_node;
        }

        public int getIndexInParent() {
            return this.m_indexInParent;
        }
    }
}

