/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.BlockInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskNode;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskStructureOperations;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.ReadOnlyStream;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.RootInfo;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.midev.index.rtree.IRTreeHelper;
import com.mapinfo.midev.index.rtree.IRTreeNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

class DiskRGHelper
implements IRTreeHelper {
    private static BlockInfo DEFAULT_BLOCK_INFO = new BlockInfo(512, 25, 12);
    private DiskNode m_root;
    private final DiskStructureOperations m_diskOps;
    IRandomDataInputOutputStream m_stream;

    public DiskRGHelper(AccessMode accessMode, File file, IPersistenceDecorator pDec) {
        this(accessMode, file, pDec, DEFAULT_BLOCK_INFO);
    }

    public DiskRGHelper(AccessMode accessMode, File file, IPersistenceDecorator pDec, BlockInfo blockInfo) {
        try {
            switch (accessMode) {
                case CREATE: {
                    this.m_stream = this.create(file);
                    this.m_diskOps = new DiskStructureOperations(blockInfo, this.m_stream, pDec);
                    break;
                }
                case READ_ONLY: {
                    this.m_stream = this.openRead(file);
                    this.m_diskOps = new DiskStructureOperations(this.m_stream, pDec);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown access mode: " + (Object)((Object)accessMode));
                }
            }
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
        RootInfo info = this.m_diskOps.getRootInfo();
        this.m_root = new DiskNode(this, info.getPosition(), info.getBounds(), info.getLevel(), null);
    }

    private RandomAccessDataStream create(File file) throws IOException {
        if (!file.createNewFile()) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2110, new String[]{file.getPath()}));
        }
        return new RandomAccessDataStream(file);
    }

    private ReadOnlyStream openRead(File file) throws FileNotFoundException {
        this.checkForFile(file);
        return new ReadOnlyStream(file);
    }

    private void checkForFile(File file) {
        if (!file.exists()) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2107, new String[]{file.getPath()}));
        }
    }

    public DiskNode getRootNode() {
        return this.m_root;
    }

    public void setAsRootNode(IRTreeNode node) {
        DiskNode newRoot;
        this.m_root = newRoot = (DiskNode)node;
        this.m_diskOps.updateRootInfo(new RootInfo(newRoot.getPosition(), newRoot.getBounds(), newRoot.getLevel()));
    }

    public DiskNode createNode() {
        return new DiskNode(this);
    }

    public void deleteNode(IRTreeNode irTreeNode) {
        throw new UnsupportedOperationException();
    }

    public int getMaxNodeCapacity() {
        return this.m_diskOps.getBlockInfo().getMaxNodeCapacity();
    }

    public int getMinNodeCapacity() {
        return this.m_diskOps.getBlockInfo().getMinNodeCapacity();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    DiskStructureOperations getDiskOperations() {
        return this.m_diskOps;
    }

    void close() {
        try {
            this.m_stream.close();
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public static enum AccessMode {
        READ_ONLY,
        CREATE;

    }
}

