/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIndex;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIterator;
import com.mapinfo.mapmarker.common.dp.index.spatial.IndexUtils;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskNode;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGHelper;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import com.mapinfo.midev.index.rtree.IRTreeEnvelopeSearch;
import com.mapinfo.midev.index.rtree.IRTreeHelper;
import com.mapinfo.midev.index.rtree.RTree;
import com.mapinfo.midev.index.rtree.RTreeCursor;
import com.mapinfo.midev.index.rtree.RTreeEnvelopeSearch;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class DiskRGIndex<E>
implements IRGIndex<E> {
    private static final SpatialInfo SI = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private final File m_inFile;
    private final IPersistenceDecorator<E> m_pDec;
    private final IEnvelopeDecorator<E> m_eDec;
    private final Envelope m_bounds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskRGIndex(File inFile, IPersistenceDecorator<E> pDec, IEnvelopeDecorator<E> eDec) throws FileNotFoundException {
        Envelope eBounds;
        this.m_inFile = inFile;
        this.m_pDec = pDec;
        this.m_eDec = eDec;
        try (DiskRGHelper helper = new DiskRGHelper(DiskRGHelper.AccessMode.READ_ONLY, this.m_inFile, this.m_pDec);){
            eBounds = helper.getRootNode().getBounds();
        }
        this.m_bounds = new Envelope(eBounds.getLLX(), eBounds.getLLY(), eBounds.getURX(), eBounds.getURY(), SI);
    }

    @Override
    public IRGIterator<E> search(Envelope searchArea) throws DataAccessRuntimeException {
        if (Double.isInfinite(searchArea.getLLX()) || Double.isInfinite(searchArea.getLLY()) || Double.isInfinite(searchArea.getURX()) || Double.isInfinite(searchArea.getURY()) || !this.m_bounds.intersects(searchArea)) {
            return new EmptyIterator();
        }
        DiskRGHelper helper = new DiskRGHelper(DiskRGHelper.AccessMode.READ_ONLY, this.m_inFile, this.m_pDec);
        return new BreadthFirstRGIterator(helper, this.m_eDec, searchArea);
    }

    public Envelope getBounds() {
        return this.m_bounds;
    }

    private static class EmptyIterator<E>
    implements IRGIterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    private static class BreadthFirstRGIterator<E>
    implements IRGIterator<E> {
        private Iterator<E> m_iterator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BreadthFirstRGIterator(DiskRGHelper helper, IEnvelopeDecorator<E> eDec, Envelope searchArea) {
            try {
                Envelope env = new Envelope(IndexUtils.SI);
                env.extend(searchArea);
                LinkedList<DiskNode> nodesToSearch = new LinkedList<DiskNode>();
                LinkedList results = new LinkedList();
                nodesToSearch.add(helper.getRootNode());
                while (!nodesToSearch.isEmpty()) {
                    DiskNode node = (DiskNode)nodesToSearch.remove();
                    if (node.isLeaf()) {
                        results.addAll(node.getIntersectingChildren(env, eDec));
                        continue;
                    }
                    nodesToSearch.addAll(node.getIntersectingChildren(env, eDec));
                }
                this.m_iterator = results.iterator();
            }
            finally {
                helper.close();
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_iterator.hasNext();
        }

        @Override
        public E next() {
            return this.m_iterator.next();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class RGIterator<E>
    implements IRGIterator<E> {
        private final DiskRGHelper m_helper;
        private final RTreeCursor<E> m_cursor;

        public RGIterator(DiskRGHelper helper, IEnvelopeDecorator<E> eDec, Envelope searchArea) {
            this.m_helper = helper;
            RTree tree = new RTree(eDec, (IRTreeHelper)helper);
            Envelope env = new Envelope(IndexUtils.SI);
            env.extend(searchArea);
            this.m_cursor = tree.search((IRTreeEnvelopeSearch)new RTreeEnvelopeSearch(env));
        }

        @Override
        public boolean hasNext() throws DataAccessRuntimeException {
            return this.m_cursor.hasNext();
        }

        @Override
        public E next() throws DataAccessRuntimeException {
            return (E)this.m_cursor.next();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.m_helper.close();
        }
    }
}

