/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.BreadthIterator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.ChildInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskNode;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGHelper;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskStructureOperations;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.RootInfo;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DiskRGIndexSorter<E> {
    private final File m_originalIndexFile;
    private final File m_sortedIndexFile;
    private final IPersistenceDecorator<E> m_pDec;
    private Map<Integer, Integer> m_positionMappings = new HashMap<Integer, Integer>();

    public DiskRGIndexSorter(File originalIndexFile, File sortedIndexFile, IPersistenceDecorator<E> pDec) {
        this.m_originalIndexFile = originalIndexFile;
        this.m_sortedIndexFile = sortedIndexFile;
        this.m_pDec = pDec;
    }

    public void createSortedIndex() {
        DiskRGHelper originalHelper = null;
        DiskRGHelper sortedHelper = null;
        try {
            originalHelper = new DiskRGHelper(DiskRGHelper.AccessMode.READ_ONLY, this.m_originalIndexFile, this.m_pDec);
            sortedHelper = new DiskRGHelper(DiskRGHelper.AccessMode.CREATE, this.m_sortedIndexFile, this.m_pDec);
            this.writeIndexStructure(originalHelper, sortedHelper);
            this.updateIndexPointers(originalHelper, sortedHelper);
            sortedHelper.getDiskOperations().updateRootInfo(new RootInfo(sortedHelper.getRootNode().getPosition(), originalHelper.getRootNode().getBounds(), originalHelper.getRootNode().getLevel()));
        }
        finally {
            if (sortedHelper != null) {
                sortedHelper.close();
            }
            if (originalHelper != null) {
                originalHelper.close();
            }
        }
    }

    private void updateIndexPointers(DiskRGHelper originalHelper, DiskRGHelper sortedHelper) {
        DiskStructureOperations sortedOps = sortedHelper.getDiskOperations();
        DiskStructureOperations originalOps = originalHelper.getDiskOperations();
        BreadthIterator progress = new BreadthIterator(originalHelper.getRootNode());
        while (progress.hasNextNode()) {
            DiskNode node = progress.nextNode();
            if (node.isLeaf()) continue;
            Integer originalPos = new Integer(node.getPosition());
            Integer newPos = this.m_positionMappings.get(originalPos);
            List<ChildInfo> originalChildren = originalOps.readIndexBlock(originalPos);
            int nextChildIndex = 0;
            for (ChildInfo originalChild : originalChildren) {
                Integer newChildPos = this.m_positionMappings.get(new Integer(originalChild.getPosition()));
                sortedOps.writeIndexChild(newPos, nextChildIndex + 1, nextChildIndex, new ChildInfo(originalChild.getBounds(), newChildPos));
                ++nextChildIndex;
            }
        }
    }

    private void writeIndexStructure(DiskRGHelper originalHelper, DiskRGHelper sortedHelper) {
        DiskStructureOperations sortedOps = sortedHelper.getDiskOperations();
        BreadthIterator progress = new BreadthIterator(originalHelper.getRootNode());
        while (progress.hasNextNode()) {
            DiskNode node = progress.nextNode();
            int pos = this.allocateBlockForNode(sortedHelper, sortedOps, node);
            this.m_positionMappings.put(new Integer(node.getPosition()), new Integer(pos));
            if (!node.isLeaf()) continue;
            int childCnt = node.size();
            for (int i = 0; i < childCnt; ++i) {
                sortedOps.addLeafChild(pos, node.getChild(i));
            }
        }
    }

    private int allocateBlockForNode(DiskRGHelper sortedHelper, DiskStructureOperations sortedOps, DiskNode node) {
        int pos = node.isRoot() ? sortedHelper.getRootNode().getPosition() : sortedOps.allocateBlock();
        return pos;
    }
}

