/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.BlockInfo;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.GeneralBlockOperations;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;

class LeafBlockOperations {
    private static final int BYTES_PER_INT = 4;
    private static final int DATA_BLOCK_HEADER_SIZE = 6;
    private static final int EOF = -1;
    private final byte[] m_emptyBlockBytes;
    private final IRandomDataInputOutputStream m_stream;
    private final IPersistenceDecorator m_pDec;
    private final int m_maxDataBytesPerBlock;

    public LeafBlockOperations(BlockInfo blockInfo, IRandomDataInputOutputStream stream, IPersistenceDecorator pDec) {
        this.m_stream = stream;
        this.m_pDec = pDec;
        this.m_emptyBlockBytes = new byte[blockInfo.getBlockSize() - 6];
        this.m_maxDataBytesPerBlock = this.m_emptyBlockBytes.length;
    }

    public void clear(int pos, GeneralBlockOperations blockOps) {
        try {
            this.m_stream.seek(pos);
            int nextPos = this.m_stream.readInt();
            this.initializeBlock(pos);
            this.deallocateChain(nextPos, blockOps);
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public List read(int pos) {
        try {
            ArrayList result = new ArrayList();
            byte[] bytes = this.collectBytes(pos);
            if (bytes.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                PushbackInputStream pbis = new PushbackInputStream(bais);
                DataInputStream dis = new DataInputStream(pbis);
                while (this.hasMoreData(pbis)) {
                    result.add(this.m_pDec.readSingle(dis));
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public void addChild(int pos, Object data, GeneralBlockOperations blockOps) {
        try {
            byte[] dataBytes = this.calcDataBytes(data);
            int bytesWritten = 0;
            while ((bytesWritten += this.writeBytes(pos, dataBytes, bytesWritten)) < dataBytes.length) {
                this.m_stream.seek(pos);
                int nextPtr = this.m_stream.readInt();
                if (nextPtr == Integer.MIN_VALUE) {
                    int prevPos = pos;
                    pos = blockOps.allocateBlock();
                    this.initializeBlock(pos);
                    this.updateNextBlockPtr(prevPos, pos);
                    continue;
                }
                pos = nextPtr;
            }
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    public void initializeBlock(int pos) {
        try {
            this.m_stream.seek(pos);
            this.m_stream.writeInt(Integer.MIN_VALUE);
            this.m_stream.writeShort(0);
            this.m_stream.write(this.m_emptyBlockBytes);
        }
        catch (IOException e) {
            throw new FatalDataAccessRuntimeException(new FatalDataAccessException(2102, (Throwable)e));
        }
    }

    private void deallocateChain(int pos, GeneralBlockOperations blockOps) throws IOException {
        while (pos != Integer.MIN_VALUE) {
            this.m_stream.seek(pos);
            int nextPos = this.m_stream.readInt();
            blockOps.deallocateBlock(pos);
            pos = nextPos;
        }
    }

    private byte[] collectBytes(int pos) throws IOException {
        byte[] tmpBuf = new byte[this.m_maxDataBytesPerBlock];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int nextBlock = pos;
        while (nextBlock != Integer.MIN_VALUE) {
            this.m_stream.seek(nextBlock);
            nextBlock = this.m_stream.readInt();
            short numBytes = this.m_stream.readShort();
            if (numBytes <= 0) continue;
            this.m_stream.readFully(tmpBuf, 0, numBytes);
            baos.write(tmpBuf, 0, numBytes);
        }
        return baos.toByteArray();
    }

    private int writeBytes(int pos, byte[] dataBytes, int offset) throws IOException {
        int neededBytes = dataBytes.length - offset;
        this.m_stream.seek(pos + 4);
        short usedBytes = this.m_stream.readShort();
        int availableBytes = this.m_maxDataBytesPerBlock - usedBytes;
        int bytesToWrite = Math.min(neededBytes, availableBytes);
        if (bytesToWrite > 0) {
            this.m_stream.seek(pos + 4);
            this.m_stream.writeShort(usedBytes + bytesToWrite);
            this.m_stream.skipBytes(usedBytes);
            this.m_stream.write(dataBytes, offset, bytesToWrite);
        }
        return bytesToWrite;
    }

    private void updateNextBlockPtr(int pos, int ptr) throws IOException {
        this.m_stream.seek(pos);
        this.m_stream.writeInt(ptr);
    }

    private byte[] calcDataBytes(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.m_pDec.writeSingle(dos, o);
        dos.flush();
        baos.flush();
        return baos.toByteArray();
    }

    private boolean hasMoreData(PushbackInputStream pbis) throws IOException {
        int val = pbis.read();
        if (val == -1) {
            return false;
        }
        pbis.unread(val);
        return true;
    }
}

