/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.index.spatial.binary;

import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SpatialIndexValue {
    public static final long NO_OFFSET = -1L;
    private static final SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    public static final short ALL_SUBOBJECTS = -1;
    private long m_streetOffset = -1L;
    private short m_segmentNumber = (short)-1;
    private short m_firstRangeNumber = (short)-1;
    private short m_lastRangeNumber = (short)-1;
    private Envelope m_bounds = null;
    private String m_dataFileBaseName;

    public void setStreetOffset(long streetOffset) {
        this.m_streetOffset = streetOffset;
    }

    public long getStreetOffset() {
        return this.m_streetOffset;
    }

    public void setSegmentNumber(short segmentNumber) {
        this.m_segmentNumber = segmentNumber;
    }

    public short getSegmentNumber() {
        return this.m_segmentNumber;
    }

    public void setRangeNumber(short rangeNumber) {
        this.m_firstRangeNumber = rangeNumber;
        this.m_lastRangeNumber = rangeNumber;
    }

    private void setFirstRangeNumber(short firstRangeNumber) {
        this.m_firstRangeNumber = firstRangeNumber;
    }

    public short getFirstRangeNumber() {
        return this.m_firstRangeNumber;
    }

    private void setLastRangeNumber(short lastRangeNumber) {
        this.m_lastRangeNumber = lastRangeNumber;
    }

    public short getLastRangeNumber() {
        return this.m_lastRangeNumber;
    }

    public void addPoint(DirectPosition point) {
        if (this.m_bounds == null) {
            this.m_bounds = new Envelope(point, point, SPATIAL_INFO);
        } else if (!this.m_bounds.contains(point)) {
            this.m_bounds.extend(point);
        }
    }

    public void addRange(short rangeNumber, Envelope bounds) {
        if (rangeNumber != this.m_lastRangeNumber + 1) {
            throw new IllegalArgumentException();
        }
        this.m_lastRangeNumber = (short)(this.m_lastRangeNumber + 1);
        if (!this.m_bounds.contains(bounds)) {
            this.m_bounds.extend(bounds);
        }
    }

    public Envelope getBounds() {
        return this.m_bounds;
    }

    public void write(DataOutput sink) throws IOException {
        if (this.getStreetOffset() == -1L || this.getBounds() == null) {
            throw new IllegalStateException("getStreetOffset(): " + this.getStreetOffset() + "\tgetBounds() null? " + (this.getBounds() == null));
        }
        sink.writeLong(this.getStreetOffset());
        sink.writeShort(this.getSegmentNumber());
        sink.writeShort(this.getFirstRangeNumber());
        if (this.getFirstRangeNumber() != -1) {
            sink.writeShort(this.getLastRangeNumber());
        }
        sink.writeDouble(this.m_bounds.getLLX());
        sink.writeDouble(this.m_bounds.getLLY());
        sink.writeDouble(this.m_bounds.getURX());
        sink.writeDouble(this.m_bounds.getURY());
    }

    public void read(DataInput source) throws IOException {
        this.setStreetOffset(source.readLong());
        this.setSegmentNumber(source.readShort());
        this.setFirstRangeNumber(source.readShort());
        if (this.getFirstRangeNumber() != -1) {
            this.setLastRangeNumber(source.readShort());
        } else {
            this.setLastRangeNumber((short)-1);
        }
        this.m_bounds = new Envelope(source.readDouble(), source.readDouble(), source.readDouble(), source.readDouble(), SPATIAL_INFO);
    }

    public void setDataFileBaseName(String dataFileBaseName) {
        this.m_dataFileBaseName = dataFileBaseName;
    }

    public String getDataFileBaseName() {
        return this.m_dataFileBaseName;
    }

    public List<AlternateDataRecord> toAlternateDataRecords() {
        if (this.getFirstRangeNumber() == this.getLastRangeNumber()) {
            AlternateDataRecord record = new AlternateDataRecord();
            record.setStreetOffset(this.getStreetOffset());
            record.setSegmentNumber(this.getSegmentNumber());
            record.setRangeNumber(this.getFirstRangeNumber());
            return Collections.singletonList(record);
        }
        ArrayList<AlternateDataRecord> records = new ArrayList<AlternateDataRecord>(this.getLastRangeNumber() - this.getFirstRangeNumber() + 1);
        for (short rangeNumber = this.getFirstRangeNumber(); rangeNumber <= this.getLastRangeNumber(); rangeNumber = (short)(rangeNumber + 1)) {
            AlternateDataRecord record = new AlternateDataRecord();
            record.setStreetOffset(this.getStreetOffset());
            record.setSegmentNumber(this.getSegmentNumber());
            record.setRangeNumber(rangeNumber);
            records.add(record);
        }
        return records;
    }
}

