/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.filters;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.filters.ICloseMatchFilterRule;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class NoInputHousePreferSegmentOverPointHouseFilter
implements ICloseMatchFilterRule {
    @Override
    public boolean demoteOther(Address[] inputAddresses, ICandidate best, ICandidate other) {
        if (!StringUtilities.isEmpty(inputAddresses[0].getAddressNumber())) {
            return false;
        }
        InternalCandidateAddress bestCandidate = (InternalCandidateAddress)best;
        InternalCandidateAddress otherCandidate = (InternalCandidateAddress)other;
        if (bestCandidate.getSegment().isHouseSegment() == otherCandidate.getSegment().isHouseSegment()) {
            return false;
        }
        if (bestCandidate.hasMatchingRange() || otherCandidate.hasMatchingRange()) {
            return false;
        }
        return !bestCandidate.getSegment().isHouseSegment();
    }
}

